/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.sql.SQLException;
import java.util.List;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.ldn.model.NotifyRequestStatus;
import org.dspace.app.ldn.service.LDNMessageService;
import org.dspace.app.rest.DiscoverableEndpointsService;
import org.dspace.app.rest.converter.ConverterService;
import org.dspace.app.rest.model.NotifyRequestStatusRest;
import org.dspace.app.rest.utils.ContextUtil;
import org.dspace.app.rest.utils.Utils;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.Item;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.hateoas.Link;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/ldn/notifyrequests/{uuid:[0-9a-fxA-FX]{8}-[0-9a-fxA-FX]{4}-[0-9a-fxA-FX]{4}-[0-9a-fxA-FX]{4}-[0-9a-fxA-FX]{12}}"})
public class NotifyRequestStatusRestController
implements InitializingBean {
    private static final Logger log = LogManager.getLogger(NotifyRequestStatusRestController.class);
    @Autowired
    private ConverterService converterService;
    @Autowired
    private Utils utils;
    @Autowired
    private LDNMessageService ldnMessageService;
    @Autowired
    private ItemService itemService;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private DiscoverableEndpointsService discoverableEndpointsService;

    public void afterPropertiesSet() {
        this.discoverableEndpointsService.register(this, List.of(Link.of((String)"/api/ldn/notifyrequests", (String)"notifyrequests")));
    }

    @GetMapping(produces={"application/json"})
    @PreAuthorize(value="hasAuthority('AUTHENTICATED')")
    public ResponseEntity<String> findByItem(@PathVariable UUID uuid) throws SQLException, AuthorizeException, JsonProcessingException {
        Context context = ContextUtil.obtainCurrentRequestContext();
        Item item = (Item)this.itemService.find(context, uuid);
        if (item == null) {
            throw new ResourceNotFoundException("No such item: " + uuid);
        }
        EPerson currentUser = context.getCurrentUser();
        if (!currentUser.equals((Object)item.getSubmitter()) && !this.authorizeService.isAdmin(context)) {
            throw new AuthorizeException("User unauthorized");
        }
        NotifyRequestStatus resultRequests = this.ldnMessageService.findRequestsByItem(context, item);
        NotifyRequestStatusRest resultRequestStatusRests = (NotifyRequestStatusRest)this.converterService.toRest(resultRequests, this.utils.obtainProjection());
        context.complete();
        String result = new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)resultRequestStatusRests);
        return new ResponseEntity((Object)result, (HttpStatusCode)HttpStatus.OK);
    }
}

