/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.rdf.providing;

import com.hp.hpl.jena.rdf.model.Model;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.sql.SQLException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.dspace.handle.factory.HandleServiceFactory;
import org.dspace.handle.service.HandleService;
import org.dspace.rdf.RDFUtil;
import org.dspace.services.factory.DSpaceServicesFactory;

public class DataProviderServlet
extends HttpServlet {
    protected static final String DEFAULT_LANG = "TURTLE";
    private static final Logger log = LogManager.getLogger(DataProviderServlet.class);
    protected final transient HandleService handleService = HandleServiceFactory.getInstance().getHandleService();

    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        request.setCharacterEncoding("UTF-8");
        String lang = this.detectLanguage(request);
        String cType = this.detectContentType(request, lang);
        String pathInfo = request.getPathInfo();
        log.debug("lang = " + lang + ", cType = " + cType + " and pathInfo: " + pathInfo);
        if (StringUtils.isEmpty((CharSequence)pathInfo) || StringUtils.countMatches((CharSequence)pathInfo, (CharSequence)"/") < 2) {
            String dspaceURI = DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("dspace.ui.url");
            this.serveNamedGraph(dspaceURI, lang, cType, response);
            return;
        }
        String[] path = request.getPathInfo().substring(1).split("/");
        assert (path.length >= 2);
        String handle = path[0] + "/" + path[1];
        log.debug("Handle: " + handle + ".");
        Context context = null;
        DSpaceObject dso = null;
        try {
            context = new Context(Context.Mode.READ_ONLY);
            dso = this.handleService.resolveToObject(context, handle);
        }
        catch (SQLException ex) {
            log.error("SQLException: " + ex.getMessage(), (Throwable)ex);
            context.abort();
            response.sendError(503);
            return;
        }
        catch (IllegalStateException ex) {
            log.error("Cannot resolve handle " + handle + ". IllegalStateException:" + ex.getMessage(), (Throwable)ex);
            context.abort();
            response.sendError(400);
            return;
        }
        if (dso == null) {
            log.info("Cannot resolve handle '" + handle + "' to dso. => 404");
            context.abort();
            response.sendError(404);
            return;
        }
        String identifier = null;
        try {
            identifier = RDFUtil.generateIdentifier((Context)context, (DSpaceObject)dso);
        }
        catch (SQLException ex) {
            log.error("SQLException: " + ex.getMessage(), (Throwable)ex);
            context.abort();
            response.sendError(503);
            return;
        }
        if (identifier == null) {
            log.error("Cannot generate identifier for UUID " + dso.getID().toString() + "!");
            context.abort();
            response.sendError(500);
            return;
        }
        log.debug("Loading and sending named graph " + identifier + ".");
        context.abort();
        this.serveNamedGraph(identifier, lang, cType, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void serveNamedGraph(String uri, String lang, String contentType, HttpServletResponse response) throws ServletException, IOException {
        Model result = null;
        result = RDFUtil.loadModel((String)uri);
        if (result == null || result.isEmpty()) {
            response.sendError(404);
            if (result != null) {
                result.close();
            }
            log.info("Sent 404 Not Found, as the loaded model was null or empty (URI: " + uri + ").");
            return;
        }
        response.setContentType(contentType);
        PrintWriter out = response.getWriter();
        log.debug("Set content-type to " + contentType + ".");
        try {
            result.write((Writer)out, lang);
        }
        finally {
            result.close();
            out.close();
        }
    }

    protected String detectContentType(HttpServletRequest request, String lang) {
        if (request.getParameter("text") != null) {
            return "text/plain;charset=UTF-8";
        }
        if (lang.equalsIgnoreCase(DEFAULT_LANG)) {
            return "text/turtle;charset=UTF-8";
        }
        if (lang.equalsIgnoreCase("n3")) {
            return "text/n3;charset=UTF-8";
        }
        if (lang.equalsIgnoreCase("RDF/XML")) {
            return "application/rdf+xml;charset=UTF-8";
        }
        if (lang.equalsIgnoreCase("N-TRIPLE")) {
            return "application/n-triples;charset=UTF-8";
        }
        throw new IllegalStateException("Cannot set content type for unknown language.");
    }

    protected String detectLanguage(HttpServletRequest request) {
        String pathInfo = request.getPathInfo();
        if (StringUtils.isEmpty((CharSequence)pathInfo)) {
            return DEFAULT_LANG;
        }
        String[] path = request.getPathInfo().split("/");
        String lang = path[path.length - 1];
        if (StringUtils.endsWithIgnoreCase((CharSequence)lang, (CharSequence)"ttl")) {
            return DEFAULT_LANG;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)lang, (CharSequence)"n3")) {
            return "N3";
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)lang, (CharSequence)"rdf") || StringUtils.equalsIgnoreCase((CharSequence)lang, (CharSequence)"xml")) {
            return "RDF/XML";
        }
        if (StringUtils.endsWithIgnoreCase((CharSequence)lang, (CharSequence)"nt")) {
            return "N-TRIPLE";
        }
        return DEFAULT_LANG;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public String getServletInfo() {
        return "Serves repository content as rdf serialization (RDF/XML, Turtle, N-Triples and N3).";
    }
}

