/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.dspace.app.bulkedit.DSpaceCSV;
import org.dspace.app.bulkedit.MetadataExport;
import org.dspace.app.webui.servlet.DSpaceServlet;
import org.dspace.app.webui.util.JSPManager;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.ItemIterator;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.handle.HandleManager;

public class MetadataExportServlet
extends DSpaceServlet {
    private static Logger log = Logger.getLogger(MetadataExportServlet.class);

    @Override
    protected void doDSPost(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        String handle = request.getParameter("handle");
        MetadataExport exporter = null;
        if (handle != null) {
            log.info((Object)LogManager.getHeader((Context)context, (String)"metadataexport", (String)("exporting_handle:" + handle)));
            DSpaceObject thing = HandleManager.resolveToObject((Context)context, (String)handle);
            if (thing != null) {
                if (thing.getType() == 2) {
                    ArrayList<Integer> item = new ArrayList<Integer>();
                    item.add(thing.getID());
                    exporter = new MetadataExport(context, new ItemIterator(context, item), false);
                } else if (thing.getType() == 3) {
                    Collection collection = (Collection)thing;
                    ItemIterator toExport = collection.getAllItems();
                    exporter = new MetadataExport(context, toExport, false);
                } else if (thing.getType() == 4) {
                    exporter = new MetadataExport(context, (Community)thing, false);
                }
                if (exporter != null) {
                    DSpaceCSV csv = exporter.export();
                    response.setContentType("text/csv; charset=UTF-8");
                    String filename = handle.replaceAll("/", "-") + ".csv";
                    response.setHeader("Content-Disposition", "attachment; filename=" + filename);
                    PrintWriter out = response.getWriter();
                    out.write(csv.toString());
                    out.flush();
                    out.close();
                    log.info((Object)LogManager.getHeader((Context)context, (String)"metadataexport", (String)("exported_file:" + filename)));
                    return;
                }
            }
        }
        JSPManager.showIntegrityError(request, response);
    }
}

