/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.importer.external.metadatamapping.contributor;

import com.fasterxml.jackson.databind.JsonNode;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.importer.external.metadatamapping.contributor.AbstractJsonPathMetadataProcessor;

public class RegexReplacingJsonPathMetadataProcessor
extends AbstractJsonPathMetadataProcessor {
    private static final Logger log = LogManager.getLogger(RegexReplacingJsonPathMetadataProcessor.class);
    private String path;
    private String regexPattern;
    private String replacement;

    @Override
    protected String getStringValue(JsonNode node) {
        if (node == null || !node.isTextual()) {
            throw new IllegalArgumentException("Input must be a non-null JsonNode containing a text value");
        }
        String idStr = node.asText();
        if (this.regexPattern == null || this.regexPattern.isEmpty() || this.replacement == null) {
            return idStr;
        }
        return idStr.replaceAll(this.regexPattern, this.replacement);
    }

    @Override
    protected Logger getLogger() {
        return log;
    }

    @Override
    protected String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setRegexPattern(String regexPattern) {
        this.regexPattern = regexPattern;
    }

    public void setReplacement(String replacement) {
        this.replacement = replacement;
    }
}

