/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.handle;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.dspace.content.DSpaceObject;
import org.dspace.content.service.SiteService;
import org.dspace.core.Constants;
import org.dspace.core.Context;
import org.dspace.handle.Handle;
import org.dspace.handle.dao.HandleDAO;
import org.dspace.handle.service.HandleService;
import org.dspace.services.ConfigurationService;
import org.springframework.beans.factory.annotation.Autowired;

public class HandleServiceImpl
implements HandleService {
    private static final Logger log = LogManager.getLogger();
    static final String EXAMPLE_PREFIX = "123456789";
    @Autowired(required=true)
    protected HandleDAO handleDAO;
    @Autowired(required=true)
    protected ConfigurationService configurationService;
    @Autowired
    protected SiteService siteService;
    private static final Pattern[] IDENTIFIER_PATTERNS = new Pattern[]{Pattern.compile("^hdl:(.*)$"), Pattern.compile("^info:hdl/(.*)$"), Pattern.compile("^https?://hdl\\.handle\\.net/(.*)$"), Pattern.compile("^https?://.+/handle/(.*)$")};

    protected HandleServiceImpl() {
    }

    @Override
    public String resolveToURL(Context context, String handle) throws SQLException {
        Handle dbhandle = this.findHandleInternal(context, handle);
        if (dbhandle == null) {
            return null;
        }
        String url = this.configurationService.getProperty("dspace.ui.url") + "/handle/" + handle;
        log.debug("Resolved {} to {}", (Object)handle, (Object)url);
        return url;
    }

    @Override
    public String resolveUrlToHandle(Context context, String url) throws SQLException {
        String dspaceUrl = this.configurationService.getProperty("dspace.ui.url") + "/handle/";
        String handleResolver = this.getCanonicalPrefix();
        String handle = null;
        if (url.startsWith(dspaceUrl)) {
            handle = url.substring(dspaceUrl.length());
        }
        if (url.startsWith(handleResolver)) {
            handle = url.substring(handleResolver.length());
        }
        if (null == handle) {
            return null;
        }
        while (handle.startsWith("/")) {
            handle = handle.substring(1);
        }
        Handle dbhandle = this.findHandleInternal(context, handle);
        return null == dbhandle ? null : handle;
    }

    @Override
    public String getCanonicalPrefix() {
        String handlePrefix = this.configurationService.getProperty("handle.canonical.prefix", "https://hdl.handle.net/");
        return handlePrefix;
    }

    @Override
    public String getCanonicalForm(String handle) {
        return this.getCanonicalPrefix() + handle;
    }

    @Override
    public String createHandle(Context context, DSpaceObject dso) throws SQLException {
        Handle handle = this.handleDAO.create(context, new Handle());
        String handleId = this.createId(context);
        handle.setHandle(handleId);
        handle.setDSpaceObject(dso);
        dso.addHandle(handle);
        handle.setResourceTypeId(dso.getType());
        this.handleDAO.save(context, handle);
        log.debug("Created new handle for {} (ID={}) {}", new Supplier[]{() -> Constants.typeText[dso.getType()], () -> dso.getID(), () -> handleId});
        return handleId;
    }

    @Override
    public String createHandle(Context context, DSpaceObject dso, String suppliedHandle) throws SQLException, IllegalStateException {
        return this.createHandle(context, dso, suppliedHandle, false);
    }

    @Override
    public String createHandle(Context context, DSpaceObject dso, String suppliedHandle, boolean force) throws SQLException, IllegalStateException {
        Handle handle = this.findHandleInternal(context, suppliedHandle);
        if (handle != null && handle.getDSpaceObject() != null) {
            if (handle.getDSpaceObject().getID().equals(dso.getID())) {
                return suppliedHandle;
            }
            throw new IllegalStateException("Attempted to create a handle which is already in use: " + suppliedHandle);
        }
        if (handle != null && handle.getResourceTypeId() != null) {
            int previousType = handle.getResourceTypeId();
            if (previousType != dso.getType()) {
                throw new IllegalStateException("Attempted to reuse a handle previously used by a " + Constants.typeText[previousType] + " for a new " + Constants.typeText[dso.getType()]);
            }
        } else if (handle == null) {
            handle = this.handleDAO.create(context, new Handle());
            handle.setHandle(suppliedHandle);
        }
        handle.setResourceTypeId(dso.getType());
        handle.setDSpaceObject(dso);
        dso.addHandle(handle);
        this.handleDAO.save(context, handle);
        log.debug("Created new handle for {} (ID={}) {}", new Supplier[]{() -> Constants.typeText[dso.getType()], () -> dso.getID(), () -> suppliedHandle});
        return suppliedHandle;
    }

    @Override
    public void unbindHandle(Context context, DSpaceObject dso) throws SQLException {
        Iterator<Handle> handles = dso.getHandles().iterator();
        if (handles.hasNext()) {
            while (handles.hasNext()) {
                Handle handle = handles.next();
                handles.remove();
                handle.setDSpaceObject(null);
                this.handleDAO.save(context, handle);
                log.debug("Unbound Handle {} from object {} id={}", new Supplier[]{() -> handle.getHandle(), () -> Constants.typeText[dso.getType()], () -> dso.getID()});
            }
        } else {
            log.trace("Cannot find Handle entry to unbind for object {} id={}. Handle could have been unbound before.", (Object)Constants.typeText[dso.getType()], (Object)dso.getID());
        }
    }

    @Override
    public DSpaceObject resolveToObject(Context context, String handle) throws IllegalStateException, SQLException {
        Handle dbhandle = this.findHandleInternal(context, handle);
        if (dbhandle == null || dbhandle.getDSpaceObject() == null || dbhandle.getResourceTypeId() == null) {
            return null;
        }
        return dbhandle.getDSpaceObject();
    }

    @Override
    public String findHandle(Context context, DSpaceObject dso) throws SQLException {
        List<Handle> handles = dso.getHandles();
        if (CollectionUtils.isEmpty(handles)) {
            return null;
        }
        String result = handles.iterator().next().getHandle();
        for (Handle handle : handles) {
            if (handle.getHandle().matches(".*/.*\\.\\d+")) continue;
            result = handle.getHandle();
        }
        return result;
    }

    @Override
    public List<String> getHandlesForPrefix(Context context, String prefix) throws SQLException {
        List<Handle> handles = this.handleDAO.findByPrefix(context, prefix);
        ArrayList<String> handleStrings = new ArrayList<String>(handles.size());
        for (Handle handle : handles) {
            handleStrings.add(handle.getHandle());
        }
        return handleStrings;
    }

    @Override
    public String getPrefix() {
        String prefix = this.configurationService.getProperty("handle.prefix");
        if (StringUtils.isBlank((CharSequence)prefix)) {
            prefix = EXAMPLE_PREFIX;
            log.error("handle.prefix is not configured; using {}", (Object)prefix);
        }
        return prefix;
    }

    @Override
    public long countHandlesByPrefix(Context context, String prefix) throws SQLException {
        return this.handleDAO.countHandlesByPrefix(context, prefix);
    }

    @Override
    public int updateHandlesWithNewPrefix(Context context, String newPrefix, String oldPrefix) throws SQLException {
        return this.handleDAO.updateHandlesWithNewPrefix(context, newPrefix, oldPrefix);
    }

    @Override
    public void modifyHandleDSpaceObject(Context context, String handle, DSpaceObject newOwner) throws SQLException {
        Handle dbHandle = this.findHandleInternal(context, handle);
        if (dbHandle != null) {
            if (dbHandle.getDSpaceObject() != null) {
                dbHandle.getDSpaceObject().getHandles().remove(dbHandle);
            }
            dbHandle.setDSpaceObject(newOwner);
            dbHandle.setResourceTypeId(newOwner.getType());
            newOwner.getHandles().add(0, dbHandle);
            this.handleDAO.save(context, dbHandle);
        }
    }

    protected Handle findHandleInternal(Context context, String handle) throws SQLException {
        if (handle == null) {
            throw new IllegalArgumentException("Handle is null");
        }
        return this.handleDAO.findByHandle(context, handle);
    }

    protected String createId(Context context) throws SQLException {
        String handlePrefix = this.getPrefix();
        Long handleSuffix = this.handleDAO.getNextHandleSuffix(context);
        return handlePrefix + (handlePrefix.endsWith("/") ? "" : "/") + handleSuffix.toString();
    }

    @Override
    public int countTotal(Context context) throws SQLException {
        return this.handleDAO.countRows(context);
    }

    @Override
    public String parseHandle(String identifier) {
        String[] additionalPrefixes;
        if (identifier == null) {
            return null;
        }
        if (identifier.startsWith(this.getPrefix() + "/")) {
            return identifier;
        }
        String canonicalPrefix = this.configurationService.getProperty("handle.canonical.prefix");
        if (identifier.startsWith(canonicalPrefix + "/")) {
            return StringUtils.stripStart((String)identifier, (String)canonicalPrefix);
        }
        for (Pattern pattern : IDENTIFIER_PATTERNS) {
            Matcher matcher = pattern.matcher(identifier);
            if (!matcher.matches()) continue;
            return matcher.group(1);
        }
        for (String additionalPrefix : additionalPrefixes = this.getAdditionalPrefixes()) {
            if (!identifier.startsWith(additionalPrefix + "/")) continue;
            return identifier;
        }
        return null;
    }

    @Override
    public String[] getAdditionalPrefixes() {
        return this.configurationService.getArrayProperty("handle.additional.prefixes");
    }
}

