/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.checker;

import java.io.FileNotFoundException;
import java.sql.SQLException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.UUID;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.checker.BitstreamDispatcher;
import org.dspace.checker.CheckerCommand;
import org.dspace.checker.HandleDispatcher;
import org.dspace.checker.IteratorDispatcher;
import org.dspace.checker.LimitedCountDispatcher;
import org.dspace.checker.LimitedDurationDispatcher;
import org.dspace.checker.ResultsLogger;
import org.dspace.checker.ResultsPruner;
import org.dspace.checker.SimpleDispatcher;
import org.dspace.content.Bitstream;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.BitstreamService;
import org.dspace.core.Context;
import org.dspace.core.Utils;

public final class ChecksumChecker {
    private static final Logger LOG = LogManager.getLogger(ChecksumChecker.class);
    private static final BitstreamService bitstreamService = ContentServiceFactory.getInstance().getBitstreamService();

    private ChecksumChecker() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws SQLException {
        DefaultParser parser = new DefaultParser();
        CommandLine line = null;
        Options options = new Options();
        options.addOption("l", "looping", false, "Loop once through bitstreams");
        options.addOption("L", "continuous", false, "Loop continuously through bitstreams");
        options.addOption("h", "help", false, "Help");
        options.addOption("d", "duration", true, "Checking duration");
        options.addOption("c", "count", true, "Check count");
        options.addOption("i", "handle", true, "Specify a handle to check");
        options.addOption("v", "verbose", false, "Report all processing");
        Option option = Option.builder((String)"b").longOpt("bitstream-ids").hasArgs().desc("Space separated list of bitstream UUIDs").build();
        options.addOption(option);
        option = Option.builder((String)"p").longOpt("prune").optionalArg(true).desc("Prune old results (optionally using specified properties file for configuration)").build();
        options.addOption(option);
        try {
            line = parser.parse(options, args);
        }
        catch (ParseException e) {
            LOG.fatal((Object)e);
            System.exit(1);
        }
        if (line.hasOption('h')) {
            ChecksumChecker.printHelp(options);
        }
        Context context = null;
        try {
            context = new Context();
            int mutuallyExclusiveOpts = 0;
            for (char c : new char[]{'l', 'L', 'd', 'b', 'i', 'c'}) {
                if (!line.hasOption(c)) continue;
                ++mutuallyExclusiveOpts;
            }
            if (mutuallyExclusiveOpts > 1) {
                System.err.println("Please use only one option of -l, -L, -d, -b, -i, or -c");
                LOG.error("Please use only one option of -l, -L, -d, -b, -i, or -c");
                System.exit(1);
            }
            if (line.hasOption('p')) {
                ResultsPruner rp = null;
                try {
                    rp = line.getOptionValue('p') != null ? ResultsPruner.getPruner(context, line.getOptionValue('p')) : ResultsPruner.getDefaultPruner(context);
                }
                catch (FileNotFoundException e) {
                    LOG.error("File not found", (Throwable)e);
                    System.exit(1);
                }
                int count = rp.prune();
                System.out.println("Pruned " + count + " old results from the database.");
            }
            Instant processStart = Instant.now();
            BitstreamDispatcher dispatcher = null;
            if (line.hasOption('l')) {
                dispatcher = new SimpleDispatcher(context, processStart, false);
            } else if (line.hasOption('L')) {
                dispatcher = new SimpleDispatcher(context, processStart, true);
            } else if (line.hasOption('b')) {
                String[] ids = line.getOptionValues('b');
                ArrayList<Bitstream> bitstreams = new ArrayList<Bitstream>(ids.length);
                for (int i = 0; i < ids.length; ++i) {
                    try {
                        bitstreams.add(bitstreamService.find(context, UUID.fromString(ids[i])));
                        continue;
                    }
                    catch (NumberFormatException nfe) {
                        System.err.println("The following argument: " + ids[i] + " is not an UUID");
                        System.exit(0);
                    }
                }
                dispatcher = new IteratorDispatcher(bitstreams.iterator());
            } else if (line.hasOption('i')) {
                dispatcher = new HandleDispatcher(context, line.getOptionValue('i'));
            } else if (line.hasOption('d')) {
                try {
                    dispatcher = new LimitedDurationDispatcher(new SimpleDispatcher(context, processStart, true), Instant.ofEpochMilli(Instant.now().toEpochMilli() + Utils.parseDuration(line.getOptionValue('d'))));
                }
                catch (Exception e) {
                    System.err.println("Couldn't parse " + line.getOptionValue('d') + " as a duration");
                    LOG.fatal("Couldn't parse " + line.getOptionValue('d') + " as a duration: ", (Throwable)e);
                    System.exit(0);
                }
            } else if (line.hasOption('c')) {
                int count = Integer.valueOf(line.getOptionValue('c'));
                dispatcher = new LimitedCountDispatcher(new SimpleDispatcher(context, processStart, false), count);
            } else {
                dispatcher = new LimitedCountDispatcher(new SimpleDispatcher(context, processStart, false), 1);
            }
            ResultsLogger logger = new ResultsLogger(processStart);
            CheckerCommand checker = new CheckerCommand(context);
            if (line.hasOption('v')) {
                checker.setReportVerbose(true);
            }
            checker.setProcessStartDate(processStart);
            checker.setDispatcher(dispatcher);
            checker.setCollector(logger);
            checker.process();
            context.complete();
            context = null;
        }
        finally {
            if (context != null) {
                context.abort();
            }
        }
    }

    private static void printHelp(Options options) {
        HelpFormatter myhelp = new HelpFormatter();
        myhelp.printHelp("checker\n", options);
        System.out.println("\nChecksum Checker usage examples:");
        System.out.println("\nThe following options are mutually exclusive:");
        System.out.println(" - Specify a duration for checker process, using s(seconds),m(minutes), or h(hours): checker -d 30s OR checker -d 30m OR checker -d 2h");
        System.out.println(" - Specify bitstream UUIDs: checker -b 550e8400-e29b-41d4-a716-446655440000 f3f2e850-b5d4-11ef-ac7e-96584d5248b2");
        System.out.println(" - Specify handle: checker -i 12345/100");
        System.out.println(" - Loop once through all bitstreams: checker -l");
        System.out.println(" - Loop continuously through all bitstreams: checker -L");
        System.out.println(" - Check a defined number of bitstreams: checker -c 10");
        System.out.println("\nThe following options can be used in combination with others above:");
        System.out.println(" - Report all processing to checker.log (by default logs only errors): checker -v");
        System.out.println(" - Prune old results from the database: checker -p");
        System.out.println("\nDefault (no arguments) is equivalent to 'checker -c 1'\n");
        System.exit(0);
    }
}

