/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xmlworkflow.storedcomponents;

import java.sql.SQLException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.dspace.authorize.AuthorizeException;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.xmlworkflow.storedcomponents.ClaimedTask;
import org.dspace.xmlworkflow.storedcomponents.XmlWorkflowItem;
import org.dspace.xmlworkflow.storedcomponents.dao.ClaimedTaskDAO;
import org.dspace.xmlworkflow.storedcomponents.service.ClaimedTaskService;
import org.springframework.beans.factory.annotation.Autowired;

public class ClaimedTaskServiceImpl
implements ClaimedTaskService {
    @Autowired(required=true)
    protected ClaimedTaskDAO claimedTaskDAO;

    protected ClaimedTaskServiceImpl() {
    }

    @Override
    public ClaimedTask create(Context context) throws SQLException, AuthorizeException {
        return this.claimedTaskDAO.create(context, new ClaimedTask());
    }

    @Override
    public ClaimedTask find(Context context, int id) throws SQLException {
        return (ClaimedTask)this.claimedTaskDAO.findByID(context, ClaimedTask.class, id);
    }

    @Override
    public List<ClaimedTask> findAll(Context context) throws SQLException {
        return this.claimedTaskDAO.findAll(context, ClaimedTask.class);
    }

    @Override
    public void update(Context context, ClaimedTask claimedTask) throws SQLException, AuthorizeException {
        this.update(context, Collections.singletonList(claimedTask));
    }

    @Override
    public void update(Context context, List<ClaimedTask> claimedTasks) throws SQLException, AuthorizeException {
        if (CollectionUtils.isNotEmpty(claimedTasks)) {
            for (ClaimedTask claimedTask : claimedTasks) {
                this.claimedTaskDAO.save(context, claimedTask);
            }
        }
    }

    @Override
    public void delete(Context context, ClaimedTask claimedTask) throws SQLException, AuthorizeException {
        this.claimedTaskDAO.delete(context, claimedTask);
    }

    @Override
    public List<ClaimedTask> findByWorkflowItem(Context context, XmlWorkflowItem workflowItem) throws SQLException {
        return this.claimedTaskDAO.findByWorkflowItem(context, workflowItem);
    }

    @Override
    public ClaimedTask findByWorkflowIdAndEPerson(Context context, XmlWorkflowItem workflowItem, EPerson ePerson) throws SQLException {
        return this.claimedTaskDAO.findByWorkflowItemAndEPerson(context, workflowItem, ePerson);
    }

    @Override
    public List<ClaimedTask> findByEperson(Context context, EPerson ePerson) throws SQLException {
        return this.claimedTaskDAO.findByEperson(context, ePerson);
    }

    @Override
    public List<ClaimedTask> find(Context context, XmlWorkflowItem workflowItem, String stepID) throws SQLException {
        return this.claimedTaskDAO.findByWorkflowItemAndStepId(context, workflowItem, stepID);
    }

    @Override
    public ClaimedTask find(Context context, EPerson ePerson, XmlWorkflowItem workflowItem, String stepID, String actionID) throws SQLException {
        return this.claimedTaskDAO.findByEPersonAndWorkflowItemAndStepIdAndActionId(context, ePerson, workflowItem, stepID, actionID);
    }

    @Override
    public List<ClaimedTask> find(Context context, XmlWorkflowItem workflowItem, String stepID, String actionID) throws SQLException {
        return this.claimedTaskDAO.findByWorkflowItemAndStepIdAndActionId(context, workflowItem, stepID, actionID);
    }

    @Override
    public List<ClaimedTask> find(Context context, XmlWorkflowItem workflowItem) throws SQLException {
        return this.claimedTaskDAO.findByWorkflowItem(context, workflowItem);
    }

    @Override
    public List<ClaimedTask> findAllInStep(Context context, String stepID) throws SQLException {
        return this.claimedTaskDAO.findByStep(context, stepID);
    }

    @Override
    public void deleteByWorkflowItem(Context context, XmlWorkflowItem workflowItem) throws SQLException, AuthorizeException {
        List<ClaimedTask> claimedTasks = this.findByWorkflowItem(context, workflowItem);
        Iterator<ClaimedTask> iterator = claimedTasks.iterator();
        while (iterator.hasNext()) {
            ClaimedTask claimedTask = iterator.next();
            iterator.remove();
            this.delete(context, claimedTask);
        }
    }
}

