/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.importer.external.vufind;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.content.Item;
import org.dspace.importer.external.datamodel.ImportRecord;
import org.dspace.importer.external.datamodel.Query;
import org.dspace.importer.external.exception.MetadataSourceException;
import org.dspace.importer.external.liveimportclient.service.LiveImportClient;
import org.dspace.importer.external.service.AbstractImportMetadataSourceService;
import org.dspace.importer.external.service.components.QuerySource;
import org.springframework.beans.factory.annotation.Autowired;

public class VuFindImportMetadataSourceServiceImpl
extends AbstractImportMetadataSourceService<String>
implements QuerySource {
    private static final Logger log = LogManager.getLogger();
    private String url;
    private String urlSearch;
    private String fields;
    @Autowired
    private LiveImportClient liveImportClient;

    public VuFindImportMetadataSourceServiceImpl(String fields) {
        this.fields = fields;
    }

    @Override
    public String getImportSource() {
        return "VuFind";
    }

    @Override
    public ImportRecord getRecord(String id) throws MetadataSourceException {
        String records = this.retry(new GetByVuFindIdCallable(id, this.fields));
        List<ImportRecord> importRecords = this.extractMetadataFromRecordList(records);
        return importRecords != null && !importRecords.isEmpty() ? importRecords.get(0) : null;
    }

    @Override
    public int getRecordsCount(String query) throws MetadataSourceException {
        return this.retry(new CountByQueryCallable(query));
    }

    @Override
    public int getRecordsCount(Query query) throws MetadataSourceException {
        return this.retry(new CountByQueryCallable(query));
    }

    @Override
    public Collection<ImportRecord> getRecords(String query, int start, int count) throws MetadataSourceException {
        String records = this.retry(new SearchByQueryCallable(query, count, start, this.fields));
        return this.extractMetadataFromRecordList(records);
    }

    @Override
    public Collection<ImportRecord> getRecords(Query query) throws MetadataSourceException {
        String records = this.retry(new SearchByQueryCallable(query, this.fields));
        return this.extractMetadataFromRecordList(records);
    }

    @Override
    public ImportRecord getRecord(Query query) throws MetadataSourceException {
        String records = this.retry(new SearchByQueryCallable(query, this.fields));
        List<ImportRecord> importRecords = this.extractMetadataFromRecordList(records);
        return importRecords != null && !importRecords.isEmpty() ? importRecords.get(0) : null;
    }

    @Override
    public Collection<ImportRecord> findMatchingRecords(Query query) throws MetadataSourceException {
        String records = this.retry(new FindMatchingRecordsCallable(query));
        return this.extractMetadataFromRecordList(records);
    }

    @Override
    public Collection<ImportRecord> findMatchingRecords(Item item) throws MetadataSourceException {
        throw new UnsupportedOperationException("This method is not implemented for VuFind");
    }

    @Override
    public void init() throws Exception {
    }

    private JsonNode convertStringJsonToJsonNode(String json) {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode body = null;
        try {
            body = mapper.readTree(json);
        }
        catch (JsonProcessingException e) {
            log.error("Unable to process json response.", (Throwable)e);
        }
        return body;
    }

    private List<ImportRecord> extractMetadataFromRecordList(String records) {
        ArrayList<ImportRecord> recordsResult = new ArrayList<ImportRecord>();
        JsonNode jsonNode = this.convertStringJsonToJsonNode(records);
        JsonNode node = jsonNode.get("records");
        if (Objects.nonNull(node) && node.isArray()) {
            Iterator nodes = node.iterator();
            while (nodes.hasNext()) {
                recordsResult.add(this.transformSourceRecords(((JsonNode)nodes.next()).toString()));
            }
        }
        return recordsResult;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUrlSearch() {
        return this.urlSearch;
    }

    public void setUrlSearch(String urlSearch) {
        this.urlSearch = urlSearch;
    }

    private class GetByVuFindIdCallable
    implements Callable<String> {
        private String id;
        private String fields;

        public GetByVuFindIdCallable(String id, String fields) {
            this.id = id;
            this.fields = fields != null && fields.length() > 0 ? fields : null;
        }

        @Override
        public String call() throws Exception {
            URIBuilder uriBuilder = new URIBuilder(VuFindImportMetadataSourceServiceImpl.this.url);
            uriBuilder.addParameter("id", this.id);
            uriBuilder.addParameter("prettyPrint", "false");
            if (StringUtils.isNotBlank((CharSequence)this.fields)) {
                for (String field : this.fields.split(",")) {
                    uriBuilder.addParameter("field[]", field);
                }
            }
            HashMap<String, Map<String, String>> params = new HashMap<String, Map<String, String>>();
            String response = VuFindImportMetadataSourceServiceImpl.this.liveImportClient.executeHttpGetRequest(1000, uriBuilder.toString(), params);
            return response;
        }
    }

    private class CountByQueryCallable
    implements Callable<Integer> {
        private Query query;

        public CountByQueryCallable(String queryString) {
            this.query = new Query();
            this.query.addParameter("query", queryString);
        }

        public CountByQueryCallable(Query query) {
            this.query = query;
        }

        @Override
        public Integer call() throws Exception {
            Integer start = 0;
            Integer count = 1;
            int page = start / count + 1;
            URIBuilder uriBuilder = new URIBuilder(VuFindImportMetadataSourceServiceImpl.this.urlSearch);
            uriBuilder.addParameter("type", "AllField");
            uriBuilder.addParameter("page", String.valueOf(page));
            uriBuilder.addParameter("limit", count.toString());
            uriBuilder.addParameter("prettyPrint", String.valueOf(true));
            uriBuilder.addParameter("lookfor", this.query.getParameterAsClass("query", String.class));
            HashMap<String, Map<String, String>> params = new HashMap<String, Map<String, String>>();
            String responseString = VuFindImportMetadataSourceServiceImpl.this.liveImportClient.executeHttpGetRequest(1000, uriBuilder.toString(), params);
            JsonNode node = VuFindImportMetadataSourceServiceImpl.this.convertStringJsonToJsonNode(responseString);
            JsonNode resultCountNode = node.get("resultCount");
            return resultCountNode.intValue();
        }
    }

    private class SearchByQueryCallable
    implements Callable<String> {
        private Query query;
        private String fields;

        public SearchByQueryCallable(String queryString, Integer maxResult, Integer start, String fields) {
            this.query = new Query();
            this.query.addParameter("query", queryString);
            this.query.addParameter("count", maxResult);
            this.query.addParameter("start", start);
            this.fields = StringUtils.isNotBlank((CharSequence)fields) ? fields : null;
        }

        public SearchByQueryCallable(Query query, String fields) {
            this.query = query;
            this.fields = StringUtils.isNotBlank((CharSequence)fields) ? fields : null;
        }

        @Override
        public String call() throws Exception {
            Integer start = this.query.getParameterAsClass("start", Integer.class);
            Integer count = this.query.getParameterAsClass("count", Integer.class);
            int page = count != 0 ? start / count : 0;
            URIBuilder uriBuilder = new URIBuilder(VuFindImportMetadataSourceServiceImpl.this.urlSearch);
            uriBuilder.addParameter("type", "AllField");
            uriBuilder.addParameter("page", String.valueOf(page + 1));
            uriBuilder.addParameter("limit", count.toString());
            uriBuilder.addParameter("prettyPrint", String.valueOf(true));
            uriBuilder.addParameter("lookfor", this.query.getParameterAsClass("query", String.class));
            if (StringUtils.isNotBlank((CharSequence)this.fields)) {
                for (String field : this.fields.split(",")) {
                    uriBuilder.addParameter("field[]", field);
                }
            }
            HashMap<String, Map<String, String>> params = new HashMap<String, Map<String, String>>();
            return VuFindImportMetadataSourceServiceImpl.this.liveImportClient.executeHttpGetRequest(1000, uriBuilder.toString(), params);
        }
    }

    public class FindMatchingRecordsCallable
    implements Callable<String> {
        private Query query;
        private String fields;

        public FindMatchingRecordsCallable(Query query) {
            this.query = query;
        }

        @Override
        public String call() throws Exception {
            String author = this.query.getParameterAsClass("author", String.class);
            String title = this.query.getParameterAsClass("title", String.class);
            Integer start = this.query.getParameterAsClass("start", Integer.class);
            Integer count = this.query.getParameterAsClass("count", Integer.class);
            int page = count != 0 ? start / count : 0;
            URIBuilder uriBuilder = new URIBuilder(VuFindImportMetadataSourceServiceImpl.this.url);
            uriBuilder.addParameter("type", "AllField");
            uriBuilder.addParameter("page", String.valueOf(page++));
            uriBuilder.addParameter("limit", count.toString());
            uriBuilder.addParameter("prettyPrint", "true");
            if (this.fields != null && !this.fields.isEmpty()) {
                for (String field : this.fields.split(",")) {
                    uriBuilder.addParameter("field[]", field);
                }
            }
            Object filter = "";
            if (StringUtils.isNotBlank((CharSequence)author)) {
                filter = "author:" + author;
            }
            if (StringUtils.isNotBlank((CharSequence)title)) {
                filter = StringUtils.isNotBlank((CharSequence)filter) ? (String)filter + " AND title:" + title : "title:" + title;
            }
            uriBuilder.addParameter("lookfor", (String)filter);
            HashMap<String, Map<String, String>> params = new HashMap<String, Map<String, String>>();
            return VuFindImportMetadataSourceServiceImpl.this.liveImportClient.executeHttpGetRequest(1000, uriBuilder.toString(), params);
        }
    }
}

