/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.orcid.model.factory.impl;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Currency;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.content.RelationshipType;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.RelationshipService;
import org.dspace.content.service.RelationshipTypeService;
import org.dspace.core.Context;
import org.dspace.orcid.model.OrcidEntityType;
import org.dspace.orcid.model.OrcidFundingFieldMapping;
import org.dspace.orcid.model.factory.OrcidCommonObjectFactory;
import org.dspace.orcid.model.factory.OrcidEntityFactory;
import org.orcid.jaxb.model.common.FundingContributorRole;
import org.orcid.jaxb.model.common.FundingType;
import org.orcid.jaxb.model.common.Relationship;
import org.orcid.jaxb.model.v3.release.common.Amount;
import org.orcid.jaxb.model.v3.release.common.FuzzyDate;
import org.orcid.jaxb.model.v3.release.common.Organization;
import org.orcid.jaxb.model.v3.release.common.Title;
import org.orcid.jaxb.model.v3.release.common.Url;
import org.orcid.jaxb.model.v3.release.record.Activity;
import org.orcid.jaxb.model.v3.release.record.ExternalID;
import org.orcid.jaxb.model.v3.release.record.ExternalIDs;
import org.orcid.jaxb.model.v3.release.record.Funding;
import org.orcid.jaxb.model.v3.release.record.FundingContributor;
import org.orcid.jaxb.model.v3.release.record.FundingContributors;
import org.orcid.jaxb.model.v3.release.record.FundingTitle;
import org.springframework.beans.factory.annotation.Autowired;

public class OrcidFundingFactory
implements OrcidEntityFactory {
    private static final Logger LOGGER = LogManager.getLogger();
    @Autowired
    private ItemService itemService;
    @Autowired
    private OrcidCommonObjectFactory orcidCommonObjectFactory;
    @Autowired
    private RelationshipTypeService relationshipTypeService;
    @Autowired
    private RelationshipService relationshipService;
    private OrcidFundingFieldMapping fieldMapping;

    @Override
    public OrcidEntityType getEntityType() {
        return OrcidEntityType.FUNDING;
    }

    @Override
    public Activity createOrcidObject(Context context, Item item) {
        Funding funding = new Funding();
        funding.setContributors(this.getContributors(context, item));
        funding.setDescription(this.getDescription(context, item));
        funding.setEndDate(this.getEndDate(context, item));
        funding.setExternalIdentifiers(this.getExternalIds(context, item));
        funding.setOrganization(this.getOrganization(context, item));
        funding.setStartDate(this.getStartDate(context, item));
        funding.setTitle(this.getTitle(context, item));
        funding.setType(this.getType(context, item));
        funding.setUrl(this.getUrl(context, item));
        funding.setAmount(this.getAmount(context, item));
        return funding;
    }

    private FundingContributors getContributors(Context context, Item item) {
        FundingContributors fundingContributors = new FundingContributors();
        this.getMetadataValues(context, item, this.fieldMapping.getContributorFields().keySet()).stream().map(metadataValue -> this.getFundingContributor(context, (MetadataValue)metadataValue)).filter(Optional::isPresent).map(Optional::get).forEach(fundingContributors.getContributor()::add);
        return fundingContributors;
    }

    private Optional<FundingContributor> getFundingContributor(Context context, MetadataValue metadataValue) {
        String metadataField = metadataValue.getMetadataField().toString('.');
        FundingContributorRole role = this.fieldMapping.getContributorFields().get(metadataField);
        return this.orcidCommonObjectFactory.createFundingContributor(context, metadataValue, role);
    }

    private String getDescription(Context context, Item item) {
        return this.getMetadataValue(context, item, this.fieldMapping.getDescriptionField()).map(MetadataValue::getValue).orElse(null);
    }

    private FuzzyDate getEndDate(Context context, Item item) {
        return this.getMetadataValue(context, item, this.fieldMapping.getEndDateField()).flatMap(metadataValue -> this.orcidCommonObjectFactory.createFuzzyDate((MetadataValue)metadataValue)).orElse(null);
    }

    private ExternalIDs getExternalIds(Context context, Item item) {
        ExternalIDs externalIdentifiers = new ExternalIDs();
        this.getMetadataValues(context, item, this.fieldMapping.getExternalIdentifierFields().keySet()).stream().map(this::getExternalId).forEach(externalIdentifiers.getExternalIdentifier()::add);
        return externalIdentifiers;
    }

    private ExternalID getExternalId(MetadataValue metadataValue) {
        String metadataField = metadataValue.getMetadataField().toString('.');
        return this.getExternalId(this.fieldMapping.getExternalIdentifierFields().get(metadataField), metadataValue.getValue());
    }

    private ExternalID getExternalId(String type, String value) {
        ExternalID externalID = new ExternalID();
        externalID.setType(type);
        externalID.setValue(value);
        externalID.setRelationship(Relationship.SELF);
        return externalID;
    }

    private Organization getOrganization(Context context, Item item) {
        try {
            return this.relationshipTypeService.findByLeftwardOrRightwardTypeName(context, this.fieldMapping.getOrganizationRelationshipType()).stream().flatMap(relationshipType -> this.getRelationships(context, item, (RelationshipType)relationshipType)).map(relationship -> this.getRelatedItem(item, (org.dspace.content.Relationship)relationship)).flatMap(orgUnit -> this.orcidCommonObjectFactory.createOrganization(context, (Item)orgUnit).stream()).findFirst().orElse(null);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private Stream<org.dspace.content.Relationship> getRelationships(Context context, Item item, RelationshipType relationshipType) {
        try {
            return this.relationshipService.findByItemAndRelationshipType(context, item, relationshipType).stream();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private Item getRelatedItem(Item item, org.dspace.content.Relationship relationship) {
        return item.equals(relationship.getLeftItem()) ? relationship.getRightItem() : relationship.getLeftItem();
    }

    private FuzzyDate getStartDate(Context context, Item item) {
        return this.getMetadataValue(context, item, this.fieldMapping.getStartDateField()).flatMap(metadataValue -> this.orcidCommonObjectFactory.createFuzzyDate((MetadataValue)metadataValue)).orElse(null);
    }

    private FundingTitle getTitle(Context context, Item item) {
        return this.getMetadataValue(context, item, this.fieldMapping.getTitleField()).map(metadataValue -> this.getFundingTitle(context, (MetadataValue)metadataValue)).orElse(null);
    }

    private FundingTitle getFundingTitle(Context context, MetadataValue metadataValue) {
        FundingTitle fundingTitle = new FundingTitle();
        fundingTitle.setTitle(new Title(metadataValue.getValue()));
        return fundingTitle;
    }

    private FundingType getType(Context context, Item item) {
        return this.getMetadataValue(context, item, this.fieldMapping.getTypeField()).map(type -> this.fieldMapping.convertType(type.getValue())).flatMap(this::getFundingType).orElse(FundingType.CONTRACT);
    }

    private Optional<FundingType> getFundingType(String type) {
        try {
            return Optional.ofNullable(FundingType.fromValue((String)type));
        }
        catch (IllegalArgumentException ex) {
            LOGGER.warn("The type {} is not valid for ORCID fundings", (Object)type);
            return Optional.empty();
        }
    }

    private Url getUrl(Context context, Item item) {
        return this.orcidCommonObjectFactory.createUrl(context, item).orElse(null);
    }

    private Amount getAmount(Context context, Item item) {
        Optional<String> amount = this.getAmountValue(context, item);
        Optional<String> currency = this.getCurrencyValue(context, item);
        if (amount.isEmpty() || currency.isEmpty()) {
            return null;
        }
        return this.getAmount(amount.get(), currency.get());
    }

    private Optional<String> getAmountValue(Context context, Item item) {
        return this.getMetadataValue(context, item, this.fieldMapping.getAmountField()).map(MetadataValue::getValue);
    }

    private Optional<String> getCurrencyValue(Context context, Item item) {
        return this.getMetadataValue(context, item, this.fieldMapping.getAmountCurrencyField()).map(currency -> this.fieldMapping.convertAmountCurrency(currency.getValue())).filter(currency -> this.isValidCurrency((String)currency));
    }

    private boolean isValidCurrency(String currency) {
        try {
            return currency != null && Currency.getInstance(currency) != null;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    private Amount getAmount(String amount, String currency) {
        Amount amountObj = new Amount();
        amountObj.setContent(amount);
        amountObj.setCurrencyCode(currency);
        return amountObj;
    }

    private List<MetadataValue> getMetadataValues(Context context, Item item, Collection<String> metadataFields) {
        return metadataFields.stream().flatMap(metadataField -> this.itemService.getMetadataByMetadataString(item, (String)metadataField).stream()).collect(Collectors.toList());
    }

    private Optional<MetadataValue> getMetadataValue(Context context, Item item, String metadataField) {
        if (StringUtils.isBlank((CharSequence)metadataField)) {
            return Optional.empty();
        }
        return this.itemService.getMetadataByMetadataString(item, metadataField).stream().findFirst().filter(metadataValue -> StringUtils.isNotBlank((CharSequence)metadataValue.getValue()));
    }

    public OrcidFundingFieldMapping getFieldMapping() {
        return this.fieldMapping;
    }

    public void setFieldMapping(OrcidFundingFieldMapping fieldMapping) {
        this.fieldMapping = fieldMapping;
    }
}

