/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.importer.external.cinii;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpException;
import org.apache.http.client.utils.URIBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.content.Item;
import org.dspace.importer.external.datamodel.ImportRecord;
import org.dspace.importer.external.datamodel.Query;
import org.dspace.importer.external.exception.MetadataSourceException;
import org.dspace.importer.external.liveimportclient.service.LiveImportClient;
import org.dspace.importer.external.metadatamapping.MetadatumDTO;
import org.dspace.importer.external.service.AbstractImportMetadataSourceService;
import org.dspace.importer.external.service.components.QuerySource;
import org.dspace.services.ConfigurationService;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.filter.Filters;
import org.jdom2.input.SAXBuilder;
import org.jdom2.xpath.XPathExpression;
import org.jdom2.xpath.XPathFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class CiniiImportMetadataSourceServiceImpl
extends AbstractImportMetadataSourceService<Element>
implements QuerySource {
    private static final Logger log = LogManager.getLogger();
    private String url;
    private String urlSearch;
    @Autowired
    private LiveImportClient liveImportClient;
    @Autowired
    private ConfigurationService configurationService;

    @Override
    public String getImportSource() {
        return "cinii";
    }

    @Override
    public void init() throws Exception {
    }

    @Override
    public ImportRecord getRecord(String id) throws MetadataSourceException {
        List<ImportRecord> records = this.retry(new SearchByIdCallable(id));
        return CollectionUtils.isNotEmpty(records) ? records.get(0) : null;
    }

    @Override
    public int getRecordsCount(String query) throws MetadataSourceException {
        return this.retry(new CountByQueryCallable(query));
    }

    @Override
    public int getRecordsCount(Query query) throws MetadataSourceException {
        return this.retry(new CountByQueryCallable(query));
    }

    @Override
    public Collection<ImportRecord> getRecords(String query, int start, int count) throws MetadataSourceException {
        return this.retry(new SearchByQueryCallable(query, count, start));
    }

    @Override
    public Collection<ImportRecord> getRecords(Query query) throws MetadataSourceException {
        return this.retry(new SearchByQueryCallable(query));
    }

    @Override
    public ImportRecord getRecord(Query query) throws MetadataSourceException {
        List<ImportRecord> records = this.retry(new SearchByIdCallable(query));
        return CollectionUtils.isNotEmpty(records) ? records.get(0) : null;
    }

    @Override
    public Collection<ImportRecord> findMatchingRecords(Query query) throws MetadataSourceException {
        return this.retry(new FindMatchingRecordCallable(query));
    }

    @Override
    public Collection<ImportRecord> findMatchingRecords(Item item) throws MetadataSourceException {
        throw new UnsupportedOperationException("This method is not implemented for Cinii");
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUrlSearch() {
        return this.urlSearch;
    }

    public void setUrlSearch(String urlSearch) {
        this.urlSearch = urlSearch;
    }

    protected List<ImportRecord> search(String id, String appId) throws IOException, HttpException {
        try {
            LinkedList<ImportRecord> records = new LinkedList<ImportRecord>();
            URIBuilder uriBuilder = new URIBuilder(this.url + id + ".rdf?appid=" + appId);
            HashMap<String, Map<String, String>> params = new HashMap<String, Map<String, String>>();
            String response = this.liveImportClient.executeHttpGetRequest(1000, uriBuilder.toString(), params);
            List<Element> elements = this.splitToRecords(response);
            for (Element record : elements) {
                records.add(this.transformSourceRecords(record));
            }
            return records;
        }
        catch (URISyntaxException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private List<Element> splitToRecords(String recordsSrc) {
        try {
            SAXBuilder saxBuilder = new SAXBuilder();
            saxBuilder.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            Document document = saxBuilder.build((Reader)new StringReader(recordsSrc));
            Element root = document.getRootElement();
            return root.getChildren();
        }
        catch (IOException | JDOMException e) {
            log.error(e.getMessage(), e);
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private List<String> getCiniiIds(String appId, Integer maxResult, String author, String title, Integer year, Integer start, String query) {
        try {
            ArrayList<String> ids = new ArrayList<String>();
            URIBuilder uriBuilder = new URIBuilder(this.urlSearch);
            uriBuilder.addParameter("format", "rss");
            if (StringUtils.isNotBlank((String)appId)) {
                uriBuilder.addParameter("appid", appId);
            }
            if (Objects.nonNull(maxResult) && maxResult != 0) {
                uriBuilder.addParameter("count", maxResult.toString());
            }
            if (Objects.nonNull(start)) {
                uriBuilder.addParameter("start", start.toString());
            }
            if (StringUtils.isNotBlank((String)title)) {
                uriBuilder.addParameter("title", title);
            }
            if (StringUtils.isNotBlank((String)author)) {
                uriBuilder.addParameter("author", author);
            }
            if (StringUtils.isNotBlank((String)query)) {
                uriBuilder.addParameter("q", query);
            }
            if (Objects.nonNull(year) && year != -1 && year != 0) {
                uriBuilder.addParameter("year_from", String.valueOf(year));
                uriBuilder.addParameter("year_to", String.valueOf(year));
            }
            HashMap<String, Map<String, String>> params = new HashMap<String, Map<String, String>>();
            String response = this.liveImportClient.executeHttpGetRequest(1000, uriBuilder.toString(), params);
            int url_len = this.url.length() - 1;
            SAXBuilder saxBuilder = new SAXBuilder();
            saxBuilder.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            Document document = saxBuilder.build((Reader)new StringReader(response));
            Element root = document.getRootElement();
            List<Namespace> namespaces = Arrays.asList(Namespace.getNamespace((String)"ns", (String)"http://purl.org/rss/1.0/"), Namespace.getNamespace((String)"rdf", (String)"http://www.w3.org/1999/02/22-rdf-syntax-ns#"));
            XPathExpression xpath = XPathFactory.instance().compile("//ns:item/@rdf:about", Filters.attribute(), null, namespaces);
            List recordsList = xpath.evaluate((Object)root);
            for (Attribute item : recordsList) {
                String value = item.getValue();
                if (value.length() <= url_len) continue;
                ids.add(value.substring(url_len + 1));
            }
            return ids;
        }
        catch (IOException | URISyntaxException | JDOMException e) {
            log.error(e.getMessage(), e);
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private Integer countCiniiElement(String appId, Integer maxResult, String author, String title, Integer year, Integer start, String query) {
        try {
            URIBuilder uriBuilder = new URIBuilder(this.urlSearch);
            uriBuilder.addParameter("format", "rss");
            uriBuilder.addParameter("appid", appId);
            if (Objects.nonNull(maxResult) && maxResult != 0) {
                uriBuilder.addParameter("count", maxResult.toString());
            }
            if (Objects.nonNull(start)) {
                uriBuilder.addParameter("start", start.toString());
            }
            if (StringUtils.isNotBlank((String)title)) {
                uriBuilder.addParameter("title", title);
            }
            if (StringUtils.isNotBlank((String)author)) {
                uriBuilder.addParameter("author", author);
            }
            if (StringUtils.isNotBlank((String)query)) {
                uriBuilder.addParameter("q", query);
            }
            if (Objects.nonNull(year) && year != -1 && year != 0) {
                uriBuilder.addParameter("year_from", String.valueOf(year));
                uriBuilder.addParameter("year_to", String.valueOf(year));
            }
            HashMap<String, Map<String, String>> params = new HashMap<String, Map<String, String>>();
            String response = this.liveImportClient.executeHttpGetRequest(1000, uriBuilder.toString(), params);
            SAXBuilder saxBuilder = new SAXBuilder();
            saxBuilder.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            Document document = saxBuilder.build((Reader)new StringReader(response));
            Element root = document.getRootElement();
            List<Namespace> namespaces = Arrays.asList(Namespace.getNamespace((String)"opensearch", (String)"http://a9.com/-/spec/opensearch/1.1/"));
            XPathExpression xpath = XPathFactory.instance().compile("//opensearch:totalResults", Filters.element(), null, namespaces);
            List nodes = xpath.evaluate((Object)root);
            if (nodes != null && !nodes.isEmpty()) {
                return Integer.parseInt(((Element)nodes.get(0)).getText());
            }
            return 0;
        }
        catch (IOException | URISyntaxException | JDOMException e) {
            log.error(e.getMessage(), e);
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private MetadatumDTO createIdentifier(String id) {
        MetadatumDTO metadatumDTO = new MetadatumDTO();
        metadatumDTO.setSchema("dc");
        metadatumDTO.setElement("identifier");
        metadatumDTO.setQualifier("other");
        metadatumDTO.setValue(id);
        return metadatumDTO;
    }

    private class SearchByIdCallable
    implements Callable<List<ImportRecord>> {
        private Query query;

        private SearchByIdCallable(Query query) {
            this.query = query;
        }

        private SearchByIdCallable(String id) {
            this.query = new Query();
            this.query.addParameter("id", id);
        }

        @Override
        public List<ImportRecord> call() throws Exception {
            String appId = CiniiImportMetadataSourceServiceImpl.this.configurationService.getProperty("cinii.appid");
            String id = this.query.getParameterAsClass("id", String.class);
            List<ImportRecord> importRecord = CiniiImportMetadataSourceServiceImpl.this.search(id, appId);
            if (CollectionUtils.isNotEmpty(importRecord)) {
                importRecord.forEach(x -> x.addValue(CiniiImportMetadataSourceServiceImpl.this.createIdentifier(id)));
            }
            return importRecord;
        }
    }

    private class CountByQueryCallable
    implements Callable<Integer> {
        private Query query;

        private CountByQueryCallable(String queryString) {
            this.query = new Query();
            this.query.addParameter("query", queryString);
        }

        private CountByQueryCallable(Query query) {
            this.query = query;
        }

        @Override
        public Integer call() throws Exception {
            String appId = CiniiImportMetadataSourceServiceImpl.this.configurationService.getProperty("cinii.appid");
            String queryString = this.query.getParameterAsClass("query", String.class);
            return CiniiImportMetadataSourceServiceImpl.this.countCiniiElement(appId, null, null, null, null, null, queryString);
        }
    }

    private class SearchByQueryCallable
    implements Callable<List<ImportRecord>> {
        private Query query;

        private SearchByQueryCallable(String queryString, Integer maxResult, Integer start) {
            this.query = new Query();
            this.query.addParameter("query", queryString);
            this.query.addParameter("count", maxResult);
            this.query.addParameter("start", start);
        }

        private SearchByQueryCallable(Query query) {
            this.query = query;
        }

        @Override
        public List<ImportRecord> call() throws Exception {
            LinkedList<ImportRecord> records = new LinkedList<ImportRecord>();
            Integer count = this.query.getParameterAsClass("count", Integer.class);
            Integer start = this.query.getParameterAsClass("start", Integer.class);
            String queryString = this.query.getParameterAsClass("query", String.class);
            String appId = CiniiImportMetadataSourceServiceImpl.this.configurationService.getProperty("cinii.appid");
            List<String> ids = CiniiImportMetadataSourceServiceImpl.this.getCiniiIds(appId, count, null, null, null, start, queryString);
            if (CollectionUtils.isNotEmpty(ids)) {
                for (String id : ids) {
                    List<ImportRecord> tmp = CiniiImportMetadataSourceServiceImpl.this.search(id, appId);
                    if (CollectionUtils.isNotEmpty(tmp)) {
                        tmp.forEach(x -> x.addValue(CiniiImportMetadataSourceServiceImpl.this.createIdentifier(id)));
                    }
                    records.addAll(tmp);
                }
            }
            return records;
        }
    }

    private class FindMatchingRecordCallable
    implements Callable<List<ImportRecord>> {
        private Query query;

        private FindMatchingRecordCallable(Query q) {
            this.query = q;
        }

        @Override
        public List<ImportRecord> call() throws Exception {
            LinkedList<ImportRecord> records = new LinkedList<ImportRecord>();
            String title = this.query.getParameterAsClass("title", String.class);
            String author = this.query.getParameterAsClass("author", String.class);
            Integer year = this.query.getParameterAsClass("year", Integer.class);
            Integer maxResult = this.query.getParameterAsClass("maxResult", Integer.class);
            Integer start = this.query.getParameterAsClass("start", Integer.class);
            String appId = CiniiImportMetadataSourceServiceImpl.this.configurationService.getProperty("cinii.appid");
            List<String> ids = CiniiImportMetadataSourceServiceImpl.this.getCiniiIds(appId, maxResult, author, title, year, start, null);
            if (CollectionUtils.isNotEmpty(ids)) {
                for (String id : ids) {
                    List<ImportRecord> importRecords = CiniiImportMetadataSourceServiceImpl.this.search(id, appId);
                    if (CollectionUtils.isNotEmpty(importRecords)) {
                        importRecords.forEach(x -> x.addValue(CiniiImportMetadataSourceServiceImpl.this.createIdentifier(id)));
                    }
                    records.addAll(importRecords);
                }
            }
            return records;
        }
    }
}

