/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.identifier.doi;

import java.sql.SQLException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.logic.Filter;
import org.dspace.content.logic.FilterUtils;
import org.dspace.core.Context;
import org.dspace.event.Consumer;
import org.dspace.event.Event;
import org.dspace.identifier.DOI;
import org.dspace.identifier.DOIIdentifierProvider;
import org.dspace.identifier.IdentifierException;
import org.dspace.identifier.IdentifierNotApplicableException;
import org.dspace.identifier.factory.IdentifierServiceFactory;
import org.dspace.identifier.service.DOIService;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.utils.DSpace;
import org.dspace.workflow.factory.WorkflowServiceFactory;

public class DOIConsumer
implements Consumer {
    private static Logger log = LogManager.getLogger(DOIConsumer.class);
    ConfigurationService configurationService;

    @Override
    public void initialize() throws Exception {
        this.configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
    }

    @Override
    public void consume(Context ctx, Event event) throws Exception {
        if (event.getSubjectType() != 2) {
            log.warn("DOIConsumer should not have been given this kind of subject in an event, skipping: " + event.toString());
            return;
        }
        if (4 != event.getEventType()) {
            log.warn("DOIConsumer should not have been given this kind of event type, skipping: " + event.toString());
            return;
        }
        DSpaceObject dso = event.getSubject(ctx);
        if (!(dso instanceof Item)) {
            log.debug("DOIConsumer got an event whose subject was not an item, skipping: " + event.toString());
            return;
        }
        Item item = (Item)dso;
        DOIIdentifierProvider provider = (DOIIdentifierProvider)new DSpace().getSingletonService(DOIIdentifierProvider.class);
        boolean inProgress = ContentServiceFactory.getInstance().getWorkspaceItemService().findByItem(ctx, item) != null || WorkflowServiceFactory.getInstance().getWorkflowItemService().findByItem(ctx, item) != null;
        boolean identifiersInSubmission = this.configurationService.getBooleanProperty("identifiers.submission.register", false);
        DOIService doiService = IdentifierServiceFactory.getInstance().getDOIService();
        Filter workspaceFilter = null;
        if (identifiersInSubmission) {
            workspaceFilter = FilterUtils.getFilterFromConfiguration("identifiers.submission.filter.workspace");
        }
        if (inProgress && !identifiersInSubmission) {
            return;
        }
        DOI doi = null;
        try {
            doi = doiService.findDOIByDSpaceObject(ctx, dso);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (doi == null) {
            if (inProgress) {
                provider.mint(ctx, dso, workspaceFilter);
                DOI newDoi = doiService.findDOIByDSpaceObject(ctx, dso);
                if (newDoi != null) {
                    newDoi.setStatus(DOIIdentifierProvider.PENDING);
                    doiService.update(ctx, newDoi);
                }
            } else {
                log.debug("DOIConsumer cannot handles items without DOIs, skipping: " + event.toString());
            }
        } else if (inProgress) {
            block20: {
                try {
                    provider.checkMintable(ctx, workspaceFilter, dso);
                    if (DOIIdentifierProvider.MINTED.equals(doi.getStatus())) {
                        doi.setStatus(DOIIdentifierProvider.PENDING);
                    }
                }
                catch (IdentifierNotApplicableException e) {
                    if (!this.configurationService.getBooleanProperty("identifiers.submission.strip_pending_during_submission", true)) break block20;
                    doi.setStatus(DOIIdentifierProvider.MINTED);
                }
            }
            doiService.update(ctx, doi);
        } else {
            try {
                provider.updateMetadata(ctx, dso, doi.getDoi());
            }
            catch (IllegalArgumentException ex) {
                log.warn("DOIConsumer caught an IdentifierException.", (Throwable)ex);
            }
            catch (IdentifierException ex) {
                log.warn("DOIConsumer cannot update metadata for Item with ID " + item.getID() + " and DOI " + doi + ".", (Throwable)ex);
            }
        }
    }

    @Override
    public void end(Context ctx) throws Exception {
    }

    @Override
    public void finish(Context ctx) throws Exception {
    }
}

