/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.disseminate;

import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.dspace.content.Item;
import org.dspace.disseminate.CoverPageContributor;
import org.dspace.disseminate.DefaultCoverPageContributor;
import org.dspace.disseminate.PdfGenerator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class CoverPageService {
    private static final Logger LOG = LogManager.getLogger(CoverPageService.class);
    private final PdfGenerator pdfGenerator = new PdfGenerator();
    private final String coverTemplate;
    private final CoverPageContributor coverPageContributor;

    CoverPageService(@Value(value="${citation-page.cover-template:dspace_coverpage}") String coverTemplate, @Autowired(required=false) CoverPageContributor coverPageContributor) {
        this.coverTemplate = coverTemplate;
        this.coverPageContributor = coverPageContributor == null ? new DefaultCoverPageContributor() : coverPageContributor;
    }

    public PDDocument renderCoverDocument(Item item) {
        Map<String, String> parameters = this.prepareParams(item);
        parameters = this.coverPageContributor.processCoverPageParams(item, parameters);
        LOG.debug("Rendering cover document with params = {}", parameters);
        String html = this.pdfGenerator.parseTemplate(this.coverTemplate, parameters);
        return this.pdfGenerator.generate(html);
    }

    protected Map<String, String> prepareParams(Item item) {
        return item.getMetadata().stream().filter(meta -> meta.getPlace() == 0).map(meta -> Map.entry(meta.getMetadataField().toString(), meta.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}

