/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.discovery;

import java.sql.SQLException;
import org.apache.solr.common.SolrInputDocument;
import org.dspace.access.status.factory.AccessStatusServiceFactory;
import org.dspace.access.status.service.AccessStatusService;
import org.dspace.content.AccessStatus;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.discovery.IndexableObject;
import org.dspace.discovery.SolrServiceIndexPlugin;
import org.dspace.discovery.indexobject.IndexableItem;

public class SolrServiceIndexAccessStatusPlugin
implements SolrServiceIndexPlugin {
    AccessStatusService accessStatusService = AccessStatusServiceFactory.getInstance().getAccessStatusService();

    @Override
    public void additionalIndex(Context context, IndexableObject indexableObject, SolrInputDocument document) {
        if (indexableObject instanceof IndexableItem) {
            String accessStatus;
            Item item = (Item)((IndexableItem)indexableObject).getIndexedObject();
            try {
                accessStatus = this.retrieveItemAccessStatus(context, item);
            }
            catch (SQLException e) {
                accessStatus = "unknown";
            }
            document.addField("access_status_keyword", (Object)accessStatus);
            document.addField("access_status_filter", (Object)accessStatus);
        }
    }

    private String retrieveItemAccessStatus(Context context, Item item) throws SQLException {
        AccessStatus accessStatus = this.accessStatusService.getAccessStatus(context, item);
        return accessStatus.getStatus();
    }
}

