/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.authenticate;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.authenticate.AuthenticationMethod;
import org.dspace.authorize.AuthorizeException;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.eperson.RegistrationData;
import org.dspace.eperson.RegistrationTypeEnum;
import org.dspace.eperson.service.EPersonService;
import org.dspace.eperson.service.RegistrationDataService;
import org.dspace.orcid.OrcidToken;
import org.dspace.orcid.client.OrcidClient;
import org.dspace.orcid.client.OrcidConfiguration;
import org.dspace.orcid.model.OrcidTokenResponseDTO;
import org.dspace.orcid.service.OrcidSynchronizationService;
import org.dspace.orcid.service.OrcidTokenService;
import org.dspace.profile.ResearcherProfile;
import org.dspace.profile.service.ResearcherProfileService;
import org.dspace.services.ConfigurationService;
import org.orcid.jaxb.model.v3.release.record.Email;
import org.orcid.jaxb.model.v3.release.record.Person;
import org.springframework.beans.factory.annotation.Autowired;

public class OrcidAuthenticationBean
implements AuthenticationMethod {
    public static final String ORCID_DEFAULT_FIRSTNAME = "Unnamed";
    public static final String ORCID_DEFAULT_LASTNAME = "Unnamed";
    public static final String ORCID_AUTH_ATTRIBUTE = "orcid-authentication";
    public static final String ORCID_REGISTRATION_TOKEN = "orcid-registration-token";
    public static final String ORCID_DEFAULT_REGISTRATION_URL = "/external-login/{0}";
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String LOGIN_PAGE_URL_FORMAT = "%s?client_id=%s&response_type=code&scope=%s&redirect_uri=%s";
    @Autowired
    private OrcidClient orcidClient;
    @Autowired
    private OrcidConfiguration orcidConfiguration;
    @Autowired
    private ConfigurationService configurationService;
    @Autowired
    private EPersonService ePersonService;
    @Autowired
    private ResearcherProfileService researcherProfileService;
    @Autowired
    private OrcidSynchronizationService orcidSynchronizationService;
    @Autowired
    private OrcidTokenService orcidTokenService;
    @Autowired
    private RegistrationDataService registrationDataService;

    @Override
    public int authenticate(Context context, String username, String password, String realm, HttpServletRequest request) throws SQLException {
        if (request == null) {
            LOGGER.warn("Unable to authenticate using ORCID because the request object is null.");
            return 5;
        }
        String code = request.getParameter("code");
        if (StringUtils.isEmpty((CharSequence)code)) {
            LOGGER.warn("The incoming request has not code parameter");
            return 4;
        }
        request.setAttribute(ORCID_AUTH_ATTRIBUTE, (Object)true);
        return this.authenticateWithOrcid(context, code, request);
    }

    @Override
    public String loginPageURL(Context context, HttpServletRequest request, HttpServletResponse response) {
        String authorizeUrl = this.orcidConfiguration.getAuthorizeEndpointUrl();
        String clientId = this.orcidConfiguration.getClientId();
        String redirectUri = this.orcidConfiguration.getRedirectUrl();
        String scopes = String.join((CharSequence)"+", this.orcidConfiguration.getScopes());
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{authorizeUrl, clientId, redirectUri, scopes})) {
            LOGGER.error("Missing mandatory configuration properties for OrcidAuthentication");
            return "";
        }
        try {
            return String.format(LOGIN_PAGE_URL_FORMAT, authorizeUrl, clientId, scopes, URLEncoder.encode(redirectUri, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return "";
        }
    }

    @Override
    public boolean isUsed(Context context, HttpServletRequest request) {
        return request.getAttribute(ORCID_AUTH_ATTRIBUTE) != null;
    }

    @Override
    public boolean canChangePassword(Context context, EPerson ePerson, String currentPassword) {
        return false;
    }

    @Override
    public boolean canSelfRegister(Context context, HttpServletRequest request, String username) throws SQLException {
        return this.canSelfRegister();
    }

    @Override
    public void initEPerson(Context context, HttpServletRequest request, EPerson eperson) throws SQLException {
    }

    @Override
    public boolean allowSetPassword(Context context, HttpServletRequest request, String username) throws SQLException {
        return false;
    }

    @Override
    public boolean isImplicit() {
        return false;
    }

    @Override
    public List<Group> getSpecialGroups(Context context, HttpServletRequest request) throws SQLException {
        return Collections.emptyList();
    }

    @Override
    public String getName() {
        return "orcid";
    }

    private int authenticateWithOrcid(Context context, String code, HttpServletRequest request) throws SQLException {
        OrcidTokenResponseDTO token = this.getOrcidAccessToken(code);
        if (token == null) {
            return 4;
        }
        String orcid = token.getOrcid();
        EPerson ePerson = this.ePersonService.findByNetid(context, orcid);
        if (ePerson != null) {
            return ePerson.canLogIn() ? this.logInEPerson(context, token, ePerson) : 5;
        }
        Person person = this.getPersonFromOrcid(token);
        if (person == null) {
            return 4;
        }
        String email = this.getEmail(person).orElse(null);
        ePerson = this.ePersonService.findByEmail(context, email);
        if (ePerson != null) {
            return ePerson.canLogIn() ? this.logInEPerson(context, token, ePerson) : 5;
        }
        return this.canSelfRegister() ? this.createRegistrationData(context, request, person, token) : 4;
    }

    private int logInEPerson(Context context, OrcidTokenResponseDTO token, EPerson ePerson) throws SQLException {
        context.setCurrentUser(ePerson);
        this.setOrcidMetadataOnEPerson(context, ePerson, token);
        ResearcherProfile profile = this.findProfile(context, ePerson);
        if (profile != null) {
            this.orcidSynchronizationService.linkProfile(context, profile.getItem(), token);
        }
        return 1;
    }

    private ResearcherProfile findProfile(Context context, EPerson ePerson) throws SQLException {
        try {
            return this.researcherProfileService.findById(context, ePerson.getID());
        }
        catch (AuthorizeException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int createRegistrationData(Context context, HttpServletRequest request, Person person, OrcidTokenResponseDTO token) throws SQLException {
        try {
            context.turnOffAuthorisationSystem();
            RegistrationData registrationData = this.registrationDataService.create(context, token.getOrcid(), RegistrationTypeEnum.ORCID);
            registrationData.setEmail(this.getEmail(person).orElse(null));
            this.setOrcidMetadataOnRegistration(context, registrationData, person, token);
            this.registrationDataService.update(context, registrationData);
            request.setAttribute(ORCID_REGISTRATION_TOKEN, (Object)registrationData.getToken());
            context.commit();
            context.dispatchEvents();
        }
        catch (Exception ex) {
            LOGGER.error("An error occurs registering a new EPerson from ORCID", (Throwable)ex);
            context.rollback();
        }
        finally {
            context.restoreAuthSystemState();
            return 4;
        }
    }

    private void setOrcidMetadataOnRegistration(Context context, RegistrationData registration, Person person, OrcidTokenResponseDTO token) throws SQLException, AuthorizeException {
        String orcid = token.getOrcid();
        this.setRegistrationMetadata(context, registration, "eperson.firstname", this.getFirstName(person));
        this.setRegistrationMetadata(context, registration, "eperson.lastname", this.getLastName(person));
        this.registrationDataService.setRegistrationMetadataValue(context, registration, "eperson", "orcid", null, orcid);
        for (String scope : token.getScopeAsArray()) {
            this.registrationDataService.addMetadata(context, registration, "eperson", "orcid", "scope", scope);
        }
    }

    private void setRegistrationMetadata(Context context, RegistrationData registration, String metadataString, String value) {
        String[] split = metadataString.split("\\.");
        String qualifier = split.length > 2 ? split[2] : null;
        try {
            this.registrationDataService.setRegistrationMetadataValue(context, registration, split[0], split[1], qualifier, value);
        }
        catch (SQLException | AuthorizeException ex) {
            LOGGER.error("An error occurs setting metadata", (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    private void setOrcidMetadataOnEPerson(Context context, EPerson person, OrcidTokenResponseDTO token) throws SQLException {
        String orcid = token.getOrcid();
        String accessToken = token.getAccessToken();
        String[] scopes = token.getScopeAsArray();
        this.ePersonService.setMetadataSingleValue(context, person, "eperson", "orcid", null, null, orcid);
        this.ePersonService.clearMetadata(context, person, "eperson", "orcid", "scope", "*");
        for (String scope : scopes) {
            this.ePersonService.addMetadata(context, person, "eperson", "orcid", "scope", null, scope);
        }
        OrcidToken orcidToken = this.orcidTokenService.findByEPerson(context, person);
        if (orcidToken == null) {
            this.orcidTokenService.create(context, person, accessToken);
        } else {
            orcidToken.setAccessToken(accessToken);
        }
    }

    private Person getPersonFromOrcid(OrcidTokenResponseDTO token) {
        try {
            return this.orcidClient.getPerson(token.getAccessToken(), token.getOrcid());
        }
        catch (Exception ex) {
            LOGGER.error("An error occurs retrieving the ORCID record with id {}", (Object)token.getOrcid(), (Object)ex);
            return null;
        }
    }

    private Optional<String> getEmail(Person person) {
        List emails;
        List list = emails = person.getEmails() != null ? person.getEmails().getEmails() : Collections.emptyList();
        if (CollectionUtils.isEmpty((Collection)emails)) {
            return Optional.empty();
        }
        return Optional.ofNullable(((Email)emails.get(0)).getEmail());
    }

    private String getFirstName(Person person) {
        return Optional.ofNullable(person.getName()).map(name -> name.getGivenNames()).map(givenNames -> givenNames.getContent()).filter(StringUtils::isNotBlank).orElse("Unnamed");
    }

    private String getLastName(Person person) {
        return Optional.ofNullable(person.getName()).map(name -> name.getFamilyName()).map(givenNames -> givenNames.getContent()).filter(StringUtils::isNotBlank).orElse("Unnamed");
    }

    private boolean canSelfRegister() {
        String canSelfRegister = this.configurationService.getProperty("authentication-orcid.can-self-register", "true");
        if (StringUtils.isBlank((CharSequence)canSelfRegister)) {
            return true;
        }
        return BooleanUtils.toBoolean((String)canSelfRegister);
    }

    private OrcidTokenResponseDTO getOrcidAccessToken(String code) {
        try {
            return this.orcidClient.getAccessToken(code);
        }
        catch (Exception ex) {
            LOGGER.error("An error occurs retrieving the ORCID access_token", (Throwable)ex);
            return null;
        }
    }

    public OrcidClient getOrcidClient() {
        return this.orcidClient;
    }

    public void setOrcidClient(OrcidClient orcidClient) {
        this.orcidClient = orcidClient;
    }
}

