/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.sherpa.v2;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.sherpa.v2.SHERPAEmbargo;
import org.dspace.app.sherpa.v2.SHERPAJournal;
import org.dspace.app.sherpa.v2.SHERPAPermittedVersion;
import org.dspace.app.sherpa.v2.SHERPAPublisher;
import org.dspace.app.sherpa.v2.SHERPAPublisherPolicy;
import org.dspace.app.sherpa.v2.SHERPASystemMetadata;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class SHERPAResponse
implements Serializable {
    private static final long serialVersionUID = 2732963970169240597L;
    private boolean error;
    private String message;
    private SHERPASystemMetadata metadata;
    private List<SHERPAJournal> journals;
    private int id;
    private String uri;
    @JsonIgnore
    private Instant retrievalTime = Instant.now();
    private static Logger log = LogManager.getLogger();

    public SHERPAResponse(InputStream input, SHERPAFormat format) throws IOException {
        if (format == SHERPAFormat.JSON) {
            this.parseJSON(input);
        }
    }

    public SHERPAResponse() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseJSON(InputStream jsonData) throws IOException {
        block15: {
            InputStreamReader streamReader = new InputStreamReader(jsonData, StandardCharsets.UTF_8);
            JSONTokener jsonTokener = new JSONTokener((Reader)streamReader);
            try {
                JSONObject httpResponse = new JSONObject(jsonTokener);
                if (httpResponse.has("items")) {
                    JSONArray items = httpResponse.getJSONArray("items");
                    if (items.length() > 0) {
                        this.metadata = new SHERPASystemMetadata();
                        this.journals = new ArrayList<SHERPAJournal>();
                        for (int itemIndex = 0; itemIndex < items.length(); ++itemIndex) {
                            ArrayList<SHERPAPublisher> sherpaPublishers = new ArrayList<SHERPAPublisher>();
                            ArrayList<SHERPAPublisherPolicy> policies = new ArrayList<SHERPAPublisherPolicy>();
                            SHERPAPublisher sherpaPublisher = new SHERPAPublisher();
                            SHERPAJournal sherpaJournal = new SHERPAJournal();
                            JSONObject item = items.getJSONObject(itemIndex);
                            if (item.has("system_metadata")) {
                                JSONObject systemMetadata = item.getJSONObject("system_metadata");
                                this.metadata = this.parseSystemMetadata(systemMetadata);
                            }
                            if (item.has("publisher_policy")) {
                                JSONObject publisherElement;
                                JSONArray publishers;
                                JSONArray publisherPolicies = item.getJSONArray("publisher_policy");
                                block6: for (int i = 0; i < publisherPolicies.length(); ++i) {
                                    JSONObject policy = publisherPolicies.getJSONObject(i);
                                    String moniker = null;
                                    if (policy.has("internal_moniker")) {
                                        moniker = policy.getString("internal_moniker");
                                    }
                                    if ("Open access option".equalsIgnoreCase(moniker)) {
                                        log.debug("This is the Open access options policy - a special case");
                                        if (!policy.has("urls")) continue;
                                        JSONArray urls = policy.getJSONArray("urls");
                                        for (int u = 0; u < urls.length(); ++u) {
                                            JSONObject url = urls.getJSONObject(u);
                                            if (!url.has("description") || !"Open Access".equalsIgnoreCase(url.getString("description"))) continue;
                                            log.debug("Found OA paid access url: " + url.getString("url"));
                                            sherpaPublisher.setPaidAccessDescription(url.getString("description"));
                                            sherpaPublisher.setPaidAccessUrl(url.getString("url"));
                                            continue block6;
                                        }
                                        continue;
                                    }
                                    SHERPAPublisherPolicy sherpaPublisherPolicy = this.parsePublisherPolicy(policy);
                                    policies.add(sherpaPublisherPolicy);
                                }
                                if (item.has("publishers") && (publishers = item.getJSONArray("publishers")).length() > 0 && (publisherElement = publishers.getJSONObject(0)).has("publisher")) {
                                    JSONObject publisher = publisherElement.getJSONObject("publisher");
                                    sherpaPublisher.setName(this.parsePublisherName(publisher));
                                    sherpaPublisher.setUri(this.parsePublisherURL(publisher));
                                }
                                sherpaJournal = this.parseJournal(item, sherpaPublisher.getName());
                            }
                            sherpaPublishers.add(sherpaPublisher);
                            sherpaJournal.setPublisher(sherpaPublisher);
                            sherpaJournal.setPublishers(sherpaPublishers);
                            sherpaJournal.setPolicies(policies);
                            this.journals.add(sherpaJournal);
                        }
                        break block15;
                    }
                    this.error = true;
                    this.message = "No results found";
                    break block15;
                }
                this.error = true;
                this.message = "No results found";
            }
            catch (JSONException e) {
                log.error("Failed to parse SHERPA response", (Throwable)e);
                this.error = true;
            }
            finally {
                streamReader.close();
            }
        }
    }

    private SHERPASystemMetadata parseSystemMetadata(JSONObject systemMetadata) {
        SHERPASystemMetadata metadata = new SHERPASystemMetadata();
        if (systemMetadata.has("uri")) {
            this.uri = systemMetadata.getString("uri");
            metadata.setUri(this.uri);
        } else {
            log.error("SHERPA URI missing for API response item");
        }
        if (systemMetadata.has("id")) {
            this.id = systemMetadata.getInt("id");
            metadata.setId(this.id);
        } else {
            log.error("SHERPA internal ID missing for API response item");
        }
        if (systemMetadata.has("date_created")) {
            metadata.setDateCreated(systemMetadata.getString("date_created"));
        }
        if (systemMetadata.has("date_modified")) {
            metadata.setDateModified(systemMetadata.getString("date_modified"));
        }
        if (systemMetadata.has("publicly_visible")) {
            metadata.setPubliclyVisible("yes".equals(systemMetadata.getString("publicly_visible")));
        }
        if (systemMetadata.has("listed_in_doaj")) {
            metadata.setPubliclyVisible("yes".equals(systemMetadata.getString("listed_in_doaj")));
        }
        return metadata;
    }

    private SHERPAJournal parseJournal(JSONObject item, String publisherName) {
        JSONArray titles;
        SHERPAJournal sherpaJournal = new SHERPAJournal();
        if (item.has("title") && (titles = item.getJSONArray("title")).length() > 0) {
            ArrayList<String> titleList = new ArrayList<String>();
            for (int t = 0; t < titles.length(); ++t) {
                JSONObject title = titles.getJSONObject(t);
                if (!title.has("title")) continue;
                titleList.add(title.getString("title").trim());
            }
            sherpaJournal.setTitles(titleList);
            if (titleList.size() > 0) {
                sherpaJournal.setRomeoPub(publisherName + ": " + (String)titleList.get(0));
                sherpaJournal.setZetoPub(publisherName + ": " + (String)titleList.get(0));
                log.debug("Found journal title: " + (String)titleList.get(0));
            }
        }
        if (item.has("url")) {
            sherpaJournal.setUrl(item.getString("url"));
        }
        if (item.has("issns")) {
            JSONArray issns = item.getJSONArray("issns");
            ArrayList<String> issnList = new ArrayList<String>();
            for (int ii = 0; ii < issns.length(); ++ii) {
                JSONObject issn = issns.getJSONObject(ii);
                issnList.add(issn.getString("issn").trim());
            }
            sherpaJournal.setIssns(issnList);
        }
        if (item.has("listed_in_doaj")) {
            sherpaJournal.setInDOAJ("yes".equals(item.getString("listed_in_doaj")));
        }
        return sherpaJournal;
    }

    private SHERPAPublisherPolicy parsePublisherPolicy(JSONObject policy) {
        SHERPAPublisherPolicy sherpaPublisherPolicy = new SHERPAPublisherPolicy();
        String moniker = null;
        if (policy.has("internal_moniker")) {
            moniker = policy.getString("internal_moniker");
            sherpaPublisherPolicy.setInternalMoniker(moniker);
        }
        if (policy.has("urls")) {
            JSONArray urls = policy.getJSONArray("urls");
            TreeMap<String, String> copyrightLinks = new TreeMap<String, String>();
            for (int u = 0; u < urls.length(); ++u) {
                JSONObject url = urls.getJSONObject(u);
                if (!url.has("description") || !url.has("url")) continue;
                log.debug("Setting copyright URL: " + url.getString("url"));
                copyrightLinks.put(url.getString("url"), url.getString("description"));
            }
            sherpaPublisherPolicy.setUrls(copyrightLinks);
        }
        int submittedOption = 0;
        int acceptedOption = 0;
        int publishedOption = 0;
        int currentOption = 0;
        if (policy.has("permitted_oa")) {
            ArrayList<String> allowed = new ArrayList<String>();
            JSONArray permittedOA = policy.getJSONArray("permitted_oa");
            ArrayList<SHERPAPermittedVersion> permittedVersions = new ArrayList<SHERPAPermittedVersion>();
            for (int p = 0; p < permittedOA.length(); ++p) {
                JSONObject permitted = permittedOA.getJSONObject(p);
                if (permitted.has("article_version")) {
                    JSONArray versions = permitted.getJSONArray("article_version");
                    for (int v = 0; v < versions.length(); ++v) {
                        SHERPAPermittedVersion permittedVersion = this.parsePermittedVersion(permitted, v);
                        allowed.add(permittedVersion.getArticleVersion());
                        if ("submitted".equals(permittedVersion.getArticleVersion())) {
                            currentOption = ++submittedOption;
                        } else if ("accepted".equals(permittedVersion.getArticleVersion())) {
                            currentOption = ++acceptedOption;
                        } else if ("published".equals(permittedVersion.getArticleVersion())) {
                            currentOption = ++publishedOption;
                        }
                        permittedVersion.setOption(currentOption);
                        permittedVersions.add(permittedVersion);
                    }
                }
                if (allowed.contains("submitted")) {
                    sherpaPublisherPolicy.setPreArchiving("can");
                }
                if (allowed.contains("accepted")) {
                    sherpaPublisherPolicy.setPostArchiving("can");
                }
                if (!allowed.contains("published")) continue;
                sherpaPublisherPolicy.setPubArchiving("can");
            }
            sherpaPublisherPolicy.setPermittedVersions(permittedVersions);
        }
        return sherpaPublisherPolicy;
    }

    private SHERPAPermittedVersion parsePermittedVersion(JSONObject permitted, int index) {
        JSONArray locationPhrases;
        JSONObject locations;
        JSONObject prereqs;
        SHERPAPermittedVersion permittedVersion = new SHERPAPermittedVersion();
        String articleVersion = "unknown";
        if (permitted.has("article_version")) {
            JSONArray versions = permitted.getJSONArray("article_version");
            articleVersion = versions.getString(index);
            permittedVersion.setArticleVersion(articleVersion);
            log.debug("Added allowed version: " + articleVersion + " to list");
        }
        if (permitted.has("conditions")) {
            ArrayList<String> conditionList = new ArrayList<String>();
            JSONArray conditions = permitted.getJSONArray("conditions");
            for (int c = 0; c < conditions.length(); ++c) {
                conditionList.add(conditions.getString(c).trim());
            }
            permittedVersion.setConditions(conditionList);
        }
        ArrayList<String> prerequisites = new ArrayList<String>();
        if (permitted.has("prerequisites") && (prereqs = permitted.getJSONObject("prerequisites")).has("prerequisites_phrases")) {
            JSONArray phrases = prereqs.getJSONArray("prerequisites_phrases");
            for (int pp = 0; pp < phrases.length(); ++pp) {
                JSONObject phrase = phrases.getJSONObject(pp);
                if (!phrase.has("phrase")) continue;
                prerequisites.add(phrase.getString("phrase").trim());
            }
        }
        permittedVersion.setPrerequisites(prerequisites);
        ArrayList<String> sherpaLocations = new ArrayList<String>();
        if (permitted.has("location") && (locations = permitted.getJSONObject("location")).has("location_phrases") && (locationPhrases = locations.getJSONArray("location_phrases")).length() > 0) {
            for (int l = 0; l < locationPhrases.length(); ++l) {
                JSONObject locationPhrase = locationPhrases.getJSONObject(l);
                if (!locationPhrase.has("phrase")) continue;
                sherpaLocations.add(locationPhrase.getString("phrase").trim());
            }
        }
        permittedVersion.setLocations(sherpaLocations);
        ArrayList<String> sherpaLicenses = new ArrayList<String>();
        if (permitted.has("license")) {
            JSONArray licences = permitted.getJSONArray("license");
            for (int l = 0; l < licences.length(); ++l) {
                JSONObject licence = licences.getJSONObject(l);
                if (!licence.has("license_phrases")) continue;
                JSONArray phrases = licence.getJSONArray("license_phrases");
                for (int ll = 0; ll < phrases.length(); ++ll) {
                    JSONObject phrase = phrases.getJSONObject(ll);
                    if (!phrase.has("phrase")) continue;
                    sherpaLicenses.add(phrase.getString("phrase").trim());
                }
            }
        }
        permittedVersion.setLicenses(sherpaLicenses);
        if (permitted.has("embargo")) {
            JSONObject embargo = permitted.getJSONObject("embargo");
            SHERPAEmbargo SHERPAEmbargo2 = new SHERPAEmbargo(embargo.getInt("amount"), embargo.getString("units"));
            permittedVersion.setEmbargo(SHERPAEmbargo2);
        }
        return permittedVersion;
    }

    private String parsePublisherName(JSONObject publisher) {
        JSONObject publisherName;
        JSONArray publisherNames;
        String name = null;
        if (publisher.has("name") && (publisherNames = publisher.getJSONArray("name")).length() > 0 && (publisherName = publisherNames.getJSONObject(0)).has("name")) {
            name = publisherName.getString("name").trim();
        }
        return name;
    }

    private String parsePublisherURL(JSONObject publisher) {
        if (publisher.has("url")) {
            return publisher.getString("url");
        }
        return null;
    }

    public SHERPAResponse(String message) {
        this.message = message;
        this.error = true;
    }

    public boolean isError() {
        return this.error;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public List<SHERPAJournal> getJournals() {
        return this.journals;
    }

    public SHERPASystemMetadata getMetadata() {
        return this.metadata;
    }

    public Instant getRetrievalTime() {
        return this.retrievalTime;
    }

    public static enum SHERPAFormat {
        JSON,
        XML;

    }
}

