/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.client;

import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.impl.conn.DefaultRoutePlanner;
import org.apache.http.protocol.HttpContext;
import org.dspace.services.ConfigurationService;

public class DSpaceProxyRoutePlanner
extends DefaultRoutePlanner {
    private ConfigurationService configurationService;

    public DSpaceProxyRoutePlanner(ConfigurationService configurationService) {
        super(null);
        this.configurationService = configurationService;
    }

    protected HttpHost determineProxy(HttpHost target, HttpRequest request, HttpContext context) throws HttpException {
        if (this.isTargetHostConfiguredToBeIgnored(target)) {
            return null;
        }
        String proxyHost = this.configurationService.getProperty("http.proxy.host");
        String proxyPort = this.configurationService.getProperty("http.proxy.port");
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{proxyHost, proxyPort})) {
            return null;
        }
        try {
            return new HttpHost(proxyHost, Integer.parseInt(proxyPort), "http");
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Invalid proxy port configuration: " + proxyPort);
        }
    }

    private boolean isTargetHostConfiguredToBeIgnored(HttpHost target) {
        Object[] hostsToIgnore = this.configurationService.getArrayProperty("http.proxy.hosts-to-ignore");
        if (ArrayUtils.isEmpty((Object[])hostsToIgnore)) {
            return false;
        }
        return Arrays.stream(hostsToIgnore).anyMatch(host -> this.matchesHost((String)host, target.getHostName()));
    }

    private boolean matchesHost(String hostPattern, String hostName) {
        if (hostName.equals(hostPattern)) {
            return true;
        }
        if (hostPattern.startsWith("*")) {
            return hostName.endsWith(StringUtils.removeStart((String)hostPattern, (String)"*"));
        }
        if (hostPattern.endsWith("*")) {
            return hostName.startsWith(StringUtils.removeEnd((String)hostPattern, (String)"*"));
        }
        return false;
    }
}

