/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.versioning;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import java.time.Instant;
import org.dspace.content.Item;
import org.dspace.core.HibernateProxyHelper;
import org.dspace.core.ReloadableEntity;
import org.dspace.eperson.EPerson;
import org.dspace.versioning.VersionHistory;

@Entity
@Table(name="versionitem")
public class Version
implements ReloadableEntity<Integer> {
    @Id
    @Column(name="versionitem_id")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="versionitem_seq")
    @SequenceGenerator(name="versionitem_seq", sequenceName="versionitem_seq", allocationSize=1)
    private Integer id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="item_id")
    private Item item;
    @Column(name="version_number")
    private int versionNumber;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="eperson_id")
    private EPerson ePerson;
    @Column(name="version_date")
    private Instant versionDate;
    @Column(name="version_summary", length=255)
    private String summary;
    @ManyToOne
    @JoinColumn(name="versionhistory_id")
    private VersionHistory versionHistory;

    protected Version() {
    }

    @Override
    public Integer getID() {
        return this.id;
    }

    public Item getItem() {
        return this.item;
    }

    public void setItem(Item item) {
        this.item = item;
    }

    public int getVersionNumber() {
        return this.versionNumber;
    }

    public void setVersionNumber(int version_number) {
        this.versionNumber = version_number;
    }

    public EPerson getEPerson() {
        return this.ePerson;
    }

    public void setePerson(EPerson ePerson) {
        this.ePerson = ePerson;
    }

    public Instant getVersionDate() {
        return this.versionDate;
    }

    public void setVersionDate(Instant versionDate) {
        this.versionDate = versionDate;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String versionSummary) {
        this.summary = versionSummary;
    }

    public VersionHistory getVersionHistory() {
        return this.versionHistory;
    }

    public void setVersionHistory(VersionHistory versionHistory) {
        this.versionHistory = versionHistory;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        Class objClass = HibernateProxyHelper.getClassWithoutInitializingProxy(o);
        if (!this.getClass().equals(objClass)) {
            return false;
        }
        Version that = (Version)o;
        return this.getID().equals(that.getID());
    }

    public int hashCode() {
        int hash = 7;
        hash = 79 * hash + this.getID();
        return hash;
    }
}

