/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.util;

import java.text.ParseException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DateMathParser {
    private static final Logger LOG = LogManager.getLogger();
    public static final TimeZone UTC;
    public static final TimeZone DEFAULT_MATH_TZ;
    public static final DateTimeFormatter PARSER;
    public static final Map<String, ChronoUnit> CALENDAR_UNITS;
    private static final String BAD_REQUEST = "[BAD REQUEST]";
    private TimeZone zone;
    private Locale loc;
    private LocalDateTime now;
    private static Pattern splitter;

    private static Map<String, ChronoUnit> makeUnitsMap() {
        HashMap<String, ChronoUnit> units = new HashMap<String, ChronoUnit>(13);
        units.put("YEAR", ChronoUnit.YEARS);
        units.put("YEARS", ChronoUnit.YEARS);
        units.put("MONTH", ChronoUnit.MONTHS);
        units.put("MONTHS", ChronoUnit.MONTHS);
        units.put("DAY", ChronoUnit.DAYS);
        units.put("DAYS", ChronoUnit.DAYS);
        units.put("DATE", ChronoUnit.DAYS);
        units.put("HOUR", ChronoUnit.HOURS);
        units.put("HOURS", ChronoUnit.HOURS);
        units.put("MINUTE", ChronoUnit.MINUTES);
        units.put("MINUTES", ChronoUnit.MINUTES);
        units.put("SECOND", ChronoUnit.SECONDS);
        units.put("SECONDS", ChronoUnit.SECONDS);
        units.put("MILLI", ChronoUnit.MILLIS);
        units.put("MILLIS", ChronoUnit.MILLIS);
        units.put("MILLISECOND", ChronoUnit.MILLIS);
        units.put("MILLISECONDS", ChronoUnit.MILLIS);
        return units;
    }

    private static LocalDateTime add(LocalDateTime t, int val, String unit) {
        ChronoUnit uu = CALENDAR_UNITS.get(unit);
        if (null == uu) {
            throw new IllegalArgumentException("Adding Unit not recognized: " + unit);
        }
        return t.plus(val, uu);
    }

    private static LocalDateTime round(LocalDateTime t, String unit) {
        ChronoUnit uu = CALENDAR_UNITS.get(unit);
        if (null == uu) {
            throw new IllegalArgumentException("Rounding Unit not recognized: " + unit);
        }
        switch (uu) {
            case YEARS: {
                return LocalDateTime.of(LocalDate.of(t.getYear(), 1, 1), LocalTime.MIDNIGHT);
            }
            case MONTHS: {
                return LocalDateTime.of(LocalDate.of(t.getYear(), t.getMonth(), 1), LocalTime.MIDNIGHT);
            }
            case DAYS: {
                return LocalDateTime.of(t.toLocalDate(), LocalTime.MIDNIGHT);
            }
        }
        assert (!uu.isDateBased());
        return t.truncatedTo(uu);
    }

    public static LocalDateTime parseMath(LocalDateTime now, String val) throws Exception {
        String math;
        DateMathParser p = new DateMathParser();
        if (null != now) {
            p.setNow(now);
        }
        if (val.startsWith("NOW")) {
            math = val.substring("NOW".length());
        } else {
            int zz = val.indexOf(90);
            if (zz == -1) {
                throw new Exception("[BAD REQUEST]Invalid Date String:'" + val + "'");
            }
            math = val.substring(zz + 1);
            try {
                p.setNow(DateMathParser.parseNoMath(val.substring(0, zz + 1)));
            }
            catch (DateTimeParseException e) {
                throw new Exception("[BAD REQUEST]Invalid Date in Date Math String:'" + val + "'", e);
            }
        }
        if (null == math || math.equals("")) {
            return p.getNow();
        }
        try {
            return p.parseMath(math);
        }
        catch (ParseException e) {
            throw new Exception("[BAD REQUEST]Invalid Date Math String:'" + val + "'", e);
        }
    }

    private static LocalDateTime parseNoMath(String val) {
        return PARSER.parse((CharSequence)val, LocalDateTime::from);
    }

    public DateMathParser() {
        this(null);
    }

    public DateMathParser(TimeZone tz) {
        this.zone = null != tz ? tz : DEFAULT_MATH_TZ;
    }

    public TimeZone getTimeZone() {
        return this.zone;
    }

    public void setNow(LocalDateTime n) {
        this.now = n;
    }

    public LocalDateTime getNow() {
        if (this.now == null) {
            this.now = LocalDateTime.now(this.zone.toZoneId());
        }
        return this.now;
    }

    public LocalDateTime parseMath(String math) throws ParseException {
        if (0 == math.length()) {
            return this.getNow();
        }
        LOG.debug("parsing {}", (Object)math);
        ZoneId zoneId = this.zone.toZoneId();
        LocalDateTime localDateTime = ZonedDateTime.of(this.getNow(), zoneId).toLocalDateTime();
        String[] ops = splitter.split(math);
        int pos = 0;
        block10: while (pos < ops.length) {
            if (1 != ops[pos].length()) {
                throw new ParseException("Multi character command found: \"" + ops[pos] + "\"", pos);
            }
            char command = ops[pos++].charAt(0);
            switch (command) {
                case '/': {
                    if (ops.length < pos + 1) {
                        throw new ParseException("Need a unit after command: \"" + command + "\"", pos);
                    }
                    try {
                        localDateTime = DateMathParser.round(localDateTime, ops[pos++]);
                        continue block10;
                    }
                    catch (IllegalArgumentException e) {
                        throw new ParseException("Unit not recognized: \"" + ops[pos - 1] + "\"", pos - 1);
                    }
                }
                case '+': 
                case '-': {
                    if (ops.length < pos + 2) {
                        throw new ParseException("Need a value and unit for command: \"" + command + "\"", pos);
                    }
                    int val = 0;
                    try {
                        val = Integer.parseInt(ops[pos++]);
                    }
                    catch (NumberFormatException e) {
                        throw new ParseException("Not a Number: \"" + ops[pos - 1] + "\"", pos - 1);
                    }
                    if ('-' == command) {
                        val = 0 - val;
                    }
                    try {
                        String unit = ops[pos++];
                        localDateTime = DateMathParser.add(localDateTime, val, unit);
                        continue block10;
                    }
                    catch (IllegalArgumentException e) {
                        throw new ParseException("Unit not recognized: \"" + ops[pos - 1] + "\"", pos - 1);
                    }
                }
            }
            throw new ParseException("Unrecognized command: \"" + command + "\"", pos - 1);
        }
        LOG.debug("returning {}", (Object)localDateTime);
        return ZonedDateTime.of(localDateTime, zoneId).toLocalDateTime();
    }

    public static void main(String[] argv) throws Exception {
        DateMathParser parser = new DateMathParser();
        try {
            LocalDateTime parsed;
            if (argv.length <= 0) {
                System.err.println("Date math expression(s) expected.");
            }
            if (argv.length > 0) {
                parsed = parser.parseMath(argv[0]);
                System.out.format("Applied %s to implicit current time:  %s%n", argv[0], parsed.toString());
            }
            if (argv.length > 1) {
                parsed = DateMathParser.parseMath(LocalDateTime.now(ZoneOffset.UTC), argv[1]);
                System.out.format("Applied %s to explicit current time:  %s%n", argv[1], parsed.toString());
            }
        }
        catch (ParseException ex) {
            System.err.format("Oops:  %s%n", ex.getMessage());
        }
    }

    static {
        DEFAULT_MATH_TZ = UTC = TimeZone.getTimeZone(ZoneOffset.UTC);
        PARSER = new DateTimeFormatterBuilder().parseCaseInsensitive().parseLenient().appendInstant().toFormatter(Locale.ROOT);
        CALENDAR_UNITS = DateMathParser.makeUnitsMap();
        splitter = Pattern.compile("\\b|(?<=\\d)(?=\\D)");
    }
}

