/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.statistics.export.service;

import java.io.IOException;
import java.sql.SQLException;
import java.time.Instant;
import java.time.LocalDate;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.core.Context;
import org.dspace.statistics.export.OpenURLTracker;
import org.dspace.statistics.export.service.FailedOpenURLTrackerService;
import org.dspace.statistics.export.service.OpenUrlService;
import org.springframework.beans.factory.annotation.Autowired;

public class OpenUrlServiceImpl
implements OpenUrlService {
    private final Logger log = LogManager.getLogger();
    @Autowired
    protected FailedOpenURLTrackerService failedOpenUrlTrackerService;

    @Override
    public void processUrl(Context c, String urlStr) throws SQLException {
        this.log.debug("Prepared to send url to tracker URL: " + urlStr);
        try {
            int responseCode = this.getResponseCodeFromUrl(urlStr);
            if (responseCode != 200) {
                this.logfailed(c, urlStr);
            } else if (this.log.isDebugEnabled()) {
                this.log.debug("Successfully posted " + urlStr + " on " + Instant.now());
            }
        }
        catch (Exception e) {
            this.log.error("Failed to send url to tracker URL: " + urlStr);
            this.logfailed(c, urlStr);
        }
    }

    protected int getResponseCodeFromUrl(String urlStr) throws IOException {
        HttpGet httpGet = new HttpGet(urlStr);
        HttpClient httpClient = this.getHttpClient(this.getHttpClientRequestConfig());
        HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpGet);
        return httpResponse.getStatusLine().getStatusCode();
    }

    protected HttpClient getHttpClient(RequestConfig requestConfig) {
        return HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).build();
    }

    protected RequestConfig getHttpClientRequestConfig() {
        return RequestConfig.custom().setConnectTimeout(10000).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tryReprocessFailed(Context context, OpenURLTracker tracker) throws SQLException {
        boolean success = false;
        try {
            int responseCode = this.getResponseCodeFromUrl(tracker.getUrl());
            if (responseCode == 200) {
                success = true;
            }
        }
        catch (Exception e) {
            success = false;
        }
        finally {
            if (success) {
                this.failedOpenUrlTrackerService.remove(context, tracker);
                this.log.info("Successfully posted " + tracker.getUrl() + " from " + tracker.getUploadDate());
            } else {
                this.log.error("Failed attempt from " + tracker.getUrl() + " originating from " + tracker.getUploadDate());
            }
        }
    }

    @Override
    public void reprocessFailedQueue(Context context) throws SQLException {
        if (this.failedOpenUrlTrackerService == null) {
            this.log.error("Error retrieving the \"failedOpenUrlTrackerService\" instance, aborting the processing");
            return;
        }
        List<OpenURLTracker> openURLTrackers = this.failedOpenUrlTrackerService.findAll(context);
        for (OpenURLTracker openURLTracker : openURLTrackers) {
            this.tryReprocessFailed(context, openURLTracker);
        }
    }

    @Override
    public void logfailed(Context context, String url) throws SQLException {
        LocalDate now = LocalDate.now();
        if (StringUtils.isBlank((String)url)) {
            return;
        }
        OpenURLTracker tracker = this.failedOpenUrlTrackerService.create(context);
        tracker.setUploadDate(now);
        tracker.setUrl(url);
    }
}

