/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.matomo.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.function.BiConsumer;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.dspace.matomo.client.MatomoAbstractClient;
import org.dspace.matomo.client.MatomoRequestBuilder;
import org.dspace.matomo.client.MatomoResponseReader;
import org.dspace.matomo.exception.MatomoClientException;

public class MatomoClientImpl
extends MatomoAbstractClient<CloseableHttpClient, HttpPost, HttpResponse> {
    public MatomoClientImpl(String baseUrl, String token, MatomoRequestBuilder matomoRequestBuilder, MatomoResponseReader matomoResponseReader, CloseableHttpClient httpClient) {
        super(baseUrl, token, matomoRequestBuilder, matomoResponseReader, httpClient);
    }

    @Override
    protected void executeRequest(String requestBody, String cookies, BiConsumer<HttpResponse, String> responseConsumer) {
        try (CloseableHttpResponse response = ((CloseableHttpClient)this.httpClient).execute((HttpUriRequest)this.createRequest(requestBody, cookies));){
            responseConsumer.accept((HttpResponse)response, requestBody);
        }
        catch (MatomoClientException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new MatomoClientException("An error occurs sending events to " + this.baseUrl, ex);
        }
    }

    @Override
    protected HttpPost createRequest(String requestBody, String cookies) {
        HttpPost httpPost = new HttpPost(this.baseUrl);
        try {
            httpPost.setHeader("Cookie", cookies);
            httpPost.setEntity((HttpEntity)new StringEntity(requestBody));
        }
        catch (UnsupportedEncodingException e) {
            throw new MatomoClientException("Error creating request", e);
        }
        return httpPost;
    }

    @Override
    protected int getStatusCode(HttpResponse response) {
        return response.getStatusLine().getStatusCode();
    }

    @Override
    protected String getResponseContent(HttpResponse response) {
        try {
            return IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)Charset.defaultCharset());
        }
        catch (IOException | UnsupportedOperationException e) {
            this.log.error("An error occurs getting the response content", (Throwable)e);
            return "Generic error";
        }
    }
}

