/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.importer.external.openalex.metadatamapping;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.importer.external.metadatamapping.MetadataFieldConfig;
import org.dspace.importer.external.metadatamapping.MetadatumDTO;
import org.dspace.importer.external.metadatamapping.contributor.SimpleJsonPathMetadataContributor;

public class OpenAlexAuthorNameContributor
extends SimpleJsonPathMetadataContributor {
    private static final Logger log = LogManager.getLogger();
    private String query;
    private MetadataFieldConfig field;

    @Override
    public void setQuery(String query) {
        this.query = query;
    }

    @Override
    public void setField(MetadataFieldConfig field) {
        this.field = field;
    }

    @Override
    public Collection<MetadatumDTO> contributeMetadata(String fullJson) {
        ArrayList<MetadatumDTO> metadata = new ArrayList<MetadatumDTO>();
        if (this.field == null || this.field.getElement() == null) {
            return metadata;
        }
        JsonNode jsonNode = this.convertStringJsonToJsonNode(fullJson);
        JsonNode node = jsonNode.at(this.query);
        if (node.isArray() || node.isNull() || StringUtils.isBlank((CharSequence)node.asText())) {
            return metadata;
        }
        String fullName = this.getStringValue(node).trim();
        String[] nameParts = fullName.split(" ");
        if (nameParts.length < 1) {
            return metadata;
        }
        String firstName = nameParts.length > 1 ? String.join((CharSequence)" ", Arrays.copyOfRange(nameParts, 0, nameParts.length - 1)) : "";
        String lastName = nameParts[nameParts.length - 1];
        if ("givenName".equals(this.field.getElement()) && StringUtils.isNotBlank((CharSequence)firstName)) {
            metadata.add(this.createMetadatum(this.field, firstName));
        } else if ("familyName".equals(this.field.getElement()) && StringUtils.isNotBlank((CharSequence)lastName)) {
            metadata.add(this.createMetadatum(this.field, lastName));
        }
        return metadata;
    }

    private MetadatumDTO createMetadatum(MetadataFieldConfig field, String value) {
        MetadatumDTO metadatum = new MetadatumDTO();
        metadatum.setValue(value);
        metadatum.setElement(field.getElement());
        metadatum.setQualifier(field.getQualifier());
        metadatum.setSchema(field.getSchema());
        return metadatum;
    }

    private String getStringValue(JsonNode node) {
        if (node.isTextual()) {
            return node.textValue();
        }
        if (node.isNumber()) {
            return node.numberValue().toString();
        }
        log.error("It wasn't possible to convert the value of the following JsonNode:" + node.asText());
        return "";
    }

    private JsonNode convertStringJsonToJsonNode(String json) {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode body = null;
        try {
            body = mapper.readTree(json);
        }
        catch (JsonProcessingException e) {
            log.error("Unable to process json response.", (Throwable)e);
        }
        return body;
    }
}

