/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.eperson;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import java.util.ArrayList;
import java.util.List;
import org.dspace.content.DSpaceObject;
import org.dspace.core.ReloadableEntity;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.SubscriptionParameter;

@Entity
@Table(name="subscription")
public class Subscription
implements ReloadableEntity<Integer> {
    @Id
    @Column(name="subscription_id", unique=true, nullable=false)
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="subscription_seq")
    @SequenceGenerator(name="subscription_seq", sequenceName="subscription_seq", allocationSize=1)
    private Integer id;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="dspace_object_id")
    private DSpaceObject dSpaceObject;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="eperson_id")
    private EPerson ePerson;
    @Column(name="type")
    private String subscriptionType;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="subscription", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<SubscriptionParameter> subscriptionParameterList = new ArrayList<SubscriptionParameter>();

    protected Subscription() {
    }

    @Override
    public Integer getID() {
        return this.id;
    }

    public DSpaceObject getDSpaceObject() {
        return this.dSpaceObject;
    }

    void setDSpaceObject(DSpaceObject dSpaceObject) {
        this.dSpaceObject = dSpaceObject;
    }

    public EPerson getEPerson() {
        return this.ePerson;
    }

    public void setEPerson(EPerson ePerson) {
        this.ePerson = ePerson;
    }

    public String getSubscriptionType() {
        return this.subscriptionType;
    }

    public void setSubscriptionType(String subscriptionType) {
        this.subscriptionType = subscriptionType;
    }

    public List<SubscriptionParameter> getSubscriptionParameterList() {
        return this.subscriptionParameterList;
    }

    public void setSubscriptionParameterList(List<SubscriptionParameter> subscriptionList) {
        this.subscriptionParameterList = subscriptionList;
    }

    public void addParameter(SubscriptionParameter subscriptionParameter) {
        this.subscriptionParameterList.add(subscriptionParameter);
        subscriptionParameter.setSubscription(this);
    }

    public void removeParameterList() {
        this.subscriptionParameterList.clear();
    }

    public void removeParameter(SubscriptionParameter subscriptionParameter) {
        this.subscriptionParameterList.remove(subscriptionParameter);
    }
}

