/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.eperson;

import java.sql.SQLException;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.MetadataField;
import org.dspace.content.MetadataValue;
import org.dspace.content.service.MetadataFieldService;
import org.dspace.core.Context;
import org.dspace.core.Utils;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.RegistrationData;
import org.dspace.eperson.RegistrationDataExpirationConfiguration;
import org.dspace.eperson.RegistrationDataMetadata;
import org.dspace.eperson.RegistrationTypeEnum;
import org.dspace.eperson.dao.RegistrationDataDAO;
import org.dspace.eperson.dto.RegistrationDataChanges;
import org.dspace.eperson.dto.RegistrationDataPatch;
import org.dspace.eperson.service.RegistrationDataMetadataService;
import org.dspace.eperson.service.RegistrationDataService;
import org.springframework.beans.factory.annotation.Autowired;

public class RegistrationDataServiceImpl
implements RegistrationDataService {
    @Autowired
    protected RegistrationDataDAO registrationDataDAO;
    @Autowired
    protected RegistrationDataMetadataService registrationDataMetadataService;
    @Autowired
    protected MetadataFieldService metadataFieldService;
    protected RegistrationDataExpirationConfiguration expirationConfiguration = RegistrationDataExpirationConfiguration.getInstance();

    protected RegistrationDataServiceImpl() {
    }

    @Override
    public RegistrationData create(Context context) throws SQLException, AuthorizeException {
        return this.create(context, null, null);
    }

    @Override
    public RegistrationData create(Context context, String netId) throws SQLException, AuthorizeException {
        return this.create(context, netId, null);
    }

    @Override
    public RegistrationData create(Context context, String netId, RegistrationTypeEnum type) throws SQLException, AuthorizeException {
        return this.registrationDataDAO.create(context, this.newInstance(netId, type, null));
    }

    private RegistrationData newInstance(String netId, RegistrationTypeEnum type, String email) {
        RegistrationData rd = new RegistrationData(netId);
        rd.setToken(Utils.generateHexKey());
        rd.setRegistrationType(type);
        rd.setExpires(this.expirationConfiguration.computeExpirationDate(type));
        rd.setEmail(email);
        return rd;
    }

    @Override
    public RegistrationData clone(Context context, RegistrationDataPatch registrationDataPatch) throws SQLException, AuthorizeException {
        RegistrationData old = registrationDataPatch.getOldRegistration();
        RegistrationDataChanges changes = registrationDataPatch.getChanges();
        RegistrationData rd = this.newInstance(old.getNetId(), changes.getRegistrationType(), changes.getEmail());
        for (RegistrationDataMetadata metadata : old.getMetadata()) {
            this.addMetadata(context, rd, metadata.getMetadataField(), metadata.getValue());
        }
        return this.registrationDataDAO.create(context, rd);
    }

    private boolean isEmailConfirmed(RegistrationData old, String newEmail) {
        return newEmail.equals(old.getEmail());
    }

    @Override
    public RegistrationData findByToken(Context context, String token) throws SQLException {
        return this.registrationDataDAO.findByToken(context, token);
    }

    @Override
    public RegistrationData findByEmail(Context context, String email) throws SQLException {
        return this.registrationDataDAO.findByEmail(context, email);
    }

    @Override
    public RegistrationData findBy(Context context, String email, RegistrationTypeEnum type) throws SQLException {
        return this.registrationDataDAO.findBy(context, email, type);
    }

    @Override
    public void deleteByToken(Context context, String token) throws SQLException {
        this.registrationDataDAO.deleteByToken(context, token);
    }

    @Override
    public Stream<Map.Entry<RegistrationDataMetadata, Optional<MetadataValue>>> groupEpersonMetadataByRegistrationData(EPerson ePerson, RegistrationData registrationData) throws SQLException {
        Map<MetadataField, List<MetadataValue>> epersonMeta = ePerson.getMetadata().stream().collect(Collectors.groupingBy(MetadataValue::getMetadataField));
        return registrationData.getMetadata().stream().map(meta -> Map.entry(meta, Optional.ofNullable((List)epersonMeta.get(meta.getMetadataField())).filter(list -> list.size() == 1).map(values -> (MetadataValue)values.get(0))));
    }

    @Override
    public void setRegistrationMetadataValue(Context context, RegistrationData registration, String schema, String element, String qualifier, String value) throws SQLException, AuthorizeException {
        RegistrationDataMetadata registrationDataMetadata;
        List metadata = registration.getMetadata().stream().filter(m -> this.areEquals((RegistrationDataMetadata)m, schema, element, qualifier)).collect(Collectors.toList());
        if (metadata.size() > 1) {
            throw new IllegalStateException("Find more than one registration metadata to update!");
        }
        if (metadata.isEmpty()) {
            registrationDataMetadata = this.createMetadata(context, registration, schema, element, qualifier, value);
        } else {
            registrationDataMetadata = (RegistrationDataMetadata)metadata.get(0);
            registrationDataMetadata.setValue(value);
        }
        this.registrationDataMetadataService.update(context, registrationDataMetadata);
    }

    @Override
    public void addMetadata(Context context, RegistrationData registration, MetadataField mf, String value) throws SQLException, AuthorizeException {
        registration.getMetadata().add(this.registrationDataMetadataService.create(context, registration, mf, value));
        this.update(context, registration);
    }

    @Override
    public void addMetadata(Context context, RegistrationData registration, String schema, String element, String qualifier, String value) throws SQLException, AuthorizeException {
        MetadataField mf = this.metadataFieldService.findByElement(context, schema, element, qualifier);
        registration.getMetadata().add(this.registrationDataMetadataService.create(context, registration, mf, value));
        this.update(context, registration);
    }

    @Override
    public RegistrationDataMetadata getMetadataByMetadataString(RegistrationData registrationData, String field) {
        return registrationData.getMetadata().stream().filter(m -> field.equals(m.getMetadataField().toString('.'))).findFirst().orElse(null);
    }

    private boolean areEquals(RegistrationDataMetadata m, String schema, String element, String qualifier) {
        return m.getMetadataField().getMetadataSchema().getName().equals(schema) && m.getMetadataField().getElement().equals(element) && StringUtils.equals((CharSequence)m.getMetadataField().getQualifier(), (CharSequence)qualifier);
    }

    private RegistrationDataMetadata createMetadata(Context context, RegistrationData registration, String schema, String element, String qualifier, String value) {
        try {
            return this.registrationDataMetadataService.create(context, registration, schema, element, qualifier, value);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private RegistrationDataMetadata createMetadata(Context context, RegistrationData registration, MetadataField mf) {
        try {
            return this.registrationDataMetadataService.create(context, registration, mf);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public RegistrationData find(Context context, int id) throws SQLException {
        return (RegistrationData)this.registrationDataDAO.findByID(context, RegistrationData.class, id);
    }

    @Override
    public void update(Context context, RegistrationData registrationData) throws SQLException, AuthorizeException {
        this.update(context, Collections.singletonList(registrationData));
    }

    @Override
    public void update(Context context, List<RegistrationData> registrationDataRecords) throws SQLException, AuthorizeException {
        if (CollectionUtils.isNotEmpty(registrationDataRecords)) {
            for (RegistrationData registrationData : registrationDataRecords) {
                this.registrationDataDAO.save(context, registrationData);
            }
        }
    }

    @Override
    public void markAsExpired(Context context, RegistrationData registrationData) throws SQLException {
        registrationData.setExpires(Instant.now());
        this.registrationDataDAO.save(context, registrationData);
    }

    @Override
    public void delete(Context context, RegistrationData registrationData) throws SQLException, AuthorizeException {
        this.registrationDataDAO.delete(context, registrationData);
    }

    @Override
    public void deleteExpiredRegistrations(Context context) throws SQLException {
        this.registrationDataDAO.deleteExpiredBy(context, Instant.now());
    }

    @Override
    public boolean isValid(RegistrationData rd) {
        return rd.getExpires() == null || rd.getExpires().isAfter(Instant.now());
    }
}

