/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.eperson;

import java.io.IOException;
import java.sql.SQLException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.factory.AuthorizeServiceFactory;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.authorize.service.ResourcePolicyService;
import org.dspace.content.DSpaceObjectServiceImpl;
import org.dspace.content.Item;
import org.dspace.content.MetadataField;
import org.dspace.content.MetadataValue;
import org.dspace.content.QAEventProcessed;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.WorkspaceItemService;
import org.dspace.core.Context;
import org.dspace.core.LogHelper;
import org.dspace.core.Utils;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.EPersonDeletionException;
import org.dspace.eperson.EmptyWorkflowGroupException;
import org.dspace.eperson.Group;
import org.dspace.eperson.PasswordHash;
import org.dspace.eperson.dao.EPersonDAO;
import org.dspace.eperson.service.EPersonService;
import org.dspace.eperson.service.GroupService;
import org.dspace.eperson.service.SubscribeService;
import org.dspace.event.Event;
import org.dspace.orcid.service.OrcidTokenService;
import org.dspace.qaevent.dao.QAEventsDAO;
import org.dspace.services.ConfigurationService;
import org.dspace.util.UUIDUtils;
import org.dspace.versioning.Version;
import org.dspace.versioning.VersionHistory;
import org.dspace.versioning.dao.VersionDAO;
import org.dspace.versioning.factory.VersionServiceFactory;
import org.dspace.versioning.service.VersionHistoryService;
import org.dspace.versioning.service.VersioningService;
import org.dspace.workflow.WorkflowService;
import org.dspace.workflow.factory.WorkflowServiceFactory;
import org.dspace.xmlworkflow.WorkflowConfigurationException;
import org.dspace.xmlworkflow.factory.XmlWorkflowServiceFactory;
import org.dspace.xmlworkflow.service.WorkflowRequirementsService;
import org.dspace.xmlworkflow.service.XmlWorkflowService;
import org.dspace.xmlworkflow.storedcomponents.ClaimedTask;
import org.dspace.xmlworkflow.storedcomponents.CollectionRole;
import org.dspace.xmlworkflow.storedcomponents.service.ClaimedTaskService;
import org.dspace.xmlworkflow.storedcomponents.service.CollectionRoleService;
import org.dspace.xmlworkflow.storedcomponents.service.PoolTaskService;
import org.dspace.xmlworkflow.storedcomponents.service.WorkflowItemRoleService;
import org.springframework.beans.factory.annotation.Autowired;

public class EPersonServiceImpl
extends DSpaceObjectServiceImpl<EPerson>
implements EPersonService {
    private final Logger log = LogManager.getLogger(EPersonServiceImpl.class);
    @Autowired(required=true)
    protected EPersonDAO ePersonDAO;
    @Autowired(required=true)
    protected AuthorizeService authorizeService;
    @Autowired(required=true)
    protected ItemService itemService;
    @Autowired(required=true)
    protected WorkflowItemRoleService workflowItemRoleService;
    @Autowired(required=true)
    CollectionRoleService collectionRoleService;
    @Autowired(required=true)
    protected GroupService groupService;
    @Autowired(required=true)
    protected SubscribeService subscribeService;
    @Autowired(required=true)
    protected VersionDAO versionDAO;
    @Autowired(required=true)
    protected ClaimedTaskService claimedTaskService;
    @Autowired(required=true)
    protected ConfigurationService configurationService;
    @Autowired
    protected OrcidTokenService orcidTokenService;
    @Autowired
    protected QAEventsDAO qaEventsDao;

    protected EPersonServiceImpl() {
    }

    @Override
    public EPerson find(Context context, UUID id) throws SQLException {
        return (EPerson)this.ePersonDAO.findByID(context, EPerson.class, id);
    }

    @Override
    public EPerson getSystemEPerson(Context c) throws SQLException {
        EPerson systemEPerson;
        String adminEmail = this.configurationService.getProperty("mail.admin");
        if (null == adminEmail) {
            adminEmail = "postmaster";
        }
        if (null == (systemEPerson = this.findByEmail(c, adminEmail))) {
            systemEPerson = new EPerson();
            systemEPerson.setEmail(adminEmail);
        }
        return systemEPerson;
    }

    @Override
    public EPerson findByIdOrLegacyId(Context context, String id) throws SQLException {
        try {
            if (StringUtils.isNumeric((CharSequence)id)) {
                return this.findByLegacyId(context, Integer.parseInt(id));
            }
            return this.find(context, UUID.fromString(id));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Override
    public EPerson findByLegacyId(Context context, int legacyId) throws SQLException {
        return this.ePersonDAO.findByLegacyId(context, legacyId, EPerson.class);
    }

    @Override
    public EPerson findByEmail(Context context, String email) throws SQLException {
        if (email == null) {
            return null;
        }
        return this.ePersonDAO.findByEmail(context, email);
    }

    @Override
    public EPerson findByNetid(Context context, String netId) throws SQLException {
        if (netId == null) {
            return null;
        }
        return this.ePersonDAO.findByNetid(context, netId);
    }

    @Override
    public List<EPerson> search(Context context, String query) throws SQLException {
        if (StringUtils.isBlank((CharSequence)query)) {
            return this.findAll(context, 1);
        }
        return this.search(context, query, -1, -1);
    }

    @Override
    public List<EPerson> search(Context context, String query, int offset, int limit) throws SQLException {
        List<EPerson> ePersons = new ArrayList<EPerson>();
        UUID uuid = UUIDUtils.fromString(query);
        if (uuid == null) {
            MetadataField firstNameField = this.metadataFieldService.findByElement(context, "eperson", "firstname", null);
            MetadataField lastNameField = this.metadataFieldService.findByElement(context, "eperson", "lastname", null);
            if (StringUtils.isBlank((CharSequence)query)) {
                query = null;
            }
            ePersons = this.ePersonDAO.search(context, query, Arrays.asList(firstNameField, lastNameField), Arrays.asList(firstNameField, lastNameField), offset, limit);
        } else {
            EPerson person = this.find(context, uuid);
            if (person != null) {
                ePersons.add(person);
            }
        }
        return ePersons;
    }

    @Override
    public int searchResultCount(Context context, String query) throws SQLException {
        int result = 0;
        UUID uuid = UUIDUtils.fromString(query);
        if (uuid == null) {
            MetadataField firstNameField = this.metadataFieldService.findByElement(context, "eperson", "firstname", null);
            MetadataField lastNameField = this.metadataFieldService.findByElement(context, "eperson", "lastname", null);
            if (StringUtils.isBlank((CharSequence)query)) {
                query = null;
            }
            result = this.ePersonDAO.searchResultCount(context, query, Arrays.asList(firstNameField, lastNameField));
        } else {
            EPerson person = this.find(context, uuid);
            if (person != null) {
                result = 1;
            }
        }
        return result;
    }

    @Override
    public List<EPerson> searchNonMembers(Context context, String query, Group excludeGroup, int offset, int limit) throws SQLException {
        List<EPerson> ePersons = new ArrayList<EPerson>();
        UUID uuid = UUIDUtils.fromString(query);
        if (uuid == null) {
            MetadataField firstNameField = this.metadataFieldService.findByElement(context, "eperson", "firstname", null);
            MetadataField lastNameField = this.metadataFieldService.findByElement(context, "eperson", "lastname", null);
            if (StringUtils.isBlank((CharSequence)query)) {
                query = null;
            }
            ePersons = this.ePersonDAO.searchNotMember(context, query, Arrays.asList(firstNameField, lastNameField), excludeGroup, Arrays.asList(firstNameField, lastNameField), offset, limit);
        } else {
            EPerson person = this.find(context, uuid);
            if (person != null && !this.groupService.isDirectMember(excludeGroup, person)) {
                ePersons.add(person);
            }
        }
        return ePersons;
    }

    @Override
    public int searchNonMembersCount(Context context, String query, Group excludeGroup) throws SQLException {
        int result = 0;
        UUID uuid = UUIDUtils.fromString(query);
        if (uuid == null) {
            MetadataField firstNameField = this.metadataFieldService.findByElement(context, "eperson", "firstname", null);
            MetadataField lastNameField = this.metadataFieldService.findByElement(context, "eperson", "lastname", null);
            if (StringUtils.isBlank((CharSequence)query)) {
                query = null;
            }
            result = this.ePersonDAO.searchNotMemberCount(context, query, Arrays.asList(firstNameField, lastNameField), excludeGroup);
        } else {
            EPerson person = this.find(context, uuid);
            if (person != null && !this.groupService.isDirectMember(excludeGroup, person)) {
                result = 1;
            }
        }
        return result;
    }

    @Override
    public List<EPerson> findAll(Context context, int sortField) throws SQLException {
        return this.findAll(context, sortField, -1, -1);
    }

    @Override
    public List<EPerson> findAll(Context context, int sortField, int pageSize, int offset) throws SQLException {
        String sortColumn = null;
        MetadataField metadataFieldSort = null;
        switch (sortField) {
            case 3: {
                sortColumn = "eperson_id";
                break;
            }
            case 1: {
                sortColumn = "email";
                break;
            }
            case 5: {
                metadataFieldSort = this.metadataFieldService.findByElement(context, "eperson", "language", null);
                break;
            }
            case 4: {
                sortColumn = "netid";
                break;
            }
            default: {
                metadataFieldSort = this.metadataFieldService.findByElement(context, "eperson", "lastname", null);
            }
        }
        return this.ePersonDAO.findAll(context, metadataFieldSort, sortColumn, pageSize, offset);
    }

    @Override
    public EPerson create(Context context) throws SQLException, AuthorizeException {
        if (!this.authorizeService.isAdmin(context)) {
            throw new AuthorizeException("You must be an admin to create an EPerson");
        }
        EPerson e = this.ePersonDAO.create(context, new EPerson());
        this.log.info(LogHelper.getHeader(context, "create_eperson", "eperson_id=" + e.getID()));
        context.addEvent(new Event(1, 7, e.getID(), null, this.getIdentifiers(context, e)));
        return e;
    }

    @Override
    public void delete(Context context, EPerson ePerson) throws SQLException, AuthorizeException {
        try {
            this.delete(context, ePerson, true);
        }
        catch (AuthorizeException ex) {
            this.log.error("This AuthorizeException: " + ex + " occurred while deleting Eperson with the ID: " + ePerson.getID());
            throw new AuthorizeException(ex);
        }
        catch (IOException ex) {
            this.log.error("This IOException: " + ex + " occurred while deleting Eperson with the ID: " + ePerson.getID());
            throw new AuthorizeException(ex);
        }
        catch (EPersonDeletionException e) {
            throw new IllegalStateException(e);
        }
    }

    public void delete(Context context, EPerson ePerson, boolean cascade) throws SQLException, AuthorizeException, IOException, EPersonDeletionException {
        if (!this.authorizeService.isAdmin(context)) {
            throw new AuthorizeException("You must be an admin to delete an EPerson");
        }
        Set<Group> workFlowGroups = this.getAllWorkFlowGroups(context, ePerson);
        for (Group group : workFlowGroups) {
            int totalMembers = this.groupService.countAllMembers(context, group);
            if (totalMembers != 1) continue;
            throw new EmptyWorkflowGroupException(ePerson.getID(), group.getID());
        }
        List<String> constraintList = this.getDeleteConstraints(context, ePerson);
        if (constraintList.size() > 0) {
            if (cascade) {
                for (String tableName : constraintList) {
                    if (StringUtils.equals((CharSequence)tableName, (CharSequence)"item") || StringUtils.equals((CharSequence)tableName, (CharSequence)"workspaceitem")) {
                        Iterator<Item> itemIterator = this.itemService.findBySubmitter(context, ePerson, true);
                        VersionHistoryService versionHistoryService = VersionServiceFactory.getInstance().getVersionHistoryService();
                        VersioningService versioningService = VersionServiceFactory.getInstance().getVersionService();
                        while (itemIterator.hasNext()) {
                            WorkspaceItemService workspaceItemService;
                            WorkspaceItem wsi;
                            Item item = itemIterator.next();
                            VersionHistory versionHistory = versionHistoryService.findByItem(context, item);
                            if (null != versionHistory) {
                                for (Version version : versioningService.getVersionsByHistory(context, versionHistory)) {
                                    version.setePerson(null);
                                    this.versionDAO.save(context, version);
                                }
                            }
                            if (null != (wsi = (workspaceItemService = ContentServiceFactory.getInstance().getWorkspaceItemService()).findByItem(context, item))) {
                                workspaceItemService.deleteAll(context, wsi);
                                continue;
                            }
                            item.setSubmitter(null);
                            this.itemService.update(context, item);
                        }
                        continue;
                    }
                    if (StringUtils.equals((CharSequence)tableName, (CharSequence)"cwf_claimtask")) {
                        ClaimedTaskService claimedTaskService = XmlWorkflowServiceFactory.getInstance().getClaimedTaskService();
                        XmlWorkflowService xmlWorkflowService = XmlWorkflowServiceFactory.getInstance().getXmlWorkflowService();
                        WorkflowRequirementsService workflowRequirementsService = XmlWorkflowServiceFactory.getInstance().getWorkflowRequirementsService();
                        List<ClaimedTask> claimedTasks = claimedTaskService.findByEperson(context, ePerson);
                        for (ClaimedTask task : claimedTasks) {
                            xmlWorkflowService.deleteClaimedTask(context, task.getWorkflowItem(), task);
                            try {
                                workflowRequirementsService.removeClaimedUser(context, task.getWorkflowItem(), ePerson, task.getStepID());
                            }
                            catch (WorkflowConfigurationException ex) {
                                this.log.error("This WorkflowConfigurationException: " + ex + " occurred while deleting Eperson with the ID: " + ePerson.getID());
                                throw new AuthorizeException(new EPersonDeletionException(Collections.singletonList(tableName)));
                            }
                        }
                        continue;
                    }
                    if (StringUtils.equals((CharSequence)tableName, (CharSequence)"resourcepolicy")) {
                        this.authorizeService.removeAllEPersonPolicies(context, ePerson);
                        continue;
                    }
                    if (StringUtils.equals((CharSequence)tableName, (CharSequence)"cwf_pooltask")) {
                        PoolTaskService poolTaskService = XmlWorkflowServiceFactory.getInstance().getPoolTaskService();
                        poolTaskService.deleteByEperson(context, ePerson);
                        continue;
                    }
                    if (StringUtils.equals((CharSequence)tableName, (CharSequence)"cwf_workflowitemrole")) {
                        WorkflowItemRoleService workflowItemRoleService = XmlWorkflowServiceFactory.getInstance().getWorkflowItemRoleService();
                        workflowItemRoleService.deleteByEPerson(context, ePerson);
                        continue;
                    }
                    this.log.warn("EPerson is referenced in table '" + tableName + "'. Deletion of EPerson " + ePerson.getID() + " may fail if the database does not handle this reference.");
                }
            } else {
                throw new EPersonDeletionException(constraintList);
            }
        }
        context.addEvent(new Event(32, 7, ePerson.getID(), ePerson.getEmail(), this.getIdentifiers(context, ePerson)));
        Iterator<Group> groups = ePerson.getGroups().iterator();
        while (groups.hasNext()) {
            Group group = groups.next();
            groups.remove();
            group.getMembers().remove(ePerson);
        }
        this.orcidTokenService.deleteByEPerson(context, ePerson);
        this.subscribeService.deleteByEPerson(context, ePerson);
        List<QAEventProcessed> qaEvents = this.qaEventsDao.findByEPerson(context, ePerson);
        for (QAEventProcessed qaEvent : qaEvents) {
            this.qaEventsDao.delete(context, qaEvent);
        }
        this.ePersonDAO.delete(context, ePerson);
        this.log.info(LogHelper.getHeader(context, "delete_eperson", "eperson_id=" + ePerson.getID()));
    }

    private Set<Group> getAllWorkFlowGroups(Context context, EPerson ePerson) throws SQLException {
        HashSet<Group> workFlowGroups = new HashSet<Group>();
        Set<Group> groups = this.groupService.allMemberGroupsSet(context, ePerson);
        for (Group group : groups) {
            List<CollectionRole> collectionRoles = this.collectionRoleService.findByGroup(context, group);
            if (collectionRoles.isEmpty()) continue;
            workFlowGroups.add(group);
        }
        return workFlowGroups;
    }

    @Override
    public int getSupportsTypeConstant() {
        return 7;
    }

    @Override
    public void setPassword(EPerson ePerson, String password) {
        PasswordHash hash = new PasswordHash(password);
        ePerson.setDigestAlgorithm(hash.getAlgorithm());
        ePerson.setSalt(Utils.toHex(hash.getSalt()));
        ePerson.setPassword(Utils.toHex(hash.getHash()));
    }

    @Override
    public void setPasswordHash(EPerson ePerson, PasswordHash password) {
        if (null == password) {
            ePerson.setDigestAlgorithm(null);
            ePerson.setSalt(null);
            ePerson.setPassword(null);
        } else {
            ePerson.setDigestAlgorithm(password.getAlgorithm());
            ePerson.setSalt(password.getSaltString());
            ePerson.setPassword(password.getHashString());
        }
    }

    @Override
    public PasswordHash getPasswordHash(EPerson ePerson) {
        PasswordHash hash = null;
        try {
            hash = new PasswordHash(ePerson.getDigestAlgorithm(), ePerson.getSalt(), ePerson.getPassword());
        }
        catch (DecoderException ex) {
            this.log.error("Problem decoding stored salt or hash:  " + ex.getMessage());
        }
        return hash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkPassword(Context context, EPerson ePerson, String attempt) {
        PasswordHash myHash;
        try {
            myHash = new PasswordHash(ePerson.getDigestAlgorithm(), ePerson.getSalt(), ePerson.getPassword());
        }
        catch (DecoderException ex) {
            this.log.error(ex.getMessage());
            return false;
        }
        boolean answer = myHash.matches(attempt);
        if (answer && null == ePerson.getDigestAlgorithm()) {
            this.log.info("Upgrading password hash for EPerson " + ePerson.getID());
            this.setPassword(ePerson, attempt);
            try {
                context.turnOffAuthorisationSystem();
                this.update(context, ePerson);
            }
            catch (SQLException | AuthorizeException ex) {
                this.log.error("Could not update password hash", (Throwable)ex);
            }
            finally {
                context.restoreAuthSystemState();
            }
        }
        return answer;
    }

    @Override
    public void update(Context context, EPerson ePerson) throws SQLException, AuthorizeException {
        if (!(context.ignoreAuthorization() || context.getCurrentUser() != null && ePerson.getID() == context.getCurrentUser().getID())) {
            this.authorizeService.authorizeAction(context, ePerson, 1);
        }
        super.update(context, ePerson);
        this.ePersonDAO.save(context, ePerson);
        this.log.info(LogHelper.getHeader(context, "update_eperson", "eperson_id=" + ePerson.getID()));
        if (ePerson.isModified()) {
            context.addEvent(new Event(2, 7, ePerson.getID(), null, this.getIdentifiers(context, ePerson)));
            ePerson.clearModified();
        }
        if (ePerson.isMetadataModified()) {
            ePerson.clearDetails();
        }
    }

    @Override
    public List<String> getDeleteConstraints(Context context, EPerson ePerson) throws SQLException {
        ResourcePolicyService resourcePolicyService;
        WorkspaceItemService workspaceItemService;
        List<WorkspaceItem> workspaceBySubmitter;
        ArrayList<String> tableList = new ArrayList<String>();
        Iterator<Item> itemsBySubmitter = this.itemService.findBySubmitter(context, ePerson, true);
        if (itemsBySubmitter.hasNext()) {
            tableList.add("item");
        }
        if ((workspaceBySubmitter = (workspaceItemService = ContentServiceFactory.getInstance().getWorkspaceItemService()).findByEPerson(context, ePerson)).size() > 0) {
            tableList.add("workspaceitem");
        }
        if ((resourcePolicyService = AuthorizeServiceFactory.getInstance().getResourcePolicyService()).find(context, ePerson).size() > 0) {
            tableList.add("resourcepolicy");
        }
        WorkflowService workflowService = WorkflowServiceFactory.getInstance().getWorkflowService();
        List<String> workflowConstraints = workflowService.getEPersonDeleteConstraints(context, ePerson);
        tableList.addAll(workflowConstraints);
        return tableList;
    }

    @Override
    public List<EPerson> findByGroups(Context c, Set<Group> groups) throws SQLException {
        return this.findByGroups(c, groups, -1, -1);
    }

    @Override
    public List<EPerson> findByGroups(Context c, Set<Group> groups, int pageSize, int offset) throws SQLException {
        if (CollectionUtils.isNotEmpty(groups)) {
            return this.ePersonDAO.findByGroups(c, groups, pageSize, offset);
        }
        return new ArrayList<EPerson>();
    }

    @Override
    public int countByGroups(Context c, Set<Group> groups) throws SQLException {
        if (CollectionUtils.isNotEmpty(groups)) {
            return this.ePersonDAO.countByGroups(c, groups);
        }
        return 0;
    }

    @Override
    public List<EPerson> findEPeopleWithSubscription(Context context) throws SQLException {
        return this.ePersonDAO.findAllSubscribers(context);
    }

    @Override
    public void updateLastModified(Context context, EPerson dso) throws SQLException {
    }

    @Override
    public String getMetadata(EPerson dso, String field) {
        String[] MDValue = this.getMDValueByLegacyField(field);
        return this.getMetadataFirstValue(dso, MDValue[0], MDValue[1], MDValue[2], "*");
    }

    @Override
    public List<EPerson> findUnsalted(Context context) throws SQLException {
        return this.ePersonDAO.findWithPasswordWithoutDigestAlgorithm(context);
    }

    @Override
    public List<EPerson> findNotActiveSince(Context context, Instant date) throws SQLException {
        return this.ePersonDAO.findNotActiveSince(context, date);
    }

    @Override
    public int countTotal(Context context) throws SQLException {
        return this.ePersonDAO.countRows(context);
    }

    @Override
    public EPerson findByProfileItem(Context context, Item profile) throws SQLException {
        List<MetadataValue> owners = this.itemService.getMetadata(profile, "dspace", "object", "owner", "*");
        if (CollectionUtils.isEmpty(owners)) {
            return null;
        }
        return this.find(context, UUIDUtils.fromString(owners.get(0).getAuthority()));
    }

    @Override
    public String getName(EPerson dso) {
        return dso.getName();
    }
}

