/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.itemmarking;

import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.itemmarking.ItemMarkingExtractor;
import org.dspace.app.itemmarking.ItemMarkingInfo;
import org.dspace.app.util.Util;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Item;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;

public class ItemMarkingAvailabilityBitstreamStrategy
implements ItemMarkingExtractor {
    private String availableImageName;
    private String nonAvailableImageName;
    @Autowired(required=true)
    protected ItemService itemService;
    private static final Logger LOG = LogManager.getLogger();

    @Override
    public ItemMarkingInfo getItemMarkingInfo(Context context, Item item) throws SQLException {
        List<Bundle> bundles = this.itemService.getBundles(item, "ORIGINAL");
        if (bundles.isEmpty()) {
            ItemMarkingInfo markInfo = new ItemMarkingInfo();
            markInfo.setImageName(this.nonAvailableImageName);
            return markInfo;
        }
        Bundle originalBundle = bundles.iterator().next();
        if (originalBundle.getBitstreams().isEmpty()) {
            ItemMarkingInfo markInfo = new ItemMarkingInfo();
            markInfo.setImageName(this.nonAvailableImageName);
            return markInfo;
        }
        Bitstream bitstream = originalBundle.getBitstreams().get(0);
        ItemMarkingInfo signInfo = new ItemMarkingInfo();
        signInfo.setImageName(this.availableImageName);
        signInfo.setTooltip(bitstream.getName());
        Object bsLink = "";
        bsLink = (String)bsLink + "bitstream/" + item.getHandle() + "/" + bitstream.getSequenceID() + "/";
        try {
            bsLink = (String)bsLink + Util.encodeBitstreamName(bitstream.getName(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOG.warn("DSpace uses an unsupported encoding", (Throwable)e);
        }
        signInfo.setLink((String)bsLink);
        return signInfo;
    }

    public void setAvailableImageName(String availableImageName) {
        this.availableImageName = availableImageName;
    }

    public void setNonAvailableImageName(String nonAvailableImageName) {
        this.nonAvailableImageName = nonAvailableImageName;
    }
}

