/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.access.status;

import java.sql.SQLException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.dspace.access.status.AccessStatusHelper;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.authorize.factory.AuthorizeServiceFactory;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.authorize.service.ResourcePolicyService;
import org.dspace.content.AccessStatus;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.GroupService;

public class DefaultAccessStatusHelper
implements AccessStatusHelper {
    public static final String STATUS_FOR_CURRENT_USER = "current";
    public static final String STATUS_FOR_ANONYMOUS = "anonymous";
    public static final String EMBARGO = "embargo";
    public static final String METADATA_ONLY = "metadata.only";
    public static final String OPEN_ACCESS = "open.access";
    public static final String RESTRICTED = "restricted";
    public static final String UNKNOWN = "unknown";
    protected ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    protected ResourcePolicyService resourcePolicyService = AuthorizeServiceFactory.getInstance().getResourcePolicyService();
    protected AuthorizeService authorizeService = AuthorizeServiceFactory.getInstance().getAuthorizeService();
    protected GroupService groupService = EPersonServiceFactory.getInstance().getGroupService();

    @Override
    public AccessStatus getAccessStatusFromItem(Context context, Item item, LocalDate threshold, String type) throws SQLException {
        if (item == null) {
            return new AccessStatus(UNKNOWN, null);
        }
        Bitstream bitstream = this.getPrimaryOrFirstBitstreamInOriginalBundle(item);
        if (bitstream == null) {
            return new AccessStatus(METADATA_ONLY, null);
        }
        return this.getAccessStatusFromBitstream(context, bitstream, threshold, type);
    }

    @Override
    public AccessStatus getAccessStatusFromBitstream(Context context, Bitstream bitstream, LocalDate threshold, String type) throws SQLException {
        if (bitstream == null) {
            return new AccessStatus(UNKNOWN, null);
        }
        List<ResourcePolicy> policies = this.getReadPolicies(context, bitstream, type);
        LocalDate availabilityDate = this.findAvailabilityDate(policies, threshold);
        String accessStatus = this.getAccessStatusFromAvailabilityDate(availabilityDate, threshold);
        return new AccessStatus(accessStatus, availabilityDate);
    }

    @Override
    public AccessStatus getAnonymousAccessStatusFromItem(Context context, Item item, LocalDate threshold) throws SQLException {
        return this.getAccessStatusFromItem(context, item, threshold, STATUS_FOR_ANONYMOUS);
    }

    private Bitstream getPrimaryOrFirstBitstreamInOriginalBundle(Item item) {
        List<Bundle> bundles = item.getBundles("ORIGINAL");
        Bitstream bitstream = bundles.stream().map(bundle -> bundle.getPrimaryBitstream()).filter(Objects::nonNull).findFirst().orElse(null);
        if (bitstream == null) {
            bitstream = bundles.stream().map(bundle -> bundle.getBitstreams()).flatMap(Collection::stream).findFirst().orElse(null);
        }
        return bitstream;
    }

    private List<ResourcePolicy> getAnonymousReadPolicies(Context context, DSpaceObject dso) throws SQLException {
        List<ResourcePolicy> readPolicies = this.resourcePolicyService.find(context, dso, 0);
        List<ResourcePolicy> filteredPolicies = readPolicies.stream().filter(p -> p.getGroup() != null && StringUtils.equals((CharSequence)p.getGroup().getName(), (CharSequence)"Anonymous")).collect(Collectors.toList());
        return filteredPolicies;
    }

    private List<ResourcePolicy> getCurrentUserReadPolicies(Context context, DSpaceObject dso) throws SQLException {
        boolean canRead = this.authorizeService.authorizeActionBoolean(context, dso, 0);
        if (canRead) {
            return null;
        }
        List<ResourcePolicy> policies = this.resourcePolicyService.find(context, dso, 0);
        EPerson currentUser = context.getCurrentUser();
        ArrayList<ResourcePolicy> readPolicies = new ArrayList<ResourcePolicy>();
        for (ResourcePolicy policy : policies) {
            EPerson eperson = policy.getEPerson();
            if (eperson != null && currentUser != null && eperson.getID() == currentUser.getID()) {
                readPolicies.add(policy);
                continue;
            }
            Group group = policy.getGroup();
            if (group == null || !this.groupService.isMember(context, currentUser, group)) continue;
            readPolicies.add(policy);
        }
        return readPolicies;
    }

    private List<ResourcePolicy> getReadPolicies(Context context, DSpaceObject dso, String type) throws SQLException {
        if (StringUtils.equalsIgnoreCase((CharSequence)type, (CharSequence)STATUS_FOR_CURRENT_USER)) {
            return this.getCurrentUserReadPolicies(context, dso);
        }
        return this.getAnonymousReadPolicies(context, dso);
    }

    private LocalDate findAvailabilityDate(List<ResourcePolicy> readPolicies, LocalDate threshold) {
        if (readPolicies == null) {
            return null;
        }
        if (readPolicies.size() == 0) {
            return threshold;
        }
        LocalDate availabilityDate = null;
        LocalDate currentDate = LocalDate.now();
        boolean takeMostRecentDate = true;
        for (ResourcePolicy policy : readPolicies) {
            boolean isValid = this.resourcePolicyService.isDateValid(policy);
            if (isValid) {
                return null;
            }
            LocalDate startDate = policy.getStartDate();
            if (startDate == null || startDate.isBefore(currentDate)) continue;
            if (!startDate.isBefore(threshold)) {
                takeMostRecentDate = false;
            }
            if (availabilityDate == null) {
                availabilityDate = startDate;
                continue;
            }
            if (takeMostRecentDate) {
                availabilityDate = startDate.isBefore(availabilityDate) ? startDate : availabilityDate;
                continue;
            }
            availabilityDate = startDate.isAfter(availabilityDate) ? startDate : availabilityDate;
        }
        return availabilityDate;
    }

    private String getAccessStatusFromAvailabilityDate(LocalDate availabilityDate, LocalDate threshold) {
        if (availabilityDate == null) {
            return OPEN_ACCESS;
        }
        if (!availabilityDate.isBefore(threshold)) {
            return RESTRICTED;
        }
        return EMBARGO;
    }
}

