/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.statistics;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.dspace.core.Context;
import org.dspace.core.LogHelper;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.statistics.factory.StatisticsServiceFactory;
import org.dspace.statistics.service.SolrLoggerService;

public class AnonymizeStatistics {
    private static final Logger log = LogManager.getLogger();
    private static final Context context = new Context();
    private static final String action = "anonymize_statistics";
    private static final String HELP_OPTION = "h";
    private static final String SLEEP_OPTION = "s";
    private static final String BATCH_SIZE_OPTION = "b";
    private static final String THREADS_OPTION = "t";
    private static int sleep;
    private static final SolrLoggerService solrLoggerService;
    private static final ConfigurationService configurationService;
    private static int batchSize;
    private static int threads;
    private static final Object DNS_MASK;
    private static final String TIME_LIMIT;

    private AnonymizeStatistics() {
    }

    public static void main(String ... args) throws ParseException {
        AnonymizeStatistics.parseCommandLineOptions(AnonymizeStatistics.createCommandLineOptions(), args);
        AnonymizeStatistics.anonymizeStatistics();
    }

    private static Options createCommandLineOptions() {
        Options options = new Options();
        options.addOption(Option.builder((String)HELP_OPTION).longOpt("help").desc("Print the usage of the script").hasArg(false).build());
        options.addOption(Option.builder((String)SLEEP_OPTION).longOpt("sleep").desc("Sleep a certain time given in milliseconds between each solr request").hasArg(true).build());
        options.addOption(Option.builder((String)BATCH_SIZE_OPTION).longOpt("batch").desc("The amount of Solr records to be processed per batch (defaults to 100)").hasArg(true).build());
        options.addOption(Option.builder((String)THREADS_OPTION).longOpt("threads").desc("The amount of threads used by the script (defaults to 2").hasArg(true).build());
        return options;
    }

    private static void parseCommandLineOptions(Options options, String ... args) throws ParseException {
        CommandLine commandLine = new DefaultParser().parse(options, args);
        if (commandLine.hasOption(HELP_OPTION)) {
            AnonymizeStatistics.printHelp(options);
            System.exit(-1);
        }
        if (commandLine.hasOption(SLEEP_OPTION)) {
            sleep = Integer.parseInt(commandLine.getOptionValue(SLEEP_OPTION));
        }
        if (commandLine.hasOption(BATCH_SIZE_OPTION)) {
            batchSize = Integer.parseInt(commandLine.getOptionValue(BATCH_SIZE_OPTION));
        }
        if (commandLine.hasOption(THREADS_OPTION)) {
            threads = Integer.parseInt(commandLine.getOptionValue(THREADS_OPTION));
        }
    }

    private static void printHelp(Options options) {
        new HelpFormatter().printHelp("dsrun " + AnonymizeStatistics.class.getCanonicalName(), options);
    }

    private static void printInfo(String info) {
        System.out.println(info);
        log.info(LogHelper.getHeader(context, action, info));
    }

    private static void printWarning(String warning) {
        System.out.println(warning);
        log.warn(LogHelper.getHeader(context, action, warning));
    }

    private static void printError(Exception error) {
        error.printStackTrace();
        log.error(LogHelper.getHeader(context, action, error.getMessage()), (Throwable)error);
    }

    private static void anonymizeStatistics() {
        try {
            QueryResponse documents;
            long updated = 0L;
            long total = AnonymizeStatistics.getDocuments().getResults().getNumFound();
            AnonymizeStatistics.printInfo(total + " documents to update");
            ExecutorService executorService = Executors.newFixedThreadPool(threads);
            do {
                documents = AnonymizeStatistics.getDocuments();
                ArrayList<DoProcessing> callables = new ArrayList<DoProcessing>();
                for (SolrDocument document : documents.getResults()) {
                    callables.add(new DoProcessing(document, ++updated));
                }
                executorService.invokeAll(callables);
                solrLoggerService.commit();
                AnonymizeStatistics.printInfo("processed " + updated + " records");
            } while (documents.getResults().getNumFound() > 0L);
            AnonymizeStatistics.printInfo(updated + " documents updated");
            if (updated == total) {
                AnonymizeStatistics.printInfo("all relevant documents were updated");
            } else {
                AnonymizeStatistics.printWarning("not all relevant documents were updated, check the DSpace logs for more details");
            }
        }
        catch (Exception e) {
            AnonymizeStatistics.printError(e);
        }
    }

    private static QueryResponse getDocuments() throws SolrServerException, IOException {
        if (sleep > 0) {
            try {
                AnonymizeStatistics.printInfo("sleep " + sleep + "ms");
                Thread.sleep(sleep);
            }
            catch (InterruptedException e) {
                AnonymizeStatistics.printError(e);
                Thread.currentThread().interrupt();
            }
        }
        return solrLoggerService.query("ip:*", "time:[* TO " + TIME_LIMIT + "] AND -dns:" + DNS_MASK, null, batchSize, -1, null, null, null, null, null, false, -1, false);
    }

    static {
        solrLoggerService = StatisticsServiceFactory.getInstance().getSolrLoggerService();
        configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
        batchSize = 100;
        threads = 2;
        DNS_MASK = configurationService.getProperty("anonymize_statistics.dns_mask", "anonymized");
        Calendar calendar = Calendar.getInstance();
        calendar.add(6, -configurationService.getIntProperty("anonymize_statistics.time_threshold", 90));
        TIME_LIMIT = DateFormatUtils.format((Calendar)calendar, (String)"yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    }

    public static class DoProcessing
    implements Callable<Boolean> {
        private final SolrDocument document;
        private final long updated;

        public DoProcessing(SolrDocument document, long updated) {
            this.document = document;
            this.updated = updated;
        }

        @Override
        public Boolean call() {
            try {
                solrLoggerService.update("uid:" + this.document.getFieldValue("uid"), "replace", Arrays.asList("ip", "dns"), Arrays.asList(Collections.singletonList(solrLoggerService.anonymizeIp(this.document.getFieldValue("ip").toString())), Collections.singletonList(DNS_MASK)), false);
                AnonymizeStatistics.printInfo(this.updated + ": updated document with uid " + this.document.getFieldValue("uid") + " " + new Date());
                return true;
            }
            catch (Exception e) {
                AnonymizeStatistics.printError(e);
                return false;
            }
        }
    }
}

