/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.qaevent.service.impl;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.client.solrj.response.FacetField;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.SolrParams;
import org.dspace.content.Item;
import org.dspace.content.QAEvent;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.core.Email;
import org.dspace.core.I18nUtil;
import org.dspace.eperson.EPerson;
import org.dspace.handle.service.HandleService;
import org.dspace.qaevent.AutomaticProcessingAction;
import org.dspace.qaevent.QAEventAutomaticProcessingEvaluation;
import org.dspace.qaevent.QASource;
import org.dspace.qaevent.QATopic;
import org.dspace.qaevent.dao.impl.QAEventsDAOImpl;
import org.dspace.qaevent.service.QAEventActionService;
import org.dspace.qaevent.service.QAEventSecurityService;
import org.dspace.qaevent.service.QAEventService;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class QAEventServiceImpl
implements QAEventService {
    private static final Logger log = LogManager.getLogger();
    public static final String QAEVENTS_SOURCES = "qaevents.sources";
    @Autowired(required=true)
    protected ConfigurationService configurationService;
    @Autowired(required=true)
    protected QAEventSecurityService qaSecurityService;
    @Autowired(required=true)
    protected ItemService itemService;
    @Autowired
    private HandleService handleService;
    @Autowired
    private QAEventsDAOImpl qaEventsDao;
    @Autowired(required=false)
    @Qualifier(value="qaAutomaticProcessingMap")
    private Map<String, QAEventAutomaticProcessingEvaluation> qaAutomaticProcessingMap;
    @Autowired
    private QAEventActionService qaEventActionService;
    private ObjectMapper jsonMapper = new JsonMapper();
    protected SolrClient solr = null;
    public static final String SOURCE = "source";
    public static final String ORIGINAL_ID = "original_id";
    public static final String TITLE = "title";
    public static final String TOPIC = "topic";
    public static final String TRUST = "trust";
    public static final String MESSAGE = "message";
    public static final String EVENT_ID = "event_id";
    public static final String RESOURCE_UUID = "resource_uuid";
    public static final String LAST_UPDATE = "last_update";
    public static final String RELATED_UUID = "related_uuid";

    public QAEventServiceImpl() {
        this.jsonMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    protected SolrClient getSolr() {
        if (this.solr == null) {
            String solrService = DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("qaevents.solr.server", "http://localhost:8983/solr/qaevent");
            this.solr = new HttpSolrClient.Builder(solrService).build();
        }
        return this.solr;
    }

    @Override
    public long countTopics() {
        QueryResponse response;
        SolrQuery solrQuery = new SolrQuery();
        solrQuery.setRows(Integer.valueOf(0));
        solrQuery.setQuery("*:*");
        solrQuery.setFacet(true);
        solrQuery.setFacetMinCount(1);
        solrQuery.addFacetField(new String[]{TOPIC});
        try {
            response = this.getSolr().query((SolrParams)solrQuery);
        }
        catch (IOException | SolrServerException e) {
            throw new RuntimeException(e);
        }
        return response.getFacetField(TOPIC).getValueCount();
    }

    @Override
    public long countTopicsBySource(Context context, String sourceName) {
        QueryResponse response;
        EPerson currentUser = context.getCurrentUser();
        if (this.isNotSupportedSource(sourceName) || !this.qaSecurityService.canSeeSource(context, currentUser, sourceName)) {
            return 0L;
        }
        SolrQuery solrQuery = new SolrQuery();
        solrQuery.setRows(Integer.valueOf(0));
        Optional<String> securityQuery = this.qaSecurityService.generateQAEventFilterQuery(context, currentUser, sourceName);
        solrQuery.setQuery(securityQuery.orElse("*:*"));
        solrQuery.setFacet(true);
        solrQuery.setFacetMinCount(1);
        solrQuery.addFacetField(new String[]{TOPIC});
        solrQuery.addFilterQuery(new String[]{"source:\"" + sourceName + "\""});
        try {
            response = this.getSolr().query((SolrParams)solrQuery);
        }
        catch (IOException | SolrServerException e) {
            throw new RuntimeException(e);
        }
        return response.getFacetField(TOPIC).getValueCount();
    }

    @Override
    public QATopic findTopicBySourceAndNameAndTarget(Context context, String sourceName, String topicName, UUID target) {
        if (this.isNotSupportedSource(sourceName) || !this.qaSecurityService.canSeeSource(context, context.getCurrentUser(), sourceName)) {
            return null;
        }
        SolrQuery solrQuery = new SolrQuery();
        solrQuery.setRows(Integer.valueOf(0));
        Optional<String> securityQuery = this.qaSecurityService.generateQAEventFilterQuery(context, context.getCurrentUser(), sourceName);
        solrQuery.setQuery(securityQuery.orElse("*:*"));
        solrQuery.addFilterQuery(new String[]{"source:\"" + sourceName + "\""});
        solrQuery.addFilterQuery(new String[]{"topic:\"" + topicName + "\""});
        if (target != null) {
            solrQuery.addFilterQuery(new String[]{"resource_uuid:\"" + target.toString() + "\""});
        }
        solrQuery.setFacet(true);
        solrQuery.setFacetMinCount(1);
        solrQuery.addFacetField(new String[]{TOPIC});
        try {
            QueryResponse response = this.getSolr().query((SolrParams)solrQuery);
            FacetField facetField = response.getFacetField(TOPIC);
            for (FacetField.Count c : facetField.getValues()) {
                if (!c.getName().equals(topicName)) continue;
                QATopic topic = new QATopic();
                topic.setSource(sourceName);
                topic.setKey(c.getName());
                topic.setTotalEvents(c.getCount());
                topic.setLastEvent(new Date());
                return topic;
            }
        }
        catch (IOException | SolrServerException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    @Override
    public void deleteEventByEventId(String id) {
        try {
            this.getSolr().deleteById(id);
            this.getSolr().commit();
        }
        catch (IOException | SolrServerException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void deleteEventsByTargetId(UUID targetId) {
        try {
            this.getSolr().deleteByQuery("resource_uuid:" + targetId.toString());
            this.getSolr().commit();
        }
        catch (IOException | SolrServerException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public QATopic findTopicByTopicId(String topicId) {
        SolrQuery solrQuery = new SolrQuery();
        solrQuery.setRows(Integer.valueOf(0));
        solrQuery.setQuery("topic:" + topicId.replaceAll("!", "/"));
        solrQuery.setFacet(true);
        solrQuery.setFacetMinCount(1);
        solrQuery.addFacetField(new String[]{TOPIC});
        try {
            QueryResponse response = this.getSolr().query((SolrParams)solrQuery);
            FacetField facetField = response.getFacetField(TOPIC);
            for (FacetField.Count c : facetField.getValues()) {
                if (!c.getName().equals(topicId.replace("!", "/"))) continue;
                QATopic topic = new QATopic();
                topic.setKey(c.getName());
                topic.setTotalEvents(c.getCount());
                topic.setLastEvent(new Date());
                return topic;
            }
        }
        catch (IOException | SolrServerException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    @Override
    public List<QATopic> findAllTopics(Context context, long offset, long count, String orderField, boolean ascending) {
        return this.findAllTopicsBySource(context, null, offset, count, orderField, ascending);
    }

    @Override
    public List<QATopic> findAllTopicsBySource(Context context, String source, long offset, long count, String orderField, boolean ascending) {
        return this.findAllTopicsBySourceAndTarget(context, source, null, offset, count, orderField, ascending);
    }

    @Override
    public List<QATopic> findAllTopicsBySourceAndTarget(Context context, String source, UUID target, long offset, long pageSize, String orderField, boolean ascending) {
        if (this.isNotSupportedSource(source) || !this.qaSecurityService.canSeeSource(context, context.getCurrentUser(), source)) {
            return List.of();
        }
        SolrQuery solrQuery = new SolrQuery();
        solrQuery.setRows(Integer.valueOf(0));
        if (orderField != null) {
            solrQuery.setSort(orderField, ascending ? SolrQuery.ORDER.asc : SolrQuery.ORDER.desc);
            solrQuery.setFacetSort("index");
        }
        Optional<String> securityQuery = this.qaSecurityService.generateQAEventFilterQuery(context, context.getCurrentUser(), source);
        solrQuery.setQuery(securityQuery.orElse("*:*"));
        solrQuery.setFacet(true);
        solrQuery.setFacetMinCount(1);
        solrQuery.setFacetLimit((int)(offset + pageSize));
        solrQuery.addFacetField(new String[]{TOPIC});
        solrQuery.addFilterQuery(new String[]{"source:\"" + source + "\""});
        if (target != null) {
            solrQuery.addFilterQuery(new String[]{"resource_uuid:" + target.toString()});
        }
        ArrayList<QATopic> topics = new ArrayList<QATopic>();
        try {
            QueryResponse response = this.getSolr().query((SolrParams)solrQuery);
            FacetField facetField = response.getFacetField(TOPIC);
            int idx = 0;
            for (FacetField.Count c : facetField.getValues()) {
                if ((long)idx < offset) {
                    ++idx;
                    continue;
                }
                QATopic topic = new QATopic();
                topic.setSource(source);
                topic.setKey(c.getName());
                topic.setFocus(target);
                topic.setTotalEvents(c.getCount());
                topic.setLastEvent(new Date());
                topics.add(topic);
                ++idx;
            }
        }
        catch (IOException | SolrServerException e) {
            throw new RuntimeException(e);
        }
        return topics;
    }

    @Override
    public void store(Context context, QAEvent dto) {
        if (this.isNotSupportedSource(dto.getSource())) {
            throw new IllegalArgumentException("The source of the given event is not supported: " + dto.getSource());
        }
        if (StringUtils.isBlank((CharSequence)dto.getTopic())) {
            throw new IllegalArgumentException("A topic is mandatory for an event");
        }
        String checksum = dto.getEventId();
        try {
            if (!this.qaEventsDao.isEventStored(context, checksum)) {
                SolrInputDocument doc = this.createSolrDocument(context, dto, checksum);
                UpdateRequest updateRequest = new UpdateRequest();
                updateRequest.add(doc);
                updateRequest.process(this.getSolr());
                this.getSolr().commit();
                this.performAutomaticProcessingIfNeeded(context, dto);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void performAutomaticProcessingIfNeeded(Context context, QAEvent qaEvent) {
        if (this.qaAutomaticProcessingMap == null) {
            return;
        }
        QAEventAutomaticProcessingEvaluation evaluation = this.qaAutomaticProcessingMap.get(qaEvent.getSource());
        if (evaluation == null) {
            return;
        }
        AutomaticProcessingAction action = evaluation.evaluateAutomaticProcessing(context, qaEvent);
        if (action == null) {
            return;
        }
        switch (action) {
            case REJECT: {
                this.qaEventActionService.reject(context, qaEvent);
                break;
            }
            case IGNORE: {
                this.qaEventActionService.discard(context, qaEvent);
                break;
            }
            case ACCEPT: {
                this.qaEventActionService.accept(context, qaEvent);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown automatic action requested " + action);
            }
        }
    }

    public void sentEmailToAdminAboutNewRequest(QAEvent qaEvent) {
        try {
            String uiUrl = this.configurationService.getProperty("dspace.ui.url");
            Email email = Email.getEmail(I18nUtil.getEmailFilename(Locale.getDefault(), "qaevent_admin_notification"));
            email.addRecipient(this.configurationService.getProperty("qaevents.mail.notification"));
            email.addArgument(qaEvent.getTopic());
            email.addArgument(uiUrl + "/items/" + qaEvent.getTarget());
            email.addArgument(this.parsJson(qaEvent.getMessage()));
            email.send();
        }
        catch (Exception e) {
            log.warn("Error during sending email of Withdrawn/Reinstate request for item with uuid:  {}", (Object)qaEvent.getTarget(), (Object)e);
        }
    }

    private String parsJson(String jsonString) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            JsonNode jsonNode = objectMapper.readTree(jsonString);
            return jsonNode.get("reason").asText();
        }
        catch (Exception e) {
            log.warn("Unable to parse the JSON:  {}", (Object)jsonString);
            return jsonString;
        }
    }

    @Override
    public QAEvent findEventByEventId(String eventId) {
        SolrQuery solrQuery = new SolrQuery("*:*");
        solrQuery.addFilterQuery(new String[]{"event_id:\"" + eventId + "\""});
        try {
            SolrDocumentList list;
            QueryResponse response = this.getSolr().query((SolrParams)solrQuery);
            if (response != null && (list = response.getResults()) != null && list.size() == 1) {
                SolrDocument doc = (SolrDocument)list.get(0);
                return this.getQAEventFromSOLR(doc);
            }
        }
        catch (IOException | SolrServerException e) {
            throw new RuntimeException("Exception querying Solr", e);
        }
        return null;
    }

    @Override
    public List<QAEvent> findEventsByTopic(Context context, String sourceName, String topic, long offset, int pageSize, String orderField, boolean ascending) {
        EPerson currentUser = context.getCurrentUser();
        if (this.isNotSupportedSource(sourceName) || !this.qaSecurityService.canSeeSource(context, currentUser, sourceName)) {
            return List.of();
        }
        SolrQuery solrQuery = new SolrQuery();
        solrQuery.setStart(Integer.valueOf(Long.valueOf(offset).intValue()));
        if (pageSize != -1) {
            solrQuery.setRows(Integer.valueOf(pageSize));
        }
        solrQuery.setSort(orderField, ascending ? SolrQuery.ORDER.asc : SolrQuery.ORDER.desc);
        Optional<String> securityQuery = this.qaSecurityService.generateQAEventFilterQuery(context, currentUser, sourceName);
        solrQuery.setQuery(securityQuery.orElse("*:*"));
        solrQuery.setQuery("topic:" + topic.replaceAll("!", "/"));
        solrQuery.addFilterQuery(new String[]{"source:\"" + sourceName + "\""});
        try {
            QueryResponse response = this.getSolr().query((SolrParams)solrQuery);
            if (response != null) {
                SolrDocumentList solrDocuments = response.getResults();
                ArrayList<QAEvent> responseItem = new ArrayList<QAEvent>();
                for (SolrDocument doc : solrDocuments) {
                    QAEvent item = this.getQAEventFromSOLR(doc);
                    responseItem.add(item);
                }
                return responseItem;
            }
        }
        catch (IOException | SolrServerException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return List.of();
    }

    @Override
    public long countEventsByTopic(Context context, String sourceName, String topic) {
        EPerson currentUser = context.getCurrentUser();
        if (this.isNotSupportedSource(sourceName) || !this.qaSecurityService.canSeeSource(context, currentUser, sourceName)) {
            return 0L;
        }
        Optional<String> securityQuery = this.qaSecurityService.generateQAEventFilterQuery(context, currentUser, sourceName);
        SolrQuery solrQuery = new SolrQuery();
        solrQuery.setRows(Integer.valueOf(0));
        solrQuery.setQuery(securityQuery.orElse("*:*"));
        solrQuery.addFilterQuery(new String[]{"source:\"" + sourceName + "\""});
        solrQuery.setQuery("topic:" + topic.replaceAll("!", "/"));
        try {
            return this.getSolr().query((SolrParams)solrQuery).getResults().getNumFound();
        }
        catch (IOException | SolrServerException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public QASource findSource(Context context, String sourceName) {
        String[] split = sourceName.split(":");
        return this.findSource(context, split[0], split.length == 2 ? UUID.fromString(split[1]) : null);
    }

    @Override
    public QASource findSource(Context context, String sourceName, UUID target) {
        EPerson currentUser = context.getCurrentUser();
        if (this.isNotSupportedSource(sourceName) || !this.qaSecurityService.canSeeSource(context, currentUser, sourceName)) {
            return null;
        }
        Optional<String> securityQuery = this.qaSecurityService.generateQAEventFilterQuery(context, currentUser, sourceName);
        SolrQuery solrQuery = new SolrQuery();
        solrQuery.setQuery(securityQuery.orElse("*:*"));
        solrQuery.setRows(Integer.valueOf(0));
        solrQuery.addFilterQuery(new String[]{"source:\"" + sourceName + "\""});
        if (target != null) {
            solrQuery.addFilterQuery(new String[]{"resource_uuid:" + target.toString()});
        }
        solrQuery.setFacet(true);
        solrQuery.setFacetMinCount(1);
        solrQuery.addFacetField(new String[]{SOURCE});
        try {
            QueryResponse response = this.getSolr().query((SolrParams)solrQuery);
            FacetField facetField = response.getFacetField(SOURCE);
            for (FacetField.Count c : facetField.getValues()) {
                if (!c.getName().equalsIgnoreCase(sourceName)) continue;
                QASource source = new QASource();
                source.setName(c.getName());
                source.setFocus(target);
                source.setTotalEvents(c.getCount());
                source.setLastEvent(new Date());
                return source;
            }
        }
        catch (IOException | SolrServerException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        QASource source = new QASource();
        source.setName(sourceName);
        source.setTotalEvents(0L);
        return source;
    }

    @Override
    public List<QASource> findAllSources(Context context, long offset, int pageSize) {
        return Arrays.stream(this.getSupportedSources()).map(sourceName -> this.findSource(context, (String)sourceName)).filter(Objects::nonNull).sorted(Comparator.comparing(QASource::getTotalEvents).reversed()).skip(offset).limit(pageSize).collect(Collectors.toList());
    }

    @Override
    public long countSources(Context context) {
        return Arrays.stream(this.getSupportedSources()).map(sourceName -> this.findSource(context, (String)sourceName)).filter(Objects::nonNull).filter(source -> source.getTotalEvents() > 0L).count();
    }

    @Override
    public long countSourcesByTarget(Context context, UUID target) {
        return Arrays.stream(this.getSupportedSources()).map(sourceName -> this.findSource(context, (String)sourceName, target)).filter(Objects::nonNull).filter(source -> source.getTotalEvents() > 0L).count();
    }

    @Override
    public boolean isRelatedItemSupported(QAEvent qaevent) {
        return qaevent.getSource().equals("openaire") && StringUtils.endsWith((CharSequence)qaevent.getTopic(), (CharSequence)"/PROJECT");
    }

    private SolrInputDocument createSolrDocument(Context context, QAEvent dto, String checksum) throws Exception {
        SolrInputDocument doc = new SolrInputDocument(new String[0]);
        doc.addField(SOURCE, (Object)dto.getSource());
        doc.addField(EVENT_ID, (Object)checksum);
        doc.addField(ORIGINAL_ID, (Object)dto.getOriginalId());
        doc.addField(TITLE, (Object)dto.getTitle());
        doc.addField(TOPIC, (Object)dto.getTopic());
        doc.addField(TRUST, (Object)dto.getTrust());
        doc.addField(MESSAGE, (Object)dto.getMessage());
        doc.addField(LAST_UPDATE, (Object)new Date());
        String resourceUUID = this.getResourceUUID(context, dto.getOriginalId());
        if (resourceUUID == null) {
            resourceUUID = dto.getTarget();
        }
        doc.addField(RESOURCE_UUID, (Object)resourceUUID);
        doc.addField(RELATED_UUID, (Object)dto.getRelated());
        return doc;
    }

    private String getResourceUUID(Context context, String originalId) throws Exception {
        String id = this.getHandleFromOriginalId(originalId);
        if (id != null) {
            Item item = (Item)this.handleService.resolveToObject(context, id);
            if (item != null) {
                String itemUuid = item.getID().toString();
                context.uncacheEntity(item);
                return itemUuid;
            }
            return null;
        }
        throw new IllegalArgumentException("Malformed originalId " + originalId);
    }

    private String getHandleFromOriginalId(String originalId) {
        int startPosition = originalId.lastIndexOf(58);
        if (startPosition != -1) {
            return originalId.substring(startPosition + 1, originalId.length());
        }
        return originalId;
    }

    private QAEvent getQAEventFromSOLR(SolrDocument doc) {
        QAEvent item = new QAEvent();
        item.setSource((String)doc.get((Object)SOURCE));
        item.setEventId((String)doc.get((Object)EVENT_ID));
        item.setLastUpdate((Date)doc.get((Object)LAST_UPDATE));
        item.setMessage((String)doc.get((Object)MESSAGE));
        item.setOriginalId((String)doc.get((Object)ORIGINAL_ID));
        item.setTarget((String)doc.get((Object)RESOURCE_UUID));
        item.setTitle((String)doc.get((Object)TITLE));
        item.setTopic((String)doc.get((Object)TOPIC));
        item.setTrust((Double)doc.get((Object)TRUST));
        item.setRelated((String)doc.get((Object)RELATED_UUID));
        return item;
    }

    @Override
    public boolean qaEventsInSource(Context context, EPerson user, String eventId, String source) {
        SolrQuery solrQuery = new SolrQuery();
        Optional<String> securityQuery = this.qaSecurityService.generateQAEventFilterQuery(context, user, source);
        solrQuery.setQuery(securityQuery.orElse("*:*"));
        solrQuery.addFilterQuery(new String[]{"event_id:\"" + eventId + "\""});
        try {
            QueryResponse response = this.getSolr().query((SolrParams)solrQuery);
            if (response != null) {
                return response.getResults().getNumFound() == 1L;
            }
        }
        catch (IOException | SolrServerException e) {
            throw new RuntimeException("Exception querying Solr", e);
        }
        return false;
    }

    @Override
    public long countEventsByTopicAndTarget(Context context, String sourceName, String topic, UUID target) {
        EPerson currentUser = context.getCurrentUser();
        if (this.isNotSupportedSource(sourceName) || !this.qaSecurityService.canSeeSource(context, currentUser, sourceName)) {
            return 0L;
        }
        SolrQuery solrQuery = new SolrQuery();
        solrQuery.setRows(Integer.valueOf(0));
        Optional<String> securityQuery = this.qaSecurityService.generateQAEventFilterQuery(context, currentUser, sourceName);
        solrQuery.setQuery(securityQuery.orElse("*:*"));
        if (target != null) {
            solrQuery.addFilterQuery(new String[]{"resource_uuid:\"" + target.toString() + "\""});
        }
        solrQuery.addFilterQuery(new String[]{"source:\"" + sourceName + "\""});
        solrQuery.addFilterQuery(new String[]{"topic:\"" + topic + "\""});
        QueryResponse response = null;
        try {
            response = this.getSolr().query((SolrParams)solrQuery);
            return response.getResults().getNumFound();
        }
        catch (IOException | SolrServerException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<QAEvent> findEventsByTopicAndTarget(Context context, String source, String topic, UUID target, long offset, int pageSize) {
        EPerson currentUser = context.getCurrentUser();
        if (this.isNotSupportedSource(source) || !this.qaSecurityService.canSeeSource(context, currentUser, source)) {
            return List.of();
        }
        SolrQuery solrQuery = new SolrQuery();
        solrQuery.setStart(Integer.valueOf(Long.valueOf(offset).intValue()));
        solrQuery.setRows(Integer.valueOf(pageSize));
        solrQuery.setSort(TRUST, SolrQuery.ORDER.desc);
        Optional<String> securityQuery = this.qaSecurityService.generateQAEventFilterQuery(context, currentUser, source);
        solrQuery.setQuery(securityQuery.orElse("*:*"));
        if (target != null) {
            solrQuery.addFilterQuery(new String[]{"resource_uuid:\"" + target.toString() + "\""});
        }
        solrQuery.addFilterQuery(new String[]{"source:\"" + source + "\""});
        solrQuery.addFilterQuery(new String[]{"topic:\"" + topic + "\""});
        try {
            QueryResponse response = this.getSolr().query((SolrParams)solrQuery);
            if (response != null) {
                SolrDocumentList list = response.getResults();
                ArrayList<QAEvent> responseItem = new ArrayList<QAEvent>();
                for (SolrDocument doc : list) {
                    QAEvent item = this.getQAEventFromSOLR(doc);
                    responseItem.add(item);
                }
                return responseItem;
            }
        }
        catch (IOException | SolrServerException e) {
            throw new RuntimeException(e);
        }
        return List.of();
    }

    private boolean isNotSupportedSource(String source) {
        return !ArrayUtils.contains((Object[])this.getSupportedSources(), (Object)source);
    }

    private String[] getSupportedSources() {
        return this.configurationService.getArrayProperty(QAEVENTS_SOURCES, new String[]{"openaire", "coar-notify"});
    }

    @Override
    public long countTopicsBySourceAndTarget(Context context, String source, UUID target) {
        EPerson currentUser = context.getCurrentUser();
        if (this.isNotSupportedSource(source) || !this.qaSecurityService.canSeeSource(context, currentUser, source)) {
            return 0L;
        }
        SolrQuery solrQuery = new SolrQuery();
        solrQuery.setRows(Integer.valueOf(0));
        Optional<String> securityQuery = this.qaSecurityService.generateQAEventFilterQuery(context, currentUser, source);
        solrQuery.setQuery(securityQuery.orElse("*:*"));
        solrQuery.setFacet(true);
        solrQuery.setFacetMinCount(1);
        solrQuery.addFacetField(new String[]{TOPIC});
        solrQuery.addFilterQuery(new String[]{"source:\"" + source + "\""});
        if (target != null) {
            solrQuery.addFilterQuery(new String[]{"resource_uuid:\"" + target.toString() + "\""});
        }
        try {
            QueryResponse response = this.getSolr().query((SolrParams)solrQuery);
            return response.getFacetField(TOPIC).getValueCount();
        }
        catch (IOException | SolrServerException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<QASource> findAllSourcesByTarget(Context context, UUID target, long offset, int pageSize) {
        return Arrays.stream(this.getSupportedSources()).map(sourceName -> this.findSource(context, (String)sourceName, target)).filter(Objects::nonNull).sorted(Comparator.comparing(QASource::getTotalEvents).reversed()).filter(source -> source.getTotalEvents() > 0L).skip(offset).limit(pageSize).collect(Collectors.toList());
    }
}

