/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.importer.external.metadatamapping.contributor;

import jakarta.annotation.Resource;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.dspace.importer.external.metadatamapping.MetadataFieldConfig;
import org.dspace.importer.external.metadatamapping.MetadataFieldMapping;
import org.dspace.importer.external.metadatamapping.MetadatumDTO;
import org.dspace.importer.external.metadatamapping.contributor.MetadataContributor;
import org.jaxen.JaxenException;
import org.jdom2.Attribute;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.Text;
import org.jdom2.filter.Filters;
import org.jdom2.xpath.XPathExpression;
import org.jdom2.xpath.XPathFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class EpoIdMetadataContributor
implements MetadataContributor<Element> {
    protected MetadataFieldConfig field;
    private boolean needType;
    protected MetadataFieldMapping<Element, MetadataContributor<Element>> metadataFieldMapping;
    protected Map<String, String> prefixToNamespaceMapping;
    protected String query;

    public void setNeedType(boolean needType) {
        this.needType = needType;
    }

    public Map<String, String> getPrefixToNamespaceMapping() {
        return this.prefixToNamespaceMapping;
    }

    public MetadataFieldMapping<Element, MetadataContributor<Element>> getMetadataFieldMapping() {
        return this.metadataFieldMapping;
    }

    @Override
    public void setMetadataFieldMapping(MetadataFieldMapping<Element, MetadataContributor<Element>> metadataFieldMapping) {
        this.metadataFieldMapping = metadataFieldMapping;
    }

    @Resource(name="isiFullprefixMapping")
    public void setPrefixToNamespaceMapping(Map<String, String> prefixToNamespaceMapping) {
        this.prefixToNamespaceMapping = prefixToNamespaceMapping;
    }

    public EpoIdMetadataContributor(String query, Map<String, String> prefixToNamespaceMapping, MetadataFieldConfig field) {
        this.query = query;
        this.prefixToNamespaceMapping = prefixToNamespaceMapping;
        this.field = field;
    }

    public EpoIdMetadataContributor() {
    }

    public MetadataFieldConfig getField() {
        return this.field;
    }

    @Autowired(required=true)
    public void setField(MetadataFieldConfig field) {
        this.field = field;
    }

    public String getQuery() {
        return this.query;
    }

    @Autowired(required=true)
    public void setQuery(String query) {
        this.query = query;
    }

    @Override
    public Collection<MetadatumDTO> contributeMetadata(Element element) {
        LinkedList<MetadatumDTO> values = new LinkedList<MetadatumDTO>();
        try {
            List<Namespace> namespaces = Arrays.asList(Namespace.getNamespace((String)"xlink", (String)"http://www.w3.org/1999/xlink"), Namespace.getNamespace((String)"ops", (String)"http://ops.epo.org"), Namespace.getNamespace((String)"ns", (String)"http://www.epo.org/exchange"));
            XPathExpression xpath = XPathFactory.instance().compile(this.query, Filters.element(), null, namespaces);
            List elements = xpath.evaluate((Object)element);
            for (Element el : elements) {
                EpoDocumentId document = new EpoDocumentId(el, namespaces);
                MetadatumDTO metadatum = new MetadatumDTO();
                metadatum.setElement(this.field.getElement());
                metadatum.setQualifier(this.field.getQualifier());
                metadatum.setSchema(this.field.getSchema());
                if (this.needType) {
                    metadatum.setValue(document.getIdAndType());
                } else {
                    metadatum.setValue(document.getId());
                }
                values.add(metadatum);
            }
            return values;
        }
        catch (JaxenException e) {
            System.err.println(this.query);
            throw new RuntimeException(e);
        }
    }

    public static class EpoDocumentId {
        private String documentIdType;
        private String country;
        private String docNumber;
        private String kind;
        private String date;
        private List<Namespace> namespaces;
        public static final String DOCDB = "docdb";
        public static final String EPODOC = "epodoc";
        public static final String ORIGIN = "origin";

        public EpoDocumentId(Element documentId, List<Namespace> namespaces) throws JaxenException {
            this.namespaces = namespaces;
            Element preferredId = null;
            XPathExpression xpath = XPathFactory.instance().compile("./ns:document-id[@document-id-type=\"epodoc\"]", Filters.fpassthrough(), null, namespaces);
            List nodes = xpath.evaluate((Object)documentId);
            if (CollectionUtils.isNotEmpty((Collection)nodes)) {
                preferredId = (Element)nodes.get(0);
            }
            if (Objects.isNull(preferredId)) {
                preferredId = documentId;
            }
            this.documentIdType = this.buildDocumentIdType(preferredId);
            this.country = this.buildCountry(preferredId);
            this.docNumber = this.buildDocNumber(preferredId);
            this.kind = this.buildKind(preferredId);
            this.date = this.buildDate(preferredId);
        }

        private String buildDocumentIdType(Element documentId) throws JaxenException {
            return this.getElement(documentId, "./@document-id-type");
        }

        private String buildCountry(Element documentId) throws JaxenException {
            return this.getElement(documentId, "./ns:country");
        }

        private String buildDocNumber(Element documentId) throws JaxenException {
            return this.getElement(documentId, "./ns:doc-number");
        }

        private String buildKind(Element documentId) throws JaxenException {
            return this.getElement(documentId, "./ns:kind");
        }

        private String buildDate(Element documentId) throws JaxenException {
            return this.getElement(documentId, "./ns:date");
        }

        public String getDocumentIdType() {
            return this.documentIdType;
        }

        public String getId() {
            if (DOCDB.equals(this.documentIdType)) {
                return this.country + "." + this.docNumber + "." + this.kind;
            }
            if (EPODOC.equals(this.documentIdType)) {
                return this.docNumber + (this.kind != null ? this.kind : "");
            }
            return "";
        }

        public String getIdAndType() {
            if (EPODOC.equals(this.documentIdType)) {
                return this.documentIdType + ":" + this.docNumber + (this.kind != null ? this.kind : "");
            }
            if (DOCDB.equals(this.documentIdType)) {
                return this.documentIdType + ":" + this.country + "." + this.docNumber + "." + this.kind;
            }
            return "";
        }

        private String getElement(Element documentId, String path) throws JaxenException {
            if (Objects.isNull(documentId)) {
                return "";
            }
            XPathExpression xpath = XPathFactory.instance().compile(path, Filters.fpassthrough(), null, this.namespaces);
            List nodes = xpath.evaluate((Object)documentId);
            return CollectionUtils.isNotEmpty((Collection)nodes) ? this.getValue(nodes.get(0)) : "";
        }

        private String getValue(Object el) {
            if (el instanceof Element) {
                return ((Element)el).getText();
            }
            if (el instanceof Attribute) {
                return ((Attribute)el).getValue();
            }
            if (el instanceof String) {
                return (String)el;
            }
            if (el instanceof Text) {
                return ((Text)el).getText();
            }
            return "";
        }
    }
}

