/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.dao.impl;

import jakarta.persistence.Query;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.ListJoin;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import jakarta.persistence.criteria.SetJoin;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.dspace.content.Bitstream;
import org.dspace.content.Bitstream_;
import org.dspace.content.Bundle_;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.Item;
import org.dspace.content.Item_;
import org.dspace.content.dao.BitstreamDAO;
import org.dspace.core.AbstractHibernateDSODAO;
import org.dspace.core.Context;
import org.dspace.core.UUIDIterator;

public class BitstreamDAOImpl
extends AbstractHibernateDSODAO<Bitstream>
implements BitstreamDAO {
    protected BitstreamDAOImpl() {
    }

    @Override
    public List<Bitstream> findDeletedBitstreams(Context context, int limit, int offset) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<Bitstream> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, Bitstream.class);
        Root bitstreamRoot = criteriaQuery.from(Bitstream.class);
        criteriaQuery.select((Selection)bitstreamRoot);
        criteriaQuery.orderBy(new Order[]{criteriaBuilder.desc((Expression)bitstreamRoot.get("id"))});
        criteriaQuery.where((Expression)criteriaBuilder.equal((Expression)bitstreamRoot.get(Bitstream_.deleted), (Object)true));
        return this.list(context, criteriaQuery, false, Bitstream.class, limit, offset);
    }

    @Override
    public List<Bitstream> findDuplicateInternalIdentifier(Context context, Bitstream bitstream) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<Bitstream> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, Bitstream.class);
        Root bitstreamRoot = criteriaQuery.from(Bitstream.class);
        criteriaQuery.select((Selection)bitstreamRoot);
        criteriaQuery.where((Expression)criteriaBuilder.and((Expression)criteriaBuilder.equal((Expression)bitstreamRoot.get(Bitstream_.internalId), (Object)bitstream.getInternalId()), (Expression)criteriaBuilder.notEqual((Expression)bitstreamRoot.get(Bitstream_.id), (Object)bitstream.getID())));
        return this.list(context, criteriaQuery, false, Bitstream.class, -1, -1);
    }

    @Override
    public List<Bitstream> findBitstreamsWithNoRecentChecksum(Context context) throws SQLException {
        Query query = this.createQuery(context, "SELECT b FROM MostRecentChecksum c RIGHT JOIN Bitstream b ON c.bitstream = b WHERE c IS NULL");
        return query.getResultList();
    }

    @Override
    public Iterator<Bitstream> findByCommunity(Context context, Community community) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(UUID.class);
        Root bitstreamRoot = criteriaQuery.from(Bitstream.class);
        criteriaQuery.select((Selection)bitstreamRoot.get(Bitstream_.id));
        ListJoin joinBundle = bitstreamRoot.join(Bitstream_.bundles);
        ListJoin joinItem = joinBundle.join(Bundle_.items);
        SetJoin joinCollection = joinItem.join(Item_.collections);
        criteriaQuery.where((Expression)criteriaBuilder.isMember((Object)community, (Expression)joinCollection.get("communities")));
        Query query = this.createQuery(context, criteriaQuery);
        List uuids = query.getResultList();
        return new UUIDIterator<Bitstream>(context, uuids, Bitstream.class, this);
    }

    @Override
    public Iterator<Bitstream> findByCollection(Context context, Collection collection) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(UUID.class);
        Root bitstreamRoot = criteriaQuery.from(Bitstream.class);
        criteriaQuery.select((Selection)bitstreamRoot.get(Bitstream_.id));
        ListJoin joinBundle = bitstreamRoot.join(Bitstream_.bundles);
        ListJoin joinItem = joinBundle.join(Bundle_.items);
        criteriaQuery.where((Expression)criteriaBuilder.isMember((Object)collection, joinItem.get(Item_.collections)));
        Query query = this.createQuery(context, criteriaQuery);
        List uuids = query.getResultList();
        return new UUIDIterator<Bitstream>(context, uuids, Bitstream.class, this);
    }

    @Override
    public Iterator<Bitstream> findByItem(Context context, Item item) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(UUID.class);
        Root bitstreamRoot = criteriaQuery.from(Bitstream.class);
        criteriaQuery.select((Selection)bitstreamRoot.get(Bitstream_.id));
        ListJoin joinBundle = bitstreamRoot.join(Bitstream_.bundles);
        criteriaQuery.where((Expression)criteriaBuilder.isMember((Object)item, joinBundle.get(Bundle_.items)));
        Query query = this.createQuery(context, criteriaQuery);
        List uuids = query.getResultList();
        return new UUIDIterator<Bitstream>(context, uuids, Bitstream.class, this);
    }

    @Override
    public Iterator<Bitstream> findByStoreNumber(Context context, Integer storeNumber) throws SQLException {
        Query query = this.createQuery(context, "select b.id from Bitstream b where b.storeNumber = :storeNumber");
        query.setParameter("storeNumber", (Object)storeNumber);
        List uuids = query.getResultList();
        return new UUIDIterator<Bitstream>(context, uuids, Bitstream.class, this);
    }

    @Override
    public Long countByStoreNumber(Context context, Integer storeNumber) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(Long.class);
        Root bitstreamRoot = criteriaQuery.from(Bitstream.class);
        criteriaQuery.where((Expression)criteriaBuilder.equal((Expression)bitstreamRoot.get(Bitstream_.storeNumber), (Object)storeNumber));
        return this.countLong(context, criteriaQuery, criteriaBuilder, bitstreamRoot);
    }

    @Override
    public int countRows(Context context) throws SQLException {
        return this.count(this.createQuery(context, "SELECT count(*) from Bitstream"));
    }

    @Override
    public int countDeleted(Context context) throws SQLException {
        return this.count(this.createQuery(context, "SELECT count(*) FROM Bitstream b WHERE b.deleted=true"));
    }

    @Override
    public int countWithNoPolicy(Context context) throws SQLException {
        Query query = this.createQuery(context, "SELECT count(bit.id) from Bitstream bit where bit.deleted<>true and bit not in (select res.dSpaceObject from ResourcePolicy res where res.resourceTypeId = :typeId )");
        query.setParameter("typeId", (Object)0);
        return this.count(query);
    }

    @Override
    public List<Bitstream> getNotReferencedBitstreams(Context context) throws SQLException {
        return this.list(this.createQuery(context, "select bit from Bitstream bit where bit.deleted != true and bit.id not in (select bit2.id from Bundle bun join bun.bitstreams bit2) and bit.id not in (select com.logo.id from Community com) and bit.id not in (select col.logo.id from Collection col) and bit.id not in (select bun.primaryBitstream.id from Bundle bun)"));
    }

    @Override
    public Iterator<Bitstream> findAll(Context context, int limit, int offset) throws SQLException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        return this.findByX(context, Bitstream.class, map, true, limit, offset).iterator();
    }
}

