/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.authority;

import java.sql.SQLException;
import java.util.List;
import org.dspace.authority.AuthorityValue;
import org.dspace.authority.indexer.AuthorityIndexerInterface;
import org.dspace.authority.indexer.AuthorityIndexingService;
import org.dspace.authority.service.AuthorityService;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;

public class AuthorityServiceImpl
implements AuthorityService {
    @Autowired(required=true)
    protected AuthorityIndexingService indexingService;
    @Autowired(required=true)
    protected List<AuthorityIndexerInterface> indexers;

    protected AuthorityServiceImpl() {
    }

    @Override
    public void indexItem(Context context, Item item) throws SQLException, AuthorizeException {
        if (!this.isConfigurationValid()) {
            return;
        }
        for (AuthorityIndexerInterface indexerInterface : this.indexers) {
            List<AuthorityValue> authorityValues = indexerInterface.getAuthorityValues(context, item);
            for (AuthorityValue authorityValue : authorityValues) {
                this.indexingService.indexContent(authorityValue);
            }
        }
        this.indexingService.commit();
    }

    @Override
    public boolean isConfigurationValid() {
        if (!this.indexingService.isConfiguredProperly()) {
            return false;
        }
        for (AuthorityIndexerInterface indexerInterface : this.indexers) {
            if (indexerInterface.isConfiguredProperly()) continue;
            return false;
        }
        return true;
    }
}

