/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.core;

import com.google.common.collect.AbstractIterator;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.dspace.content.DSpaceObject;
import org.dspace.core.AbstractHibernateDSODAO;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;

public class UUIDIterator<T extends DSpaceObject>
extends AbstractIterator<T> {
    private Class<T> clazz;
    private Iterator<UUID> iterator;
    @Autowired
    private AbstractHibernateDSODAO<T> dao;
    private Context ctx;

    public UUIDIterator(Context ctx, List<UUID> uuids, Class<T> clazz, AbstractHibernateDSODAO<T> dao) throws SQLException {
        this.ctx = ctx;
        this.clazz = clazz;
        this.dao = dao;
        this.iterator = uuids.iterator();
    }

    protected T computeNext() {
        try {
            if (this.iterator.hasNext()) {
                DSpaceObject item = (DSpaceObject)this.dao.findByID(this.ctx, this.clazz, this.iterator.next());
                if (item != null) {
                    return (T)item;
                }
                return (T)this.computeNext();
            }
            return (T)((DSpaceObject)this.endOfData());
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

