/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.suggestion.openaire;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.solr.client.solrj.SolrServerException;
import org.dspace.app.suggestion.SolrSuggestionProvider;
import org.dspace.app.suggestion.Suggestion;
import org.dspace.app.suggestion.SuggestionEvidence;
import org.dspace.app.suggestion.SuggestionUtils;
import org.dspace.app.suggestion.openaire.EvidenceScorer;
import org.dspace.content.Item;
import org.dspace.content.dto.MetadataValueDTO;
import org.dspace.core.Context;
import org.dspace.external.model.ExternalDataObject;
import org.dspace.external.provider.ExternalDataProvider;
import org.dspace.services.ConfigurationService;
import org.springframework.beans.factory.annotation.Autowired;

public class PublicationLoader
extends SolrSuggestionProvider {
    private List<String> names;
    private ExternalDataProvider primaryProvider;
    private List<ExternalDataProvider> otherProviders;
    @Autowired
    private ConfigurationService configurationService;
    private List<EvidenceScorer> pipeline;

    public void setPrimaryProvider(ExternalDataProvider primaryProvider) {
        this.primaryProvider = primaryProvider;
    }

    public void setOtherProviders(List<ExternalDataProvider> otherProviders) {
        this.otherProviders = otherProviders;
    }

    public void setPipeline(List<EvidenceScorer> pipeline) {
        this.pipeline = pipeline;
    }

    public List<Suggestion> reduceAndTransform(Item researcher, List<ExternalDataObject> importRecords) {
        ArrayList<Suggestion> results = new ArrayList<Suggestion>();
        for (ExternalDataObject r : importRecords) {
            boolean skip = false;
            ArrayList<SuggestionEvidence> evidences = new ArrayList<SuggestionEvidence>();
            for (EvidenceScorer authorNameApprover : this.pipeline) {
                SuggestionEvidence evidence = authorNameApprover.computeEvidence(researcher, r);
                if (evidence != null) {
                    evidences.add(evidence);
                    continue;
                }
                skip = true;
                break;
            }
            if (skip) continue;
            Suggestion suggestion = this.translateImportRecordToSuggestion(researcher, r);
            suggestion.getEvidences().addAll(evidences);
            results.add(suggestion);
        }
        return results;
    }

    public void importAuthorRecords(Context context, Item researcher) throws SolrServerException, IOException {
        int limit;
        int offset = 0;
        int loaded = limit = 10;
        List<String> searchValues = this.searchMetadataValues(researcher);
        while (loaded > 0) {
            List<ExternalDataObject> metadata = this.getImportRecords(searchValues, researcher, offset, limit);
            if (metadata.isEmpty()) {
                loaded = 0;
                continue;
            }
            offset += limit;
            loaded = metadata.size();
            List<Suggestion> records = this.reduceAndTransform(researcher, metadata);
            for (Suggestion record : records) {
                this.solrSuggestionStorageService.addSuggestion(record, false, false);
            }
        }
        this.solrSuggestionStorageService.commit();
    }

    private Suggestion translateImportRecordToSuggestion(Item item, ExternalDataObject record) {
        String openAireId = record.getId();
        Suggestion suggestion = new Suggestion(this.getSourceName(), item, openAireId);
        suggestion.setDisplay(SuggestionUtils.getFirstEntryByMetadatum(record, "dc", "title", null));
        suggestion.getMetadata().add(new MetadataValueDTO("dc", "title", null, null, SuggestionUtils.getFirstEntryByMetadatum(record, "dc", "title", null)));
        suggestion.getMetadata().add(new MetadataValueDTO("dc", "date", "issued", null, SuggestionUtils.getFirstEntryByMetadatum(record, "dc", "date", "issued")));
        suggestion.getMetadata().add(new MetadataValueDTO("dc", "description", "abstract", null, SuggestionUtils.getFirstEntryByMetadatum(record, "dc", "description", "abstract")));
        suggestion.setExternalSourceUri(this.configurationService.getProperty("dspace.server.url") + "/api/integration/externalsources/" + this.primaryProvider.getSourceIdentifier() + "/entryValues/" + openAireId);
        for (String o : SuggestionUtils.getAllEntriesByMetadatum(record, "dc", "source", null)) {
            suggestion.getMetadata().add(new MetadataValueDTO("dc", "source", null, null, o));
        }
        for (String o : SuggestionUtils.getAllEntriesByMetadatum(record, "dc", "contributor", "author")) {
            suggestion.getMetadata().add(new MetadataValueDTO("dc", "contributor", "author", null, o));
        }
        return suggestion;
    }

    public List<String> getNames() {
        return this.names;
    }

    public void setNames(List<String> names) {
        this.names = names;
    }

    private List<ExternalDataObject> getImportRecords(List<String> searchValues, Item researcher, int offset, int limit) {
        ArrayList<ExternalDataObject> matchingRecords = new ArrayList<ExternalDataObject>();
        for (String searchValue : searchValues) {
            matchingRecords.addAll(this.primaryProvider.searchExternalDataObjects(searchValue, offset, limit));
        }
        List<ExternalDataObject> toReturn = this.removeDuplicates(matchingRecords);
        return toReturn;
    }

    private List<ExternalDataObject> removeDuplicates(List<ExternalDataObject> importRecords) {
        ArrayList<ExternalDataObject> filteredRecords = new ArrayList<ExternalDataObject>();
        for (ExternalDataObject currentRecord : importRecords) {
            if (this.isDuplicate(currentRecord, filteredRecords)) continue;
            filteredRecords.add(currentRecord);
        }
        return filteredRecords;
    }

    private boolean isDuplicate(ExternalDataObject dto, List<ExternalDataObject> importRecords) {
        String currentItemId = dto.getId();
        if (currentItemId == null) {
            return true;
        }
        for (ExternalDataObject importRecord : importRecords) {
            if (!currentItemId.equals(importRecord.getId())) continue;
            return true;
        }
        return false;
    }

    private List<String> searchMetadataValues(Item researcher) {
        ArrayList<String> authors = new ArrayList<String>();
        for (String name : this.names) {
            String value = this.itemService.getMetadata(researcher, name);
            if (value == null) continue;
            authors.add(value);
        }
        return authors;
    }

    @Override
    protected boolean isExternalDataObjectPotentiallySuggested(Context context, ExternalDataObject externalDataObject) {
        if (StringUtils.equals((CharSequence)externalDataObject.getSource(), (CharSequence)this.primaryProvider.getSourceIdentifier())) {
            return true;
        }
        if (this.otherProviders != null) {
            return this.otherProviders.stream().anyMatch(x -> StringUtils.equals((CharSequence)externalDataObject.getSource(), (CharSequence)x.getSourceIdentifier()));
        }
        return false;
    }
}

