/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.suggestion.openaire;

import com.ibm.icu.text.CharsetDetector;
import com.ibm.icu.text.CharsetMatch;
import com.ibm.icu.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.dspace.app.suggestion.SuggestionEvidence;
import org.dspace.app.suggestion.SuggestionUtils;
import org.dspace.app.suggestion.openaire.EvidenceScorer;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.content.service.ItemService;
import org.dspace.external.model.ExternalDataObject;
import org.springframework.beans.factory.annotation.Autowired;

public class AuthorNamesScorer
implements EvidenceScorer {
    private List<String> contributorMetadata;
    private List<String> names;
    @Autowired
    private ItemService itemService;

    public List<String> getContributorMetadata() {
        return this.contributorMetadata;
    }

    public void setContributorMetadata(List<String> contributorMetadata) {
        this.contributorMetadata = contributorMetadata;
    }

    public List<String> getNames() {
        return this.names;
    }

    public void setNames(List<String> names) {
        this.names = names;
    }

    @Override
    public SuggestionEvidence computeEvidence(Item researcher, ExternalDataObject importRecord) {
        List<String[]> names = this.searchMetadataValues(researcher);
        int maxNameLenght = names.stream().mapToInt(n -> n[0].length()).max().orElse(1);
        ArrayList<String> metadataAuthors = new ArrayList<String>();
        for (String contributorMetadatum : this.contributorMetadata) {
            metadataAuthors.addAll(SuggestionUtils.getAllEntriesByMetadatum(importRecord, contributorMetadatum));
        }
        List normalizedMetadataAuthors = metadataAuthors.stream().map(x -> this.normalize((String)x)).collect(Collectors.toList());
        int idx = 0;
        for (String nMetadataAuthor : normalizedMetadataAuthors) {
            Optional<String[]> found = names.stream().filter(a -> StringUtils.equalsIgnoreCase((CharSequence)a[0], (CharSequence)nMetadataAuthor)).findFirst();
            if (found.isPresent()) {
                return new SuggestionEvidence(this.getClass().getSimpleName(), 100.0 * ((double)nMetadataAuthor.length() / (double)maxNameLenght), "The author " + (String)metadataAuthors.get(idx) + " at position " + (idx + 1) + " in the authors list matches the name " + found.get()[1] + " in the researcher profile");
            }
            ++idx;
        }
        return null;
    }

    private List<String[]> searchMetadataValues(Item researcher) {
        ArrayList<String[]> authors = new ArrayList<String[]>();
        for (String name : this.names) {
            List<MetadataValue> values = this.itemService.getMetadataByMetadataString(researcher, name);
            if (values == null) continue;
            for (MetadataValue v : values) {
                authors.add(new String[]{this.normalize(v.getValue()), v.getValue()});
            }
        }
        return authors;
    }

    private String normalize(String value) {
        String norm = Normalizer.normalize((String)value, (Normalizer.Mode)Normalizer.NFD);
        CharsetDetector cd = new CharsetDetector();
        cd.setText(value.getBytes());
        CharsetMatch detect = cd.detect();
        norm = detect != null && detect.getLanguage() != null ? norm.replaceAll("[^\\p{L}]", " ").toLowerCase(new Locale(detect.getLanguage())) : norm.replaceAll("[^\\p{L}]", " ").toLowerCase();
        return Arrays.asList(norm.split("\\s+")).stream().sorted().collect(Collectors.joining());
    }
}

