/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.suggestion;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.dspace.external.model.ExternalDataObject;

public class SuggestionUtils {
    private SuggestionUtils() {
    }

    public static List<String> getAllEntriesByMetadatum(ExternalDataObject record, String schema, String element, String qualifier) {
        return record.getMetadata().stream().filter(x -> StringUtils.equals((CharSequence)x.getSchema(), (CharSequence)schema) && StringUtils.equals((CharSequence)x.getElement(), (CharSequence)element) && StringUtils.equals((CharSequence)x.getQualifier(), (CharSequence)qualifier)).map(x -> x.getValue()).collect(Collectors.toList());
    }

    public static List<String> getAllEntriesByMetadatum(ExternalDataObject record, String metadataFieldKey) {
        if (metadataFieldKey == null) {
            return Collections.EMPTY_LIST;
        }
        String[] fields = metadataFieldKey.split("\\.");
        String schema = fields[0];
        String element = fields[1];
        String qualifier = null;
        if (fields.length == 3) {
            qualifier = fields[2];
        }
        return SuggestionUtils.getAllEntriesByMetadatum(record, schema, element, qualifier);
    }

    public static String getFirstEntryByMetadatum(ExternalDataObject record, String schema, String element, String qualifier) {
        return record.getMetadata().stream().filter(x -> StringUtils.equals((CharSequence)x.getSchema(), (CharSequence)schema) && StringUtils.equals((CharSequence)x.getElement(), (CharSequence)element) && StringUtils.equals((CharSequence)x.getQualifier(), (CharSequence)qualifier)).map(x -> x.getValue()).findFirst().orElse(null);
    }

    public static String getFirstEntryByMetadatum(ExternalDataObject record, String metadataFieldKey) {
        if (metadataFieldKey == null) {
            return null;
        }
        String[] fields = metadataFieldKey.split("\\.");
        String schema = fields[0];
        String element = fields[1];
        String qualifier = null;
        if (fields.length == 3) {
            qualifier = fields[2];
        }
        return SuggestionUtils.getFirstEntryByMetadatum(record, schema, element, qualifier);
    }
}

