/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.suggestion;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.solr.client.solrj.SolrServerException;
import org.dspace.app.suggestion.SolrSuggestionStorageService;
import org.dspace.app.suggestion.Suggestion;
import org.dspace.app.suggestion.SuggestionProvider;
import org.dspace.app.suggestion.SuggestionTarget;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.external.model.ExternalDataObject;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class SolrSuggestionProvider
implements SuggestionProvider {
    private static final Logger log = LogManager.getLogger(SolrSuggestionProvider.class);
    @Autowired
    protected ItemService itemService;
    @Autowired
    protected SolrSuggestionStorageService solrSuggestionStorageService;
    private String sourceName;

    public String getSourceName() {
        return this.sourceName;
    }

    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }

    public void setItemService(ItemService itemService) {
        this.itemService = itemService;
    }

    @Override
    public long countAllTargets(Context context) {
        try {
            return this.solrSuggestionStorageService.countAllTargets(context, this.sourceName);
        }
        catch (IOException | SolrServerException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public long countUnprocessedSuggestionByTarget(Context context, UUID target) {
        try {
            return this.solrSuggestionStorageService.countUnprocessedSuggestionByTarget(context, this.sourceName, target);
        }
        catch (IOException | SolrServerException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<Suggestion> findAllUnprocessedSuggestions(Context context, UUID target, int pageSize, long offset, boolean ascending) {
        try {
            return this.solrSuggestionStorageService.findAllUnprocessedSuggestions(context, this.sourceName, target, pageSize, offset, ascending);
        }
        catch (IOException | SolrServerException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<SuggestionTarget> findAllTargets(Context context, int pageSize, long offset) {
        try {
            return this.solrSuggestionStorageService.findAllTargets(context, this.sourceName, pageSize, offset);
        }
        catch (IOException | SolrServerException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Suggestion findUnprocessedSuggestion(Context context, UUID target, String id) {
        try {
            return this.solrSuggestionStorageService.findUnprocessedSuggestion(context, this.sourceName, target, id);
        }
        catch (IOException | SolrServerException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public SuggestionTarget findTarget(Context context, UUID target) {
        try {
            return this.solrSuggestionStorageService.findTarget(context, this.sourceName, target);
        }
        catch (IOException | SolrServerException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void rejectSuggestion(Context context, UUID target, String idPart) {
        Suggestion suggestion = this.findUnprocessedSuggestion(context, target, idPart);
        try {
            this.solrSuggestionStorageService.flagSuggestionAsProcessed(suggestion);
        }
        catch (IOException | SolrServerException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void flagRelatedSuggestionsAsProcessed(Context context, ExternalDataObject externalDataObject) {
        if (!this.isExternalDataObjectPotentiallySuggested(context, externalDataObject)) {
            return;
        }
        try {
            this.solrSuggestionStorageService.flagAllSuggestionAsProcessed(this.sourceName, externalDataObject.getId());
        }
        catch (IOException | SolrServerException e) {
            log.error(e.getMessage(), e);
        }
    }

    protected abstract boolean isExternalDataObjectPotentiallySuggested(Context var1, ExternalDataObject var2);
}

