/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xmlworkflow.storedcomponents.dao.impl;

import java.sql.SQLException;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.dspace.core.AbstractHibernateDAO;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.xmlworkflow.storedcomponents.PoolTask;
import org.dspace.xmlworkflow.storedcomponents.PoolTask_;
import org.dspace.xmlworkflow.storedcomponents.XmlWorkflowItem;
import org.dspace.xmlworkflow.storedcomponents.dao.PoolTaskDAO;

public class PoolTaskDAOImpl
extends AbstractHibernateDAO<PoolTask>
implements PoolTaskDAO {
    protected PoolTaskDAOImpl() {
    }

    @Override
    public List<PoolTask> findByEPerson(Context context, EPerson ePerson) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<PoolTask> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, PoolTask.class);
        Root poolTaskRoot = criteriaQuery.from(PoolTask.class);
        criteriaQuery.select((Selection)poolTaskRoot);
        criteriaQuery.where((Expression)criteriaBuilder.equal((Expression)poolTaskRoot.get(PoolTask_.ePerson), (Object)ePerson));
        return this.list(context, criteriaQuery, false, PoolTask.class, -1, -1);
    }

    @Override
    public List<PoolTask> findByGroup(Context context, Group group) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<PoolTask> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, PoolTask.class);
        Root poolTaskRoot = criteriaQuery.from(PoolTask.class);
        criteriaQuery.select((Selection)poolTaskRoot);
        criteriaQuery.where((Expression)criteriaBuilder.equal((Expression)poolTaskRoot.get(PoolTask_.group), (Object)group));
        return this.list(context, criteriaQuery, false, PoolTask.class, -1, -1);
    }

    @Override
    public List<PoolTask> findByWorkflowItem(Context context, XmlWorkflowItem workflowItem) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<PoolTask> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, PoolTask.class);
        Root poolTaskRoot = criteriaQuery.from(PoolTask.class);
        criteriaQuery.select((Selection)poolTaskRoot);
        criteriaQuery.where((Expression)criteriaBuilder.equal((Expression)poolTaskRoot.get(PoolTask_.workflowItem), (Object)workflowItem));
        return this.list(context, criteriaQuery, false, PoolTask.class, -1, -1);
    }

    @Override
    public PoolTask findByWorkflowItemAndEPerson(Context context, XmlWorkflowItem workflowItem, EPerson ePerson) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<PoolTask> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, PoolTask.class);
        Root poolTaskRoot = criteriaQuery.from(PoolTask.class);
        criteriaQuery.select((Selection)poolTaskRoot);
        criteriaQuery.where((Expression)criteriaBuilder.and((Expression)criteriaBuilder.equal((Expression)poolTaskRoot.get(PoolTask_.workflowItem), (Object)workflowItem), (Expression)criteriaBuilder.equal((Expression)poolTaskRoot.get(PoolTask_.ePerson), (Object)ePerson)));
        return this.uniqueResult(context, criteriaQuery, false, PoolTask.class);
    }

    @Override
    public PoolTask findByWorkflowItemAndGroup(Context context, Group group, XmlWorkflowItem workflowItem) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<PoolTask> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, PoolTask.class);
        Root poolTaskRoot = criteriaQuery.from(PoolTask.class);
        criteriaQuery.select((Selection)poolTaskRoot);
        criteriaQuery.where((Expression)criteriaBuilder.and((Expression)criteriaBuilder.equal((Expression)poolTaskRoot.get(PoolTask_.workflowItem), (Object)workflowItem), (Expression)criteriaBuilder.equal((Expression)poolTaskRoot.get(PoolTask_.group), (Object)group)));
        return this.uniqueResult(context, criteriaQuery, false, PoolTask.class);
    }
}

