/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.util;

import java.util.List;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.dspace.content.Bitstream;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.discovery.DiscoverQuery;
import org.dspace.discovery.DiscoverResult;
import org.dspace.discovery.SearchService;
import org.dspace.discovery.SearchServiceException;
import org.dspace.services.ConfigurationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FrontendUrlService {
    private static final Logger log = LoggerFactory.getLogger(FrontendUrlService.class);
    @Autowired
    private ConfigurationService configurationService;
    @Autowired
    private SearchService searchService;

    public String generateUrl(Context context, Item item) {
        String uiURL = this.configurationService.getProperty("dspace.ui.url");
        return this.generateUrlWithSearchService(item, uiURL, context).orElseGet(() -> uiURL + "/items/" + item.getID());
    }

    public String generateUrl(Bitstream bitstream) {
        String uiURL = this.configurationService.getProperty("dspace.ui.url");
        return uiURL + "/bitstreams/" + bitstream.getID() + "/download";
    }

    private Optional<String> generateUrlWithSearchService(Item item, String uiURLStem, Context context) {
        DiscoverQuery entityQuery = new DiscoverQuery();
        entityQuery.setQuery("search.uniqueid:\"Item-" + item.getID() + "\" and entityType:*");
        entityQuery.addSearchField("entityType");
        try {
            List<String> entityTypes;
            DiscoverResult discoverResult = this.searchService.search(context, entityQuery);
            if (CollectionUtils.isNotEmpty(discoverResult.getIndexableObjects()) && CollectionUtils.isNotEmpty(entityTypes = discoverResult.getSearchDocument(discoverResult.getIndexableObjects().get(0)).get(0).getSearchFieldValues("entityType")) && StringUtils.isNotBlank((CharSequence)entityTypes.get(0))) {
                return Optional.of(uiURLStem + "/entities/" + StringUtils.lowerCase((String)entityTypes.get(0)) + "/" + item.getID());
            }
        }
        catch (SearchServiceException e) {
            log.error("Failed getting entitytype through solr for item " + item.getID() + ": " + e.getMessage());
        }
        return Optional.empty();
    }
}

