/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.iiif.util;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Item;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;

public class IIIFSharedUtils {
    public static final String METADATA_IIIF_ENABLED = "dspace.iiif.enabled";
    protected static final String OTHER_CONTENT_BUNDLE = "OtherContent";
    protected static final String IMAGE_SERVER_PATH = "iiif.image.server";
    public static final String METADATA_IIIF_SCHEMA = "iiif";
    public static final String METADATA_IIIF_IMAGE_ELEMENT = "image";
    public static final String METADATA_IIIF_TOC_ELEMENT = "toc";
    public static final String METADATA_IIIF_LABEL_ELEMENT = "label";
    public static final String METADATA_IIIF_HEIGHT_QUALIFIER = "height";
    public static final String METADATA_IIIF_WIDTH_QUALIFIER = "width";
    protected static final ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();

    private IIIFSharedUtils() {
    }

    public static boolean isIIIFItem(Item item) {
        return item.getMetadata().stream().filter(m -> m.getMetadataField().toString('.').contentEquals(METADATA_IIIF_ENABLED)).anyMatch(m -> m.getValue().equalsIgnoreCase("true") || m.getValue().equalsIgnoreCase("yes"));
    }

    public static List<Bundle> getIIIFBundles(Item item) {
        boolean iiif = IIIFSharedUtils.isIIIFEnabled(item);
        List<Bundle> bundles = new ArrayList<Bundle>();
        if (iiif) {
            bundles = item.getBundles().stream().filter(IIIFSharedUtils::isIIIFBundle).collect(Collectors.toList());
        }
        return bundles;
    }

    public static boolean isIIIFEnabled(Item item) {
        return item.getOwningCollection().getMetadata().stream().filter(m -> m.getMetadataField().toString('.').contentEquals(METADATA_IIIF_ENABLED)).anyMatch(m -> m.getValue().equalsIgnoreCase("true") || m.getValue().equalsIgnoreCase("yes")) || item.getMetadata().stream().filter(m -> m.getMetadataField().toString('.').contentEquals(METADATA_IIIF_ENABLED)).anyMatch(m -> m.getValue().equalsIgnoreCase("true") || m.getValue().equalsIgnoreCase("yes"));
    }

    public static boolean isIIIFBundle(Bundle b) {
        return !StringUtils.equalsAnyIgnoreCase((CharSequence)b.getName(), (CharSequence[])new CharSequence[]{"LICENSE", "METADATA", "CC-LICENSE", "THUMBNAIL", "BRANDED_PREVIEW", "TEXT", OTHER_CONTENT_BUNDLE}) && b.getMetadata().stream().filter(m -> m.getMetadataField().toString('.').contentEquals(METADATA_IIIF_ENABLED)).noneMatch(m -> m.getValue().equalsIgnoreCase("false") || m.getValue().equalsIgnoreCase("no"));
    }

    public static String getInfoJsonPath(Bitstream bitstream) {
        String iiifImageServer = configurationService.getProperty(IMAGE_SERVER_PATH);
        return iiifImageServer + bitstream.getID() + "/info.json";
    }
}

