/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.ctask.general;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.ListUtils;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.BitstreamService;
import org.dspace.curate.AbstractCurationTask;
import org.dspace.curate.Curator;
import org.dspace.curate.Suspendable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Suspendable(invoked=Curator.Invoked.INTERACTIVE)
public class ClamScan
extends AbstractCurationTask {
    protected final int DEFAULT_CHUNK_SIZE = 4096;
    protected final byte[] INSTREAM = "zINSTREAM\u0000".getBytes();
    protected final byte[] PING = "zPING\u0000".getBytes();
    protected final byte[] STATS = "nSTATS\n".getBytes();
    protected final byte[] IDSESSION = "zIDSESSION\u0000".getBytes();
    protected final byte[] END = "zEND\u0000".getBytes();
    protected final String PLUGIN_PREFIX = "clamav";
    protected final String INFECTED_MESSAGE = "had virus detected.";
    protected final String CLEAN_MESSAGE = "had no viruses detected.";
    protected final String CONNECT_FAIL_MESSAGE = "Unable to connect to virus service - check setup";
    protected final String SCAN_FAIL_MESSAGE = "Error encountered using virus service - check setup";
    protected final String NEW_ITEM_HANDLE = "in workflow";
    private static final Logger log = LoggerFactory.getLogger(ClamScan.class);
    protected String host = null;
    protected int port = 0;
    protected int timeout = 0;
    protected boolean failfast = true;
    protected int status = -2;
    protected List<String> results = null;
    protected Socket socket = null;
    protected DataOutputStream dataOutputStream = null;
    protected BitstreamService bitstreamService;
    final byte[] buffer = new byte[4096];

    @Override
    public void init(Curator curator, String taskId) throws IOException {
        super.init(curator, taskId);
        this.host = this.configurationService.getProperty("clamav.service.host");
        this.port = this.configurationService.getIntProperty("clamav.service.port");
        this.timeout = this.configurationService.getIntProperty("clamav.socket.timeout");
        this.failfast = this.configurationService.getBooleanProperty("clamav.scan.failfast");
        this.bitstreamService = ContentServiceFactory.getInstance().getBitstreamService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int perform(DSpaceObject dso) throws IOException {
        this.status = 2;
        this.logDebugMessage("The target dso is " + dso.getName());
        if (dso instanceof Item) {
            this.status = 0;
            Item item = (Item)dso;
            try {
                this.openSession();
            }
            catch (IOException ioE) {
                this.closeSession();
                this.setResult("Unable to connect to virus service - check setup");
                return -1;
            }
            try {
                List<Bundle> bundles = this.itemService.getBundles(item, "ORIGINAL");
                if (ListUtils.emptyIfNull(bundles).isEmpty()) {
                    this.setResult("No ORIGINAL bundle found for item: " + this.getItemHandle(item));
                    int n = 2;
                    return n;
                }
                Bundle bundle = bundles.get(0);
                this.results = new ArrayList<String>();
                for (Bitstream bitstream : bundle.getBitstreams()) {
                    InputStream inputstream = this.bitstreamService.retrieve(Curator.curationContext(), bitstream);
                    this.logDebugMessage("Scanning " + bitstream.getName() + " . . . ");
                    int bstatus = this.scan(bitstream, inputstream, this.getItemHandle(item));
                    inputstream.close();
                    if (bstatus == -1) {
                        this.setResult("Error encountered using virus service - check setup");
                        this.status = bstatus;
                        break;
                    }
                    if (this.failfast && bstatus == 1) {
                        this.status = bstatus;
                        break;
                    }
                    if (bstatus != 1 || this.status != 0) continue;
                    this.status = bstatus;
                }
            }
            catch (Exception e) {
                log.error("Error scanning item: " + this.getItemHandle(item), (Throwable)e);
                this.status = -1;
            }
            finally {
                this.closeSession();
            }
            if (this.status != -1) {
                this.formatResults(item);
            }
        }
        return this.status;
    }

    protected void openSession() throws IOException {
        this.socket = new Socket();
        try {
            this.logDebugMessage("Connecting to " + this.host + ":" + this.port);
            this.socket.connect(new InetSocketAddress(this.host, this.port));
        }
        catch (IOException e) {
            log.error("Failed to connect to clamd . . .", (Throwable)e);
            throw e;
        }
        try {
            this.socket.setSoTimeout(this.timeout);
        }
        catch (SocketException e) {
            log.error("Could not set socket timeout . . .  " + this.timeout + "ms", (Throwable)e);
            throw new IOException(e);
        }
        try {
            this.dataOutputStream = new DataOutputStream(this.socket.getOutputStream());
        }
        catch (IOException e) {
            log.error("Failed to open OutputStream . . . ", (Throwable)e);
            throw e;
        }
        try {
            this.dataOutputStream.write(this.IDSESSION);
        }
        catch (IOException e) {
            log.error("Error initiating session with IDSESSION command . . . ", (Throwable)e);
            throw e;
        }
    }

    protected void closeSession() {
        if (this.dataOutputStream != null) {
            try {
                this.dataOutputStream.write(this.END);
            }
            catch (IOException e) {
                log.error("Exception closing dataOutputStream", (Throwable)e);
            }
        }
        try {
            this.logDebugMessage("Closing the socket for ClamAv daemon . . . ");
            this.socket.close();
        }
        catch (IOException e) {
            log.error("Exception closing socket", (Throwable)e);
        }
    }

    protected int scan(Bitstream bitstream, InputStream inputstream, String itemHandle) {
        try {
            this.dataOutputStream.write(this.INSTREAM);
        }
        catch (IOException e) {
            log.error("Error writing INSTREAM command", (Throwable)e);
            return -1;
        }
        int read = 4096;
        while (read == 4096) {
            try {
                read = inputstream.read(this.buffer);
            }
            catch (IOException e) {
                log.error("Failed attempting to read the InputStream", (Throwable)e);
                return -1;
            }
            if (read == -1) break;
            try {
                this.dataOutputStream.writeInt(read);
                this.dataOutputStream.write(this.buffer, 0, read);
            }
            catch (IOException e) {
                log.error("Could not write to the socket", (Throwable)e);
                return -1;
            }
        }
        try {
            this.dataOutputStream.writeInt(0);
            this.dataOutputStream.flush();
        }
        catch (IOException e) {
            log.error("Error writing zero-length chunk to socket", (Throwable)e);
            return -1;
        }
        try {
            read = this.socket.getInputStream().read(this.buffer);
        }
        catch (IOException e) {
            log.error("Error reading result from socket", (Throwable)e);
            return -1;
        }
        if (read > 0) {
            String response = new String(this.buffer, 0, read);
            this.logDebugMessage("Response: " + response);
            if (response.contains("FOUND")) {
                String itemMsg = "item - " + itemHandle + ": ";
                String bsMsg = "bitstream - " + bitstream.getName() + ": SequenceId - " + bitstream.getSequenceID() + ": infected";
                this.report(itemMsg + bsMsg);
                this.results.add(bsMsg);
                return 1;
            }
            return 0;
        }
        return -1;
    }

    protected void formatResults(Item item) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("Item: ").append(this.getItemHandle(item)).append(" ");
        if (this.status == 1) {
            sb.append("had virus detected.");
            int count = 0;
            for (String scanresult : this.results) {
                sb.append("\n").append(scanresult).append("\n");
                ++count;
            }
            sb.append(count).append(" virus(es) found. ").append(" failfast: ").append(this.failfast);
        } else {
            sb.append("had no viruses detected.");
        }
        this.setResult(sb.toString());
    }

    protected String getItemHandle(Item item) {
        String handle = item.getHandle();
        return handle != null ? handle : "in workflow";
    }

    protected void logDebugMessage(String message) {
        if (log.isDebugEnabled()) {
            log.debug(message);
        }
    }
}

