/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.identifier;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.MetadataSchemaEnum;
import org.dspace.content.MetadataValue;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.DSpaceObjectService;
import org.dspace.core.Context;
import org.dspace.core.LogHelper;
import org.dspace.handle.service.HandleService;
import org.dspace.identifier.Handle;
import org.dspace.identifier.Identifier;
import org.dspace.identifier.IdentifierException;
import org.dspace.identifier.IdentifierNotFoundException;
import org.dspace.identifier.IdentifierNotResolvableException;
import org.dspace.identifier.IdentifierProvider;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.versioning.Version;
import org.dspace.versioning.VersionHistory;
import org.dspace.versioning.service.VersionHistoryService;
import org.dspace.versioning.service.VersioningService;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class VersionedHandleIdentifierProviderWithCanonicalHandles
extends IdentifierProvider
implements InitializingBean {
    private static final Logger log = LogManager.getLogger(VersionedHandleIdentifierProviderWithCanonicalHandles.class);
    static final String EXAMPLE_PREFIX = "123456789";
    private static final char DOT = '.';
    @Autowired(required=true)
    private VersioningService versionService;
    @Autowired(required=true)
    private VersionHistoryService versionHistoryService;
    @Autowired(required=true)
    private HandleService handleService;

    public void afterPropertiesSet() throws Exception {
        if (!this.configurationService.getBooleanProperty("versioning.enabled", true)) {
            throw new RuntimeException("the " + VersionedHandleIdentifierProviderWithCanonicalHandles.class.getName() + " is enabled, but the versioning is disabled.");
        }
    }

    @Override
    public boolean supports(Class<? extends Identifier> identifier) {
        return Handle.class.isAssignableFrom(identifier);
    }

    @Override
    public boolean supports(String identifier) {
        return this.handleService.parseHandle(identifier) != null;
    }

    @Override
    public String register(Context context, DSpaceObject dso) {
        String id = this.mint(context, dso);
        if (dso.getType() == 2 && dso instanceof Item) {
            VersionHistory history;
            Item item = (Item)dso;
            try {
                history = this.versionHistoryService.findByItem(context, item);
            }
            catch (SQLException ex) {
                throw new RuntimeException("A problem with the database connection occured.", ex);
            }
            if (history != null) {
                Version previous;
                String canonical = this.getCanonical(context, item);
                try {
                    this.handleService.modifyHandleDSpaceObject(context, canonical, item);
                }
                catch (SQLException ex) {
                    throw new RuntimeException("A problem with the database connection occured.", ex);
                }
                boolean previousIsFirstVersion = false;
                Object previousItemHandle = null;
                try {
                    Version version = this.versionService.getVersion(context, item);
                    previous = this.versionHistoryService.getPrevious(context, history, version);
                    if (previous != null) {
                        previousIsFirstVersion = this.versionHistoryService.isFirstVersion(context, history, previous);
                        previousItemHandle = this.handleService.findHandle(context, previous.getItem());
                    }
                }
                catch (SQLException ex) {
                    throw new RuntimeException("A problem with the database connection occured.", ex);
                }
                if (previous != null) {
                    try {
                        context.turnOffAuthorisationSystem();
                        if (previousItemHandle == null) {
                            if (previousIsFirstVersion) {
                                previousItemHandle = this.getCanonical(id) + "." + previous.getVersionNumber();
                                this.handleService.createHandle(context, previous.getItem(), (String)previousItemHandle);
                            } else {
                                previousItemHandle = this.makeIdentifierBasedOnHistory(context, previous.getItem(), history);
                            }
                        }
                        this.modifyHandleMetadata(context, previous.getItem(), (String)previousItemHandle);
                    }
                    catch (SQLException ex) {
                        throw new RuntimeException("A problem with the database connection occured.", ex);
                    }
                    catch (AuthorizeException ex) {
                        throw new IllegalStateException("Caught an AuthorizeException while the authorization system was turned off!", ex);
                    }
                    finally {
                        context.restoreAuthSystemState();
                    }
                }
            }
            try {
                this.modifyHandleMetadata(context, item, this.getCanonical(id));
            }
            catch (SQLException ex) {
                throw new RuntimeException("A problem with the database connection occured.", ex);
            }
            catch (AuthorizeException ex) {
                throw new RuntimeException("The current user is not authorized to change this item.", ex);
            }
        }
        if (dso instanceof Collection || dso instanceof Community) {
            try {
                this.modifyHandleMetadata(context, dso, this.getCanonical(id));
            }
            catch (SQLException ex) {
                throw new RuntimeException("A problem with the database connection occured.", ex);
            }
            catch (AuthorizeException ex) {
                throw new RuntimeException("The current user is not authorized to change this item.", ex);
            }
        }
        return id;
    }

    @Override
    public void register(Context context, DSpaceObject dso, String identifier) {
        try {
            if (dso instanceof Item) {
                Item item = (Item)dso;
                VersionHistory itemHistory = this.getHistory(context, identifier);
                if (!identifier.matches(".*/.*\\.\\d+") && itemHistory != null) {
                    int newVersionNumber = this.versionHistoryService.getLatestVersion(context, itemHistory).getVersionNumber() + 1;
                    String canonical = identifier;
                    identifier = identifier.concat(".").concat("" + newVersionNumber);
                    this.restoreItAsVersion(context, dso, identifier, item, canonical, itemHistory);
                } else if (identifier.matches(".*/.*\\.\\d+")) {
                    String canonical = this.getCanonical(identifier);
                    DSpaceObject canonicalItem = this.resolve(context, canonical, new String[0]);
                    if (canonicalItem == null) {
                        this.restoreItAsCanonical(context, dso, identifier, item, canonical);
                    } else {
                        VersionHistory history = this.versionHistoryService.findByItem(context, (Item)canonicalItem);
                        if (history == null) {
                            this.restoreItAsCanonical(context, dso, identifier, item, canonical);
                        } else {
                            this.restoreItAsVersion(context, dso, identifier, item, canonical, history);
                        }
                    }
                } else {
                    this.createNewIdentifier(context, dso, identifier);
                    this.modifyHandleMetadata(context, item, this.getCanonical(identifier));
                }
            } else {
                this.createNewIdentifier(context, dso, identifier);
            }
        }
        catch (IOException | SQLException | AuthorizeException e) {
            log.error(LogHelper.getHeader(context, "Error while attempting to create handle", "Item id: " + dso.getID()), (Throwable)e);
            throw new RuntimeException("Error while attempting to create identifier for Item id: " + dso.getID(), e);
        }
    }

    protected VersionHistory getHistory(Context context, String identifier) throws SQLException {
        DSpaceObject item = this.resolve(context, identifier, new String[0]);
        if (item != null) {
            VersionHistory history = this.versionHistoryService.findByItem(context, (Item)item);
            return history;
        }
        return null;
    }

    protected void restoreItAsVersion(Context context, DSpaceObject dso, String identifier, Item item, String canonical, VersionHistory history) throws SQLException, IOException, AuthorizeException {
        this.createNewIdentifier(context, dso, identifier);
        this.modifyHandleMetadata(context, item, this.getCanonical(identifier));
        int versionNumber = Integer.parseInt(identifier.substring(identifier.lastIndexOf(".") + 1));
        this.versionService.createNewVersion(context, history, item, "Restoring from AIP Service", new Date(), versionNumber);
        Version latest = this.versionHistoryService.getLatestVersion(context, history);
        if (latest.getVersionNumber() < versionNumber) {
            this.handleService.modifyHandleDSpaceObject(context, canonical, dso);
        }
    }

    protected void restoreItAsCanonical(Context context, DSpaceObject dso, String identifier, Item item, String canonical) throws SQLException, IOException, AuthorizeException {
        this.createNewIdentifier(context, dso, identifier);
        this.modifyHandleMetadata(context, item, this.getCanonical(identifier));
        int versionNumber = Integer.parseInt(identifier.substring(identifier.lastIndexOf(".") + 1));
        VersionHistory history = (VersionHistory)this.versionHistoryService.create(context);
        this.versionService.createNewVersion(context, history, item, "Restoring from AIP Service", new Date(), versionNumber);
        this.handleService.modifyHandleDSpaceObject(context, canonical, dso);
    }

    @Override
    public void reserve(Context context, DSpaceObject dso, String identifier) {
        try {
            this.handleService.createHandle(context, dso, identifier);
        }
        catch (IllegalStateException | SQLException e) {
            log.error(LogHelper.getHeader(context, "Error while attempting to create handle", "Item id: " + dso.getID()), (Throwable)e);
            throw new RuntimeException("Error while attempting to create identifier for Item id: " + dso.getID());
        }
    }

    @Override
    public String mint(Context context, DSpaceObject dso) {
        if (dso.getHandle() != null) {
            return dso.getHandle();
        }
        try {
            String handleId = null;
            VersionHistory history = null;
            if (dso instanceof Item) {
                history = this.versionHistoryService.findByItem(context, (Item)dso);
            }
            handleId = history != null ? this.makeIdentifierBasedOnHistory(context, dso, history) : this.createNewIdentifier(context, dso, null);
            return handleId;
        }
        catch (SQLException | AuthorizeException e) {
            log.error(LogHelper.getHeader(context, "Error while attempting to create handle", "Item id: " + dso.getID()), (Throwable)e);
            throw new RuntimeException("Error while attempting to create identifier for Item id: " + dso.getID());
        }
    }

    @Override
    public DSpaceObject resolve(Context context, String identifier, String ... attributes) {
        try {
            identifier = this.handleService.parseHandle(identifier);
            return this.handleService.resolveToObject(context, identifier);
        }
        catch (IllegalStateException | SQLException e) {
            log.error(LogHelper.getHeader(context, "Error while resolving handle to item", "handle: " + identifier), (Throwable)e);
            return null;
        }
    }

    @Override
    public String lookup(Context context, DSpaceObject dso) throws IdentifierNotFoundException, IdentifierNotResolvableException {
        try {
            return this.handleService.findHandle(context, dso);
        }
        catch (SQLException sqe) {
            throw new IdentifierNotResolvableException(sqe.getMessage(), sqe);
        }
    }

    @Override
    public void delete(Context context, DSpaceObject dso, String identifier) throws IdentifierException {
        this.delete(context, dso);
    }

    @Override
    public void delete(Context context, DSpaceObject dso) throws IdentifierException {
        block4: {
            try {
                Item previous;
                Item item;
                VersionHistory history;
                if (!(dso instanceof Item) || (history = this.versionHistoryService.findByItem(context, item = (Item)dso)) == null || !this.versionHistoryService.getLatestVersion(context, history).getItem().equals(item) || this.versionService.getVersionsByHistory(context, history).size() <= 1) break block4;
                try {
                    previous = this.versionHistoryService.getPrevious(context, history, this.versionHistoryService.getLatestVersion(context, history)).getItem();
                }
                catch (SQLException ex) {
                    throw new RuntimeException("A problem with our database connection occured.", ex);
                }
                String canonical = this.getCanonical(context, previous);
                this.handleService.modifyHandleDSpaceObject(context, canonical, previous);
            }
            catch (RuntimeException | SQLException e) {
                log.error(LogHelper.getHeader(context, "Error while attempting to register doi", "Item id: " + dso.getID()), (Throwable)e);
                throw new IdentifierException("Error while moving doi identifier", e);
            }
        }
    }

    public static String retrieveHandleOutOfUrl(String url) {
        if (!url.contains("/")) {
            return null;
        }
        String[] splitUrl = url.split("/");
        return splitUrl[splitUrl.length - 2] + "/" + splitUrl[splitUrl.length - 1];
    }

    public static String getPrefix() {
        ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
        String prefix = configurationService.getProperty("handle.prefix");
        if (null == prefix) {
            prefix = EXAMPLE_PREFIX;
            log.error("handle.prefix is not configured; using " + prefix);
        }
        return prefix;
    }

    protected String createNewIdentifier(Context context, DSpaceObject dso, String handleId) throws SQLException {
        if (handleId == null) {
            return this.handleService.createHandle(context, dso);
        }
        return this.handleService.createHandle(context, dso, handleId);
    }

    protected String makeIdentifierBasedOnHistory(Context context, DSpaceObject dso, VersionHistory history) throws AuthorizeException, SQLException {
        DSpaceObject itemWithCanonicalHandle;
        String identifierPreviousItem;
        Version previous;
        Item item = (Item)dso;
        Version version = this.versionService.getVersion(context, item);
        try {
            previous = this.versionHistoryService.getPrevious(context, history, version);
        }
        catch (SQLException ex) {
            throw new RuntimeException("A problem with our database connection occured.");
        }
        String canonical = this.getCanonical(context, previous.getItem());
        if (this.versionHistoryService.isFirstVersion(context, history, previous) && this.handleService.resolveToObject(context, identifierPreviousItem = canonical + "." + previous.getVersionNumber()) == null) {
            this.handleService.createHandle(context, previous.getItem(), identifierPreviousItem, true);
        }
        if ((itemWithCanonicalHandle = this.handleService.resolveToObject(context, canonical)) != null) {
            if (itemWithCanonicalHandle.getID() != previous.getItem().getID()) {
                log.warn("The previous version's item (" + previous.getItem().getID() + ") does not match with the item containing handle " + canonical + " (" + itemWithCanonicalHandle.getID() + ")");
            }
            this.handleService.modifyHandleDSpaceObject(context, canonical, dso);
        } else {
            this.handleService.createHandle(context, dso, canonical);
        }
        String idNew = canonical + "." + version.getVersionNumber();
        if (this.handleService.resolveToObject(context, idNew) == null) {
            this.handleService.createHandle(context, dso, idNew);
        } else {
            this.handleService.modifyHandleDSpaceObject(context, idNew, dso);
        }
        return idNew;
    }

    protected String getCanonical(Context context, Item item) {
        String canonical = item.getHandle();
        if (canonical.matches(".*/.*\\.\\d+") && canonical.lastIndexOf(46) != -1) {
            canonical = canonical.substring(0, canonical.lastIndexOf(46));
        }
        return canonical;
    }

    protected String getCanonical(String identifier) {
        String canonical = identifier;
        if (canonical.matches(".*/.*\\.\\d+") && canonical.lastIndexOf(46) != -1) {
            canonical = canonical.substring(0, canonical.lastIndexOf(46));
        }
        return canonical;
    }

    protected void modifyHandleMetadata(Context context, DSpaceObject dso, String handle) throws SQLException, AuthorizeException {
        String handleref = this.handleService.getCanonicalForm(handle);
        DSpaceObjectService<DSpaceObject> dSpaceObjectService = ContentServiceFactory.getInstance().getDSpaceObjectService(dso);
        List<MetadataValue> identifiers = dSpaceObjectService.getMetadata(dso, MetadataSchemaEnum.DC.getName(), "identifier", "uri", "*");
        dSpaceObjectService.clearMetadata(context, dso, MetadataSchemaEnum.DC.getName(), "identifier", "uri", "*");
        for (MetadataValue identifier : identifiers) {
            if (this.supports(identifier.getValue())) continue;
            dSpaceObjectService.addMetadata(context, dso, identifier.getMetadataField(), identifier.getLanguage(), identifier.getValue(), identifier.getAuthority(), identifier.getConfidence());
        }
        if (!StringUtils.isEmpty((CharSequence)handleref)) {
            dSpaceObjectService.addMetadata(context, dso, MetadataSchemaEnum.DC.getName(), "identifier", "uri", null, handleref);
        }
        dSpaceObjectService.update(context, dso);
    }
}

