/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.eperson;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.client.DSpaceHttpClientFactory;
import org.dspace.eperson.CaptchaSettings;
import org.dspace.eperson.GoogleCaptchaResponse;
import org.dspace.eperson.InvalidReCaptchaException;
import org.dspace.eperson.service.CaptchaService;
import org.dspace.services.ConfigurationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

public class CaptchaServiceImpl
implements CaptchaService {
    private static final Logger log = LogManager.getLogger(CaptchaServiceImpl.class);
    private static Pattern RESPONSE_PATTERN = Pattern.compile("[A-Za-z0-9_-]+");
    private CaptchaSettings captchaSettings;
    @Autowired
    private ConfigurationService configurationService;

    @PostConstruct
    public void init() {
        this.captchaSettings = new CaptchaSettings();
        this.captchaSettings.setSite(this.configurationService.getProperty("google.recaptcha.key.site"));
        this.captchaSettings.setSecret(this.configurationService.getProperty("google.recaptcha.key.secret"));
        this.captchaSettings.setSiteVerify(this.configurationService.getProperty("google.recaptcha.site-verify"));
        this.captchaSettings.setCaptchaVersion(this.configurationService.getProperty("google.recaptcha.version", "v2"));
        this.captchaSettings.setThreshold(Float.parseFloat(this.configurationService.getProperty("google.recaptcha.key.threshold", "0.5")));
    }

    @Override
    public void processResponse(String response, String action) throws InvalidReCaptchaException {
        if (!this.responseSanityCheck(response)) {
            throw new InvalidReCaptchaException("Response contains invalid characters");
        }
        URI verifyUri = URI.create(this.captchaSettings.getSiteVerify());
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>(3);
        params.add(new BasicNameValuePair("secret", this.captchaSettings.getSecret()));
        params.add(new BasicNameValuePair("response", response));
        params.add(new BasicNameValuePair("remoteip", ""));
        HttpPost httpPost = new HttpPost(verifyUri);
        try {
            httpPost.addHeader("Accept", "application/json");
            httpPost.addHeader("Content-Type", "application/x-www-form-urlencoded");
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
        try (CloseableHttpClient httpClient = DSpaceHttpClientFactory.getInstance().build();){
            ObjectMapper objectMapper = new ObjectMapper();
            try (CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpPost);){
                GoogleCaptchaResponse googleResponse = (GoogleCaptchaResponse)objectMapper.readValue(httpResponse.getEntity().getContent(), GoogleCaptchaResponse.class);
                this.validateGoogleResponse(googleResponse, action);
            }
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException("Error during verify google recaptcha site", e);
        }
    }

    private boolean responseSanityCheck(String response) {
        return StringUtils.hasLength((String)response) && RESPONSE_PATTERN.matcher(response).matches();
    }

    private void validateGoogleResponse(GoogleCaptchaResponse googleResponse, String action) {
        if (Objects.isNull(googleResponse)) {
            log.error("Google reCaptcha response was empty. ReCaptcha could not be validated.");
            throw new InvalidReCaptchaException("reCaptcha was not successfully validated");
        }
        if ("v2".equals(this.captchaSettings.getCaptchaVersion())) {
            if (!googleResponse.isSuccess()) {
                log.error("Google reCaptcha v2 returned an unsuccessful response. ReCaptcha was not validated.");
                throw new InvalidReCaptchaException("reCaptcha was not successfully validated");
            }
        } else if (!googleResponse.isSuccess() || !googleResponse.getAction().equals(action) || googleResponse.getScore() < this.captchaSettings.getThreshold()) {
            log.error("Google reCaptcha v3 returned an unsuccessful response with action {" + googleResponse.getAction() + "} and score {" + googleResponse.getScore() + "}. ReCaptcha was not validated.");
            throw new InvalidReCaptchaException("reCaptcha was not successfully validated");
        }
    }
}

