/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.io.IOException;
import java.util.Date;
import java.util.Objects;
import javax.mail.MessagingException;
import javax.servlet.http.HttpServletRequest;
import org.dspace.content.service.FeedbackService;
import org.dspace.core.Context;
import org.dspace.core.Email;
import org.dspace.core.I18nUtil;

public class FeedbackServiceImpl
implements FeedbackService {
    @Override
    public void sendEmail(Context context, HttpServletRequest request, String recipientEmail, String senderEmail, String message, String page) throws IOException, MessagingException {
        String session = request.getHeader("x-correlation-id");
        String agent = request.getHeader("User-Agent");
        String currentUserEmail = "";
        if (Objects.nonNull(context.getCurrentUser())) {
            currentUserEmail = context.getCurrentUser().getEmail();
        }
        Email email = Email.getEmail(I18nUtil.getEmailFilename(context.getCurrentLocale(), "feedback"));
        email.addRecipient(recipientEmail);
        email.addArgument(new Date());
        email.addArgument(senderEmail);
        email.addArgument(currentUserEmail);
        email.addArgument(page);
        email.addArgument(agent);
        email.addArgument(session);
        email.addArgument(message);
        email.send();
    }
}

