/*
 * Decompiled with CFR 0.152.
 */
package org.drools.util;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.drools.KnowledgeBaseFactoryService;
import org.drools.Service;
import org.drools.SystemEventListenerService;
import org.drools.builder.KnowledgeBuilderFactoryService;
import org.drools.concurrent.ExecutorProvider;
import org.drools.io.ResourceFactoryService;
import org.drools.marshalling.MarshallerProvider;
import org.drools.util.ServiceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceRegistryImpl
implements ServiceRegistry {
    private static ServiceRegistry instance = new ServiceRegistryImpl();
    protected static final transient Logger logger = LoggerFactory.getLogger(ServiceRegistryImpl.class);
    private Map<String, Callable<?>> registry = new HashMap();
    private Map<String, Callable<?>> defaultServices = new HashMap();

    public static synchronized ServiceRegistry getInstance() {
        return instance;
    }

    public ServiceRegistryImpl() {
        this.init();
    }

    @Override
    public synchronized void registerLocator(Class cls, Callable cal) {
        this.registry.put(cls.getName(), cal);
    }

    @Override
    public synchronized void unregisterLocator(Class cls) {
        this.registry.remove(cls.getName());
    }

    synchronized void registerInstance(Service service, Map map) {
        String[] values;
        logger.info("regInstance : " + map);
        for (String v : values = (String[])map.get("objectClass")) {
            logger.info(v);
        }
        this.registry.put(service.getClass().getInterfaces()[0].getName(), new ReturnInstance(service));
    }

    synchronized void unregisterInstance(Service service, Map map) {
        logger.info("unregister : " + map);
        String name = service.getClass().getInterfaces()[0].getName();
        this.registry.remove(name);
        this.registry.put(name, this.defaultServices.get(name));
    }

    @Override
    public synchronized <T> T get(Class<T> cls) {
        Callable<?> cal = this.registry.get(cls.getName());
        if (cal != null) {
            try {
                return cls.cast(cal.call());
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unable to instantiate service for Class '" + (cls != null ? cls.getName() : null) + "'", e);
            }
        }
        cal = this.defaultServices.get(cls.getName());
        try {
            return cls.cast(cal.call());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to instantiate service for Class '" + (cls != null ? cls.getName() : null) + "'", e);
        }
    }

    private void init() {
        this.addDefault(KnowledgeBuilderFactoryService.class, "org.drools.impl.KnowledgeBuilderFactoryServiceImpl");
        this.addDefault(KnowledgeBaseFactoryService.class, "org.drools.impl.KnowledgeBaseFactoryServiceImpl");
        this.addDefault(ResourceFactoryService.class, "org.drools.impl.ResourceFactoryServiceImpl");
        this.addDefault(SystemEventListenerService.class, "org.drools.core.impl.SystemEventListenerServiceImpl");
        this.addDefault(MarshallerProvider.class, "org.drools.core.marshalling.impl.MarshallerProviderImpl");
        this.addDefault(ExecutorProvider.class, "org.drools.core.concurrent.ExecutorProviderImpl");
    }

    @Override
    public synchronized void addDefault(Class cls, String impl) {
        ReflectionInstantiator resourceRi = new ReflectionInstantiator(impl);
        this.defaultServices.put(cls.getName(), resourceRi);
    }

    static class ReturnInstance<V>
    implements Callable<V> {
        private Service service;

        public ReturnInstance(Service service) {
            this.service = service;
        }

        @Override
        public V call() throws Exception {
            return (V)this.service;
        }
    }

    static class ReflectionInstantiator<V>
    implements Callable<V> {
        private String name;

        public ReflectionInstantiator(String name) {
            this.name = name;
        }

        @Override
        public V call() throws Exception {
            return (V)ReflectionInstantiator.newInstance(this.name);
        }

        static <T> T newInstance(String name) {
            try {
                Class<?> cls = Class.forName(name);
                return (T)cls.newInstance();
            }
            catch (Exception e2) {
                throw new IllegalArgumentException("Unable to instantiate '" + name + "'", e2);
            }
        }
    }
}

