/*
 * Decompiled with CFR 0.152.
 */
package org.drools.example.api.kiefilesystem;

import java.io.PrintStream;
import org.drools.example.api.kiefilesystem.Message;
import org.kie.KieServices;
import org.kie.builder.KieBuilder;
import org.kie.builder.KieFileSystem;
import org.kie.builder.KieRepository;
import org.kie.builder.Message;
import org.kie.runtime.KieContainer;
import org.kie.runtime.KieSession;

public class KieFileSystemExample {
    public void go(PrintStream out) {
        KieServices ks = KieServices.Factory.get();
        KieRepository kr = ks.getRepository();
        KieFileSystem kfs = ks.newKieFileSystem();
        kfs.write("src/main/resources/org/kie/example5/HAL5.drl", KieFileSystemExample.getRule());
        KieBuilder kb = ks.newKieBuilder(kfs);
        kb.buildAll();
        if (kb.getResults().hasMessages(new Message.Level[]{Message.Level.ERROR})) {
            throw new RuntimeException("Build Errors:\n" + kb.getResults().toString());
        }
        KieContainer kContainer = ks.newKieContainer(kr.getDefaultReleaseId());
        KieSession kSession = kContainer.newKieSession();
        kSession.setGlobal("out", (Object)out);
        kSession.insert((Object)new Message("Dave", "Hello, HAL. Do you read me, HAL?"));
        kSession.fireAllRules();
    }

    public static void main(String[] args) {
        new KieFileSystemExample().go(System.out);
    }

    private static String getRule() {
        String s = "package org.drools.example.api.kiefilesystem \n\nimport org.drools.example.api.kiefilesystem.Message \n\nglobal java.io.PrintStream out \n\nrule \"rule 1\" when \n    m : Message( ) \nthen \n    out.println( m.getName() + \": \" +  m.getText() ); \nend \nrule \"rule 2\" when \n    Message( text == \"Hello, HAL. Do you read me, HAL?\" ) \nthen \n    insert( new Message(\"HAL\", \"Dave. I read you.\" ) ); \nend";
        return s;
    }
}

