/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.api.model;

import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import java.util.Objects;

public class FactIdentifier {
    private String name;
    private String className;
    @XStreamAsAttribute
    private String importPrefix;
    public static final FactIdentifier INDEX = FactIdentifier.create("#", Integer.class.getCanonicalName());
    public static final FactIdentifier DESCRIPTION = FactIdentifier.create("Scenario description", String.class.getCanonicalName());
    public static final FactIdentifier EMPTY = FactIdentifier.create("Empty", Void.class.getName());

    public static FactIdentifier create(String name, String className) {
        return new FactIdentifier(name, className, null);
    }

    public static FactIdentifier create(String name, String className, String importPrefix) {
        return new FactIdentifier(name, className, importPrefix);
    }

    public FactIdentifier() {
    }

    public FactIdentifier(String name, String className, String importPrefix) {
        this.name = name;
        this.className = className;
        this.importPrefix = importPrefix;
    }

    public String getName() {
        return this.name;
    }

    public String getClassName() {
        return this.className;
    }

    public String getClassNameWithoutPackage() {
        if (this.className.contains(".")) {
            return this.className.substring(this.className.lastIndexOf(".") + 1);
        }
        return this.className;
    }

    public String getPackageWithoutClassName() {
        if (this.className.contains(".")) {
            return this.className.substring(0, this.className.lastIndexOf("."));
        }
        return "";
    }

    public String getImportPrefix() {
        return this.importPrefix;
    }

    public String toString() {
        return "FactIdentifier{name='" + this.name + '\'' + ", className='" + this.className + '\'' + ", importPrefix='" + this.importPrefix + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FactIdentifier that = (FactIdentifier)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.className, that.className) && Objects.equals(this.importPrefix, that.importPrefix);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.className, this.importPrefix);
    }
}

