/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.api.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.drools.scenariosimulation.api.model.ExpressionIdentifier;
import org.drools.scenariosimulation.api.model.FactIdentifier;
import org.drools.scenariosimulation.api.model.FactMapping;

public class ScesimModelDescriptor {
    private final List<FactMapping> factMappings = new ArrayList<FactMapping>();

    public List<FactMapping> getUnmodifiableFactMappings() {
        return Collections.unmodifiableList(this.factMappings);
    }

    public Set<FactIdentifier> getFactIdentifiers() {
        return this.factMappings.stream().map(FactMapping::getFactIdentifier).collect(Collectors.toSet());
    }

    public List<FactMapping> getFactMappings() {
        return this.factMappings;
    }

    public void moveFactMapping(int oldIndex, int newIndex) {
        if (oldIndex < 0 || oldIndex >= this.factMappings.size()) {
            throw new IndexOutOfBoundsException("Index " + oldIndex + " not found in the list");
        }
        if (newIndex < 0 || newIndex >= this.factMappings.size()) {
            throw new IndexOutOfBoundsException("Index " + newIndex + " out of range");
        }
        FactMapping factMapping = this.factMappings.get(oldIndex);
        this.factMappings.remove(oldIndex);
        this.factMappings.add(newIndex, factMapping);
    }

    public FactMapping getFactMappingByIndex(int index) {
        return this.factMappings.get(index);
    }

    void removeFactMappingByIndex(int index) {
        this.factMappings.remove(index);
    }

    void removeFactMapping(FactMapping toRemove) {
        this.factMappings.remove(toRemove);
    }

    public int getIndexByIdentifier(FactIdentifier factIdentifier, ExpressionIdentifier expressionIdentifier) {
        return IntStream.range(0, this.factMappings.size()).filter(index -> {
            FactMapping factMapping = this.factMappings.get(index);
            return factMapping.getExpressionIdentifier().equals(expressionIdentifier) && factMapping.getFactIdentifier().equals(factIdentifier);
        }).findFirst().orElseThrow(() -> new IllegalArgumentException("Impossible to find a FactMapping with factIdentifier '" + factIdentifier.getName() + "' and expressionIdentifier '" + expressionIdentifier.getName() + "'"));
    }

    public List<FactMapping> getFactMappingsByFactName(String factName) {
        return this.internalFilter(e -> e.getFactIdentifier().getName().equalsIgnoreCase(factName));
    }

    public Optional<FactMapping> getFactMapping(FactIdentifier factIdentifier, ExpressionIdentifier ei) {
        List<FactMapping> factMappings = this.internalFilter(e -> e.getExpressionIdentifier().equals(ei) && e.getFactIdentifier().equals(factIdentifier));
        return factMappings.stream().findFirst();
    }

    public FactMapping addFactMapping(int index, FactMapping toClone) {
        FactMapping toReturn = toClone.cloneFactMapping();
        this.factMappings.add(index, toReturn);
        return toReturn;
    }

    public FactMapping addFactMapping(FactIdentifier factIdentifier, ExpressionIdentifier expressionIdentifier) {
        return this.addFactMapping(this.factMappings.size(), factIdentifier, expressionIdentifier);
    }

    public FactMapping addFactMapping(String factAlias, FactIdentifier factIdentifier, ExpressionIdentifier expressionIdentifier) {
        return this.addFactMapping(this.factMappings.size(), factAlias, factIdentifier, expressionIdentifier);
    }

    public FactMapping addFactMapping(int index, FactIdentifier factIdentifier, ExpressionIdentifier expressionIdentifier) {
        return this.addFactMapping(index, factIdentifier.getName(), factIdentifier, expressionIdentifier);
    }

    public FactMapping addFactMapping(int index, String factAlias, FactIdentifier factIdentifier, ExpressionIdentifier expressionIdentifier) {
        if (this.getFactMapping(factIdentifier, expressionIdentifier).isPresent()) {
            throw new IllegalArgumentException("An expression with name '" + expressionIdentifier.getName() + "' already exists for the fact '" + factIdentifier.getName() + "'");
        }
        if (index > this.factMappings.size()) {
            throw new IllegalArgumentException("Impossible to add an element at position " + index + " because there are only " + this.factMappings.size() + " elements");
        }
        FactMapping factMapping = new FactMapping(factAlias, factIdentifier, expressionIdentifier);
        this.factMappings.add(index, factMapping);
        return factMapping;
    }

    public void clear() {
        this.factMappings.clear();
    }

    private List<FactMapping> internalFilter(Predicate<FactMapping> predicate) {
        return this.factMappings.stream().filter(predicate).collect(Collectors.toList());
    }
}

