/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.api.model;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.scenariosimulation.api.model.ScenarioWithIndex;

public class SimulationRunMetadata {
    protected int available;
    protected int executed;
    protected double coveragePercentage;
    protected Map<String, Integer> outputCounter = new HashMap<String, Integer>();
    protected Map<ScenarioWithIndex, List<String>> scenarioCounter = new HashMap<ScenarioWithIndex, List<String>>();
    protected List<ScenarioWithIndex> scenarios;

    public SimulationRunMetadata() {
    }

    public SimulationRunMetadata(int available, int executed, Map<String, Integer> outputCounter, Map<ScenarioWithIndex, List<String>> scenarioCounter) {
        this.available = available;
        this.executed = executed;
        this.outputCounter.putAll(outputCounter);
        this.scenarioCounter.putAll(scenarioCounter);
        this.coveragePercentage = (double)executed / (double)available;
    }

    public int getAvailable() {
        return this.available;
    }

    public int getExecuted() {
        return this.executed;
    }

    public double getCoveragePercentage() {
        return (double)this.executed / (double)this.available * 100.0;
    }

    public Map<String, Integer> getOutputCounter() {
        return this.outputCounter;
    }

    public Map<ScenarioWithIndex, List<String>> getScenarioCounter() {
        return this.scenarioCounter;
    }
}

