/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ruleunits.impl.sessions;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.drools.base.base.ClassObjectType;
import org.drools.base.beliefsystem.Mode;
import org.drools.base.definitions.rule.impl.RuleImpl;
import org.drools.base.factmodel.traits.Thing;
import org.drools.base.factmodel.traits.TraitableBean;
import org.drools.base.rule.Declaration;
import org.drools.base.rule.accessor.GlobalResolver;
import org.drools.core.EntryPointsManager;
import org.drools.core.QueryResultsImpl;
import org.drools.core.RuleSessionConfiguration;
import org.drools.core.SessionConfiguration;
import org.drools.core.WorkingMemory;
import org.drools.core.WorkingMemoryEntryPoint;
import org.drools.core.base.CalendarsImpl;
import org.drools.core.base.DroolsQueryImpl;
import org.drools.core.base.InternalViewChangedEventListener;
import org.drools.core.base.MapGlobalResolver;
import org.drools.core.base.NonCloningQueryViewListener;
import org.drools.core.common.ActivationsManager;
import org.drools.core.common.ConcurrentNodeMemories;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemoryEntryPoint;
import org.drools.core.common.Memory;
import org.drools.core.common.MemoryFactory;
import org.drools.core.common.NodeMemories;
import org.drools.core.common.PhreakPropagationContext;
import org.drools.core.common.PropagationContext;
import org.drools.core.common.PropagationContextFactory;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.event.AgendaEventSupport;
import org.drools.core.event.RuleEventListenerSupport;
import org.drools.core.event.RuleRuntimeEventSupport;
import org.drools.core.impl.ActivationsManagerImpl;
import org.drools.core.impl.InternalRuleBase;
import org.drools.core.phreak.PropagationEntry;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.RuntimeComponentFactory;
import org.drools.core.reteoo.TerminalNode;
import org.drools.core.reteoo.Tuple;
import org.drools.core.rule.accessor.FactHandleFactory;
import org.drools.core.rule.consequence.InternalMatch;
import org.drools.core.rule.consequence.KnowledgeHelper;
import org.drools.core.time.TimerService;
import org.drools.core.util.bitmask.BitMask;
import org.drools.kiesession.consequence.DefaultKnowledgeHelper;
import org.drools.kiesession.consequence.StatefulKnowledgeSessionForRHS;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.ruleunits.api.RuleUnits;
import org.drools.ruleunits.impl.facthandles.RuleUnitDefaultFactHandle;
import org.kie.api.KieBase;
import org.kie.api.runtime.Calendars;
import org.kie.api.runtime.Channel;
import org.kie.api.runtime.KieRuntime;
import org.kie.api.runtime.rule.AgendaFilter;
import org.kie.api.runtime.rule.EntryPoint;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.api.runtime.rule.Match;
import org.kie.api.runtime.rule.QueryResults;
import org.kie.api.time.SessionClock;

public class RuleUnitExecutorImpl
implements ReteEvaluator {
    private final RuleRuntimeEventSupport ruleRuntimeEventSupport = new RuleRuntimeEventSupport();
    private final AtomicLong propagationIdCounter = new AtomicLong(1L);
    private final InternalRuleBase ruleBase;
    private final long identifier;
    private final SessionConfiguration sessionConfiguration;
    private final FactHandleFactory handleFactory;
    private final NodeMemories nodeMemories;
    private final ActivationsManager activationsManager;
    private final EntryPointsManager entryPointsManager;
    private final RuleEventListenerSupport ruleEventListenerSupport = new RuleEventListenerSupport();
    private final GlobalResolver globalResolver = new MapGlobalResolver();
    private final TimerService timerService;
    private Calendars calendars;
    private RuleUnits ruleUnits;

    public RuleUnitExecutorImpl(InternalRuleBase knowledgeBase) {
        this(knowledgeBase, (SessionConfiguration)knowledgeBase.getSessionConfiguration().as(SessionConfiguration.KEY));
    }

    public RuleUnitExecutorImpl(InternalRuleBase knowledgeBase, SessionConfiguration sessionConfiguration) {
        this.ruleBase = knowledgeBase;
        this.identifier = ((InternalKnowledgeBase)this.ruleBase).nextWorkingMemoryCounter();
        this.sessionConfiguration = sessionConfiguration;
        this.handleFactory = knowledgeBase.newFactHandleFactory();
        this.nodeMemories = new ConcurrentNodeMemories(this.ruleBase);
        this.activationsManager = new ActivationsManagerImpl((ReteEvaluator)this);
        this.entryPointsManager = RuntimeComponentFactory.get().getEntryPointFactory().createEntryPointsManager((ReteEvaluator)this);
        this.timerService = sessionConfiguration.createTimerService();
        this.initInitialFact(this.ruleBase);
    }

    private void initInitialFact(InternalRuleBase kBase) {
        WorkingMemoryEntryPoint defaultEntryPoint = this.entryPointsManager.getDefaultEntryPoint();
        InternalFactHandle handle = this.getFactHandleFactory().newInitialFactHandle(defaultEntryPoint);
        ObjectTypeNode otn = (ObjectTypeNode)defaultEntryPoint.getEntryPointNode().getObjectTypeNodes().get(ClassObjectType.InitialFact_ObjectType);
        if (otn != null) {
            PropagationContextFactory ctxFact = RuntimeComponentFactory.get().getPropagationContextFactory();
            PropagationContext pctx = ctxFact.createPropagationContext(0L, PropagationContext.Type.INSERTION, null, null, handle, defaultEntryPoint.getEntryPoint(), null);
            otn.assertInitialFact(handle, pctx, (ReteEvaluator)this);
        }
    }

    public long getIdentifier() {
        return this.identifier;
    }

    public ActivationsManager getActivationsManager() {
        return this.activationsManager;
    }

    public InternalRuleBase getKnowledgeBase() {
        return this.ruleBase;
    }

    public InternalRuleBase getRuleBase() {
        return this.ruleBase;
    }

    public Collection<? extends EntryPoint> getEntryPoints() {
        return this.entryPointsManager.getEntryPoints();
    }

    public WorkingMemoryEntryPoint getEntryPoint(String name) {
        return this.entryPointsManager.getEntryPoint(name);
    }

    public <T extends Memory> T getNodeMemory(MemoryFactory<T> node) {
        return (T)this.nodeMemories.getNodeMemory(node, (ReteEvaluator)this);
    }

    public NodeMemories getNodeMemories() {
        return this.nodeMemories;
    }

    public GlobalResolver getGlobalResolver() {
        return this.globalResolver;
    }

    public FactHandleFactory getFactHandleFactory() {
        return this.handleFactory;
    }

    public InternalFactHandle getFactHandle(Object object) {
        return (InternalFactHandle)this.entryPointsManager.getDefaultEntryPoint().getFactHandle(object);
    }

    public TimerService getTimerService() {
        return this.timerService;
    }

    public void addPropagation(PropagationEntry propagationEntry) {
        this.activationsManager.addPropagation(propagationEntry);
    }

    public long getNextPropagationIdCounter() {
        return this.propagationIdCounter.incrementAndGet();
    }

    public SessionConfiguration getSessionConfiguration() {
        return this.sessionConfiguration;
    }

    public RuleSessionConfiguration getRuleSessionConfiguration() {
        return (RuleSessionConfiguration)this.sessionConfiguration.as(RuleSessionConfiguration.KEY);
    }

    public RuleEventListenerSupport getRuleEventSupport() {
        return this.ruleEventListenerSupport;
    }

    public RuleRuntimeEventSupport getRuleRuntimeEventSupport() {
        return this.ruleRuntimeEventSupport;
    }

    public AgendaEventSupport getAgendaEventSupport() {
        return this.activationsManager.getAgendaEventSupport();
    }

    public long getCurrentTime() {
        return this.timerService.getCurrentTime();
    }

    public Calendars getCalendars() {
        if (this.calendars == null) {
            this.calendars = new CalendarsImpl();
        }
        return this.calendars;
    }

    public SessionClock getSessionClock() {
        return (SessionClock)this.timerService;
    }

    public int fireAllRules() {
        return this.fireAllRules(null, -1);
    }

    public int fireAllRules(int fireLimit) {
        return this.fireAllRules(null, fireLimit);
    }

    public int fireAllRules(AgendaFilter agendaFilter) {
        return this.fireAllRules(agendaFilter, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int fireAllRules(AgendaFilter agendaFilter, int fireLimit) {
        try {
            this.startOperation(ReteEvaluator.InternalOperationType.FIRE);
            int n = this.activationsManager.fireAllRules(agendaFilter, fireLimit);
            return n;
        }
        finally {
            this.endOperation(ReteEvaluator.InternalOperationType.FIRE);
        }
    }

    public FactHandle insert(Object object) {
        return this.getDefaultEntryPoint().insert(object);
    }

    public void dispose() {
        for (WorkingMemoryEntryPoint ep : this.entryPointsManager.getEntryPoints()) {
            ep.dispose();
        }
        this.activationsManager.getAgendaEventSupport().clear();
        this.ruleRuntimeEventSupport.clear();
        this.ruleEventListenerSupport.clear();
        this.timerService.shutdown();
    }

    public QueryResults getQueryResults(String queryName, Object ... arguments) {
        this.activationsManager.flushPropagations();
        DroolsQueryImpl queryObject = new DroolsQueryImpl(queryName, arguments, (InternalViewChangedEventListener)new NonCloningQueryViewListener(), false);
        InternalFactHandle handle = this.handleFactory.newFactHandle((Object)queryObject, null, (ReteEvaluator)this, this.getDefaultEntryPoint());
        PhreakPropagationContext pCtx = new PhreakPropagationContext(this.getNextPropagationIdCounter(), PropagationContext.Type.INSERTION, null, null, handle, this.getDefaultEntryPointId());
        PropagationEntry.ExecuteQuery executeQuery = new PropagationEntry.ExecuteQuery(queryName, queryObject, handle, (PropagationContext)pCtx, false);
        this.addPropagation((PropagationEntry)executeQuery);
        TerminalNode[] terminalNodes = (TerminalNode[])executeQuery.getResult();
        ArrayList<Map> decls = new ArrayList<Map>();
        if (terminalNodes != null) {
            for (TerminalNode node : terminalNodes) {
                decls.add(node.getSubRule().getOuterDeclarations());
            }
        }
        this.handleFactory.destroyFactHandle(handle);
        return new QueryResultsImpl(queryObject.getQueryResultCollector().getResults(), decls.toArray(new Map[decls.size()]), (ReteEvaluator)this, queryObject.getQuery() != null ? queryObject.getQuery().getParameters() : new Declaration[]{});
    }

    public RuleUnits getRuleUnits() {
        return this.ruleUnits;
    }

    public void setRuleUnits(RuleUnits ruleUnits) {
        this.ruleUnits = ruleUnits;
    }

    public KnowledgeHelper createKnowledgeHelper() {
        return new RuleUnitKnowledgeHelper((DefaultKnowledgeHelper)super.createKnowledgeHelper(), this);
    }

    public static class RuleUnitKnowledgeHelper
    implements KnowledgeHelper {
        private final DefaultKnowledgeHelper knowledgeHelper;
        private final RuleUnitExecutorImpl reteEvaluator;

        public RuleUnitKnowledgeHelper(DefaultKnowledgeHelper knowledgeHelper, RuleUnitExecutorImpl reteEvaluator) {
            this.knowledgeHelper = knowledgeHelper;
            this.reteEvaluator = reteEvaluator;
        }

        public void run(String ruleUnitName) {
            this.reteEvaluator.getRuleUnits().getRegisteredInstance(ruleUnitName).fire();
        }

        public void update(FactHandle handle, BitMask mask, Class modifiedClass) {
            InternalFactHandle h = (InternalFactHandle)handle;
            if (h instanceof RuleUnitDefaultFactHandle && ((RuleUnitDefaultFactHandle)h).getDataStore() != null) {
                ((RuleUnitDefaultFactHandle)h).getDataStore().update((RuleUnitDefaultFactHandle)h, h.getObject(), mask, modifiedClass, this.knowledgeHelper.getActivation());
                return;
            }
            ((InternalWorkingMemoryEntryPoint)h.getEntryPoint((ReteEvaluator)this.reteEvaluator)).update(h, ((InternalFactHandle)handle).getObject(), mask, modifiedClass, this.knowledgeHelper.getActivation());
            if (h.isTraitOrTraitable()) {
                this.knowledgeHelper.toStatefulKnowledgeSession().updateTraits(h, mask, modifiedClass, this.knowledgeHelper.getActivation());
            }
        }

        public void delete(FactHandle handle, FactHandle.State fhState) {
            InternalFactHandle h = (InternalFactHandle)handle;
            if (h instanceof RuleUnitDefaultFactHandle && ((RuleUnitDefaultFactHandle)h).getDataStore() != null) {
                ((RuleUnitDefaultFactHandle)h).getDataStore().delete((RuleUnitDefaultFactHandle)h, this.knowledgeHelper.getActivation().getRule(), (TerminalNode)this.knowledgeHelper.getActivation().getTuple().getTupleSink(), fhState);
                return;
            }
            if (h.isTraiting()) {
                this.delete(((Thing)h.getObject()).getCore());
                return;
            }
            h.getEntryPoint((ReteEvaluator)this.reteEvaluator).delete(handle, this.knowledgeHelper.getActivation().getRule(), (TerminalNode)this.knowledgeHelper.getActivation().getTuple().getTupleSink(), fhState);
        }

        public Declaration[] getRequiredDeclarations() {
            return this.knowledgeHelper.getRequiredDeclarations();
        }

        public RuleImpl getRule() {
            return this.knowledgeHelper.getRule();
        }

        public Tuple getTuple() {
            return this.knowledgeHelper.getTuple();
        }

        public WorkingMemory getWorkingMemory() {
            return this.knowledgeHelper.getWorkingMemory();
        }

        public KieRuntime getKnowledgeRuntime() {
            return this.knowledgeHelper.getKnowledgeRuntime();
        }

        public StatefulKnowledgeSessionForRHS toStatefulKnowledgeSession() {
            return this.knowledgeHelper.toStatefulKnowledgeSession();
        }

        public InternalMatch getMatch() {
            return this.knowledgeHelper.getMatch();
        }

        public void setFocus(String focus) {
            this.knowledgeHelper.setFocus(focus);
        }

        public Object get(Declaration declaration) {
            return this.knowledgeHelper.get(declaration);
        }

        public Declaration getDeclaration(String identifier) {
            return this.knowledgeHelper.getDeclaration(identifier);
        }

        public void halt() {
            this.knowledgeHelper.halt();
        }

        public EntryPoint getEntryPoint(String id) {
            return this.knowledgeHelper.getEntryPoint(id);
        }

        public Channel getChannel(String id) {
            return this.knowledgeHelper.getChannel(id);
        }

        public Map<String, Channel> getChannels() {
            return this.knowledgeHelper.getChannels();
        }

        public static InternalFactHandle getFactHandleFromWM(ReteEvaluator reteEvaluator, Object object) {
            return DefaultKnowledgeHelper.getFactHandleFromWM((ReteEvaluator)reteEvaluator, (Object)object);
        }

        public <T> T getContext(Class<T> contextClass) {
            return (T)this.knowledgeHelper.getContext(contextClass);
        }

        public KieRuntime getKieRuntime() {
            return this.knowledgeHelper.getKieRuntime();
        }

        public <T, K> T don(Thing<K> core, Class<T> trait, boolean logical, Mode ... modes) {
            return (T)this.knowledgeHelper.don(core, trait, logical, modes);
        }

        public <T, K> T don(K core, Class<T> trait) {
            return (T)this.knowledgeHelper.don(core, trait);
        }

        public <T, K> T don(Thing<K> core, Class<T> trait) {
            return (T)this.knowledgeHelper.don(core, trait);
        }

        public <T, K> T don(K core, Collection<Class<? extends Thing>> traits) {
            return (T)this.knowledgeHelper.don(core, traits);
        }

        public <T, K> Thing<K> shed(Thing<K> thing, Class<T> trait) {
            return this.knowledgeHelper.shed(thing, trait);
        }

        public <T, K> T don(K core, Collection<Class<? extends Thing>> traits, Mode ... modes) {
            return (T)this.knowledgeHelper.don(core, traits, modes);
        }

        public <T, K> T don(K core, Collection<Class<? extends Thing>> traits, boolean logical) {
            return (T)this.knowledgeHelper.don(core, traits, logical);
        }

        public <T, K> T don(K core, Class<T> trait, boolean logical) {
            return (T)this.knowledgeHelper.don(core, trait, logical);
        }

        public <T, K> T don(K core, Class<T> trait, Mode ... modes) {
            return (T)this.knowledgeHelper.don(core, trait, modes);
        }

        public <T, K, X extends TraitableBean> Thing<K> shed(TraitableBean<K, X> core, Class<T> trait) {
            return this.knowledgeHelper.shed(core, trait);
        }

        public ClassLoader getProjectClassLoader() {
            return this.knowledgeHelper.getProjectClassLoader();
        }

        public KieBase getKieBase() {
            return this.knowledgeHelper.getKieBase();
        }

        public void run(Object ruleUnit) {
            this.knowledgeHelper.run(ruleUnit);
        }

        public void run(Class<?> ruleUnitClass) {
            this.knowledgeHelper.run(ruleUnitClass);
        }

        public void guard(Object ruleUnit) {
            this.knowledgeHelper.guard(ruleUnit);
        }

        public void guard(Class<?> ruleUnitClass) {
            this.knowledgeHelper.guard(ruleUnitClass);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.knowledgeHelper.readExternal(in);
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            this.knowledgeHelper.writeExternal(out);
        }

        public void setActivation(InternalMatch internalMatch) {
            this.knowledgeHelper.setActivation(internalMatch);
        }

        public InternalMatch getActivation() {
            return this.knowledgeHelper.getActivation();
        }

        public void reset() {
            this.knowledgeHelper.reset();
        }

        public void blockMatch(Match act) {
            this.knowledgeHelper.blockMatch(act);
        }

        public void unblockAllMatches(Match act) {
            this.knowledgeHelper.unblockAllMatches(act);
        }

        public FactHandle insertAsync(Object object) {
            return this.knowledgeHelper.insertAsync(object);
        }

        public FactHandle insert(Object object) {
            return this.knowledgeHelper.insert(object);
        }

        public FactHandle insert(Object object, boolean dynamic) {
            return this.knowledgeHelper.insert(object, dynamic);
        }

        public FactHandle insertLogical(Object object, Mode belief) {
            return this.knowledgeHelper.insertLogical(object, belief);
        }

        public FactHandle insertLogical(Object object, Mode ... beliefs) {
            return this.knowledgeHelper.insertLogical(object, beliefs);
        }

        public FactHandle insertLogical(Object object) {
            return this.knowledgeHelper.insertLogical(object);
        }

        public FactHandle insertLogical(Object object, Object value) {
            return this.knowledgeHelper.insertLogical(object, value);
        }

        public FactHandle insertLogical(EntryPoint ep, Object object) {
            return this.knowledgeHelper.insertLogical(ep, object);
        }

        public InternalFactHandle bolster(Object object) {
            return this.knowledgeHelper.bolster(object);
        }

        public FactHandle bolster(Object object, Object value) {
            return this.knowledgeHelper.bolster(object, value);
        }

        public void cancelMatch(Match act) {
            this.knowledgeHelper.cancelMatch(act);
        }

        public FactHandle getFactHandle(Object object) {
            return this.knowledgeHelper.getFactHandle(object);
        }

        public FactHandle getFactHandle(FactHandle handle) {
            return this.knowledgeHelper.getFactHandle(handle);
        }

        public void update(FactHandle handle, Object newObject) {
            this.knowledgeHelper.update(handle, newObject);
        }

        public void update(FactHandle handle) {
            this.knowledgeHelper.update(handle);
        }

        public void update(Object object) {
            this.knowledgeHelper.update(object);
        }

        public void update(Object object, BitMask mask, Class<?> modifiedClass) {
            this.knowledgeHelper.update(object, mask, modifiedClass);
        }

        public void retract(Object object) {
            this.knowledgeHelper.retract(object);
        }

        public void retract(FactHandle handle) {
            this.knowledgeHelper.retract(handle);
        }

        public void delete(Object object) {
            this.knowledgeHelper.delete(object);
        }

        public void delete(Object object, FactHandle.State fhState) {
            this.knowledgeHelper.delete(object, fhState);
        }

        public void delete(FactHandle handle) {
            this.knowledgeHelper.delete(handle);
        }
    }
}

