/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ruleunits.impl.datasources;

import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.reteoo.TerminalNode;
import org.drools.core.rule.consequence.Activation;
import org.drools.core.util.bitmask.BitMask;
import org.drools.ruleunits.api.DataHandle;
import org.drools.ruleunits.api.DataProcessor;
import org.drools.ruleunits.api.DataStore;
import org.drools.ruleunits.impl.InternalStoreCallback;
import org.drools.ruleunits.impl.datasources.AbstractDataSource;
import org.drools.ruleunits.impl.facthandles.RuleUnitInternalFactHandle;
import org.drools.ruleunits.impl.factory.DataHandleImpl;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.api.runtime.rule.RuleContext;

public class ListDataStore<T>
extends AbstractDataSource<T>
implements Iterable<T>,
DataStore<T>,
InternalStoreCallback {
    private final Map<T, DataHandle> store = new IdentityHashMap<T, DataHandle>();

    protected ListDataStore() {
    }

    @Override
    public Iterator<T> iterator() {
        return this.store.keySet().iterator();
    }

    public DataHandle add(T t) {
        DataHandle dh = this.createDataHandle(t);
        this.store.put(t, dh);
        this.forEachSubscriber(s -> this.internalInsert(dh, (DataProcessor)s));
        return dh;
    }

    @Override
    public void addLogical(RuleContext ruleContext, Object object) {
        this.entryPointSubscribers.forEach(eps -> eps.insertLogical(ruleContext, object));
    }

    public DataHandle findHandle(long id) {
        for (DataHandle dh : this.store.values()) {
            DataHandleImpl dhi = (DataHandleImpl)dh;
            if (dhi.getId() != id) continue;
            return dh;
        }
        throw new IllegalArgumentException("Cannot find id");
    }

    protected DataHandle createDataHandle(T t) {
        return new DataHandleImpl(t);
    }

    @Override
    public DataHandle lookup(Object object) {
        return this.store.get(object);
    }

    public void remove(T object) {
        this.remove(this.lookup(object));
    }

    public void remove(DataHandle handle) {
        this.forEachSubscriber(s -> s.delete(handle));
        this.store.remove(handle.getObject());
    }

    @Override
    public void subscribe(DataProcessor processor) {
        super.subscribe(processor);
        this.store.values().forEach(dh -> this.internalInsert((DataHandle)dh, processor));
    }

    public void update(DataHandle handle, T object) {
        this.switchObjectOnDataHandle(handle, object);
        this.forEachSubscriber(s -> s.update(handle, object));
    }

    @Override
    public void update(RuleUnitInternalFactHandle fh, Object obj, BitMask mask, Class<?> modifiedClass, Activation activation) {
        this.update(fh.getDataHandle(), obj, mask, modifiedClass, activation);
    }

    @Override
    public void update(DataHandle dh, Object obj, BitMask mask, Class<?> modifiedClass, Activation activation) {
        this.switchObjectOnDataHandle(dh, obj);
        this.entryPointSubscribers.forEach(s -> s.update(dh, obj, mask, modifiedClass, activation));
        this.subscribers.forEach(s -> s.update(dh, obj));
    }

    private void switchObjectOnDataHandle(DataHandle handle, T object) {
        if (handle.getObject() != object) {
            this.store.remove(handle.getObject());
            ((DataHandleImpl)handle).setObject(object);
            this.store.put(object, handle);
        }
    }

    @Override
    public void delete(RuleUnitInternalFactHandle fh, RuleImpl rule, TerminalNode terminalNode, FactHandle.State fhState) {
        DataHandle dh = fh.getDataHandle();
        this.entryPointSubscribers.forEach(s -> s.delete(dh, rule, terminalNode, fhState));
        this.subscribers.forEach(s -> s.delete(dh));
        this.store.remove(fh.getObject());
    }

    private void internalInsert(DataHandle dh, DataProcessor s) {
        FactHandle fh = s.insert(dh, dh.getObject());
        if (fh != null) {
            ((RuleUnitInternalFactHandle)fh).setDataStore(this);
            ((RuleUnitInternalFactHandle)fh).setDataHandle(dh);
        }
    }
}

